/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestErrorThrowableInQuery
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("task_concurrency", "1").setCatalog("mock").setSchema("default").setClientInfo("{\"clientVersion\":\"testVersion\"}").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            queryRunner.installPlugin(new Plugin(this){

                public Iterable<ConnectorFactory> getConnectorFactories() {
                    SchemaTableName stackOverflowErrorTableName = new SchemaTableName("default", "stack_overflow_during_planning");
                    SchemaTableName classFormatErrorTableName = new SchemaTableName("default", "class_format_error_during_planning");
                    MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListTables((session, s) -> ImmutableList.of((Object)stackOverflowErrorTableName.getTableName())).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("test_varchar", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("test_bigint", (Type)BigintType.BIGINT))).withGetTableHandle((session, schemaTableName) -> new MockConnectorTableHandle(schemaTableName)).withApplyProjection((session, handle, projections, assignments) -> {
                        MockConnectorTableHandle mockTableHandle = (MockConnectorTableHandle)handle;
                        if (stackOverflowErrorTableName.equals((Object)mockTableHandle.getTableName())) {
                            throw new StackOverflowError("We run out of stack!!!!!!!!!!!");
                        }
                        if (classFormatErrorTableName.equals((Object)mockTableHandle.getTableName())) {
                            throw new ClassFormatError("Bad class format!!!!!!!!!!");
                        }
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Unknown table: " + String.valueOf(mockTableHandle.getTableName()));
                    }).build();
                    return ImmutableList.of((Object)connectorFactory);
                }
            });
            queryRunner.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
        return queryRunner;
    }

    @Test
    public void testSystemRuntimeQueriesWorksAfterStackOverflowErrorDuringAnalyzeInExplain() throws Exception {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("EXPLAIN SELECT test_varchar FROM stack_overflow_during_planning"))).failure().hasMessageContaining("statement is too large (stack overflow during analysis)");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM system.runtime.queries"))).result().rowCount().isGreaterThan(0);
    }

    @Test
    public void testSystemRuntimeQueriesWorksAfterClassFormatErrorDuringAnalyzeInExplain() throws Exception {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("EXPLAIN SELECT test_varchar FROM class_format_error_during_planning"))).nonTrinoExceptionFailure().hasMessageContaining("java.lang.ClassFormatError: Bad class format!!!!!!!!!!");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM system.runtime.queries"))).result().rowCount().isGreaterThan(0);
    }
}

