/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.Resources;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.inject.Provider;
import io.airlift.json.JsonCodec;
import io.airlift.json.JsonCodecFactory;
import io.airlift.json.ObjectMapperProvider;
import io.trino.Session;
import io.trino.common.assertions.TrinoAssertions;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.cost.PlanNodeStatsAndCostSummary;
import io.trino.cost.StatsAndCosts;
import io.trino.execution.EventsAwaitingQueries;
import io.trino.execution.EventsCollector;
import io.trino.execution.QueryStats;
import io.trino.execution.TestEventListenerPlugin;
import io.trino.execution.TestQueues;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.eventlistener.ColumnDetail;
import io.trino.spi.eventlistener.ColumnInfo;
import io.trino.spi.eventlistener.OutputColumnMetadata;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryFailureInfo;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryOutputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.RoutineInfo;
import io.trino.spi.eventlistener.TableInfo;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolKeyDeserializer;
import io.trino.sql.planner.planprinter.JsonRenderer;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.type.TypeDeserializer;
import io.trino.type.TypeSignatureKeyDeserializer;
import java.io.File;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestEventListenerBasic
extends AbstractTestQueryFramework {
    private static final JsonCodec<Map<String, JsonRenderer.JsonRenderedNode>> ANONYMIZED_PLAN_JSON_CODEC = JsonCodec.mapJsonCodec(String.class, JsonRenderer.JsonRenderedNode.class);
    private static final String IGNORE_EVENT_MARKER = " -- ignore_generated_event";
    private static final String VARCHAR_TYPE = "varchar(15)";
    private static final String BIGINT_TYPE = BigintType.BIGINT.getDisplayName();
    private static final Metrics TEST_METRICS = new Metrics((Map)ImmutableMap.of((Object)"test_metrics", (Object)new LongCount(1L)));
    private EventsAwaitingQueries queries;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("task_concurrency", "1").setCatalog("tpch").setSchema("tiny").setClientInfo("{\"clientVersion\":\"testVersion\"}").build();
        EventsCollector generatedEvents = new EventsCollector();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.installPlugin((Plugin)new TestEventListenerPlugin.TestingEventListenerPlugin(generatedEvents));
        queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        queryRunner.installPlugin(new Plugin(this){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListTables((session, schemaName) -> switch (schemaName) {
                    case "default" -> List.of("tests_table");
                    case "tiny" -> List.of("nation");
                    default -> List.of();
                }).withGetColumns(schemaTableName -> {
                    if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation")) || schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_storage"))) {
                        return MockConnectorEntities.TPCH_NATION_SCHEMA;
                    }
                    if (schemaTableName.equals((Object)new SchemaTableName("default", "test_materialized_view_stale$materialized_view_storage"))) {
                        return ImmutableList.of((Object)new ColumnMetadata("test_column", (Type)BigintType.BIGINT));
                    }
                    return ImmutableList.of((Object)new ColumnMetadata("test_varchar", (Type)VarcharType.createVarcharType((int)15)), (Object)new ColumnMetadata("test_bigint", (Type)BigintType.BIGINT));
                }).withGetTableHandle((session, schemaTableName) -> {
                    if (!schemaTableName.getTableName().startsWith("create")) {
                        return new MockConnectorTableHandle(schemaTableName);
                    }
                    return null;
                }).withApplyProjection((session, handle, projections, assignments) -> {
                    if (((MockConnectorTableHandle)handle).getTableName().getTableName().equals("tests_table")) {
                        throw new RuntimeException("Throw from apply projection");
                    }
                    return Optional.empty();
                }).withGetViews((connectorSession, prefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "test_view"), (Object)new ConnectorViewDefinition("SELECT nationkey AS test_column FROM tpch.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()), (Object)new SchemaTableName("default", "test_view_nesting"), (Object)new ConnectorViewDefinition("SELECT test_column FROM mock.default.test_view", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()), (Object)new SchemaTableName("default", "test_view_with_row_filter"), (Object)new ConnectorViewDefinition("SELECT test_varchar AS test_column FROM mock.default.test_table_with_row_filter", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", VarcharType.createVarcharType((int)15).getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()), (Object)new SchemaTableName("default", "test_view_with_redirect"), (Object)new ConnectorViewDefinition("SELECT nationkey AS test_column FROM mock.default.nation_redirect", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()))).withGetMaterializedViews((connectorSession, prefix) -> {
                    ConnectorMaterializedViewDefinition definitionStale = new ConnectorMaterializedViewDefinition("SELECT nationkey AS test_column FROM tpch.tiny.nation", Optional.of(new CatalogSchemaTableName("mock", "default", "test_materialized_view_stale$materialized_view_storage")), Optional.of("mock"), Optional.of("default"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of("alice"), (List)ImmutableList.of());
                    ConnectorMaterializedViewDefinition definitionFresh = new ConnectorMaterializedViewDefinition("SELECT * FROM tpch.tiny.nation", Optional.of(new CatalogSchemaTableName("mock", "tiny", "nation")), Optional.empty(), Optional.empty(), (List)MockConnectorEntities.TPCH_NATION_SCHEMA.stream().map(column -> new ConnectorMaterializedViewDefinition.Column(column.getName(), column.getType().getTypeId(), Optional.empty())).collect(ImmutableList.toImmutableList()), Optional.of(Duration.ofDays(1L)), Optional.empty(), Optional.of("alice"), (List)ImmutableList.of());
                    return ImmutableMap.of((Object)new SchemaTableName("default", "test_materialized_view_stale"), (Object)definitionStale, (Object)new SchemaTableName("default", "test_materialized_view_fresh"), (Object)definitionFresh);
                }).withData(schemaTableName -> {
                    if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation")) || schemaTableName.equals((Object)new SchemaTableName("tiny", "nation_storage"))) {
                        return MockConnectorEntities.TPCH_NATION_DATA;
                    }
                    return ImmutableList.of();
                }).withMetrics(schemaTableName -> {
                    if (schemaTableName.equals((Object)new SchemaTableName("tiny", "nation"))) {
                        return TEST_METRICS;
                    }
                    return Metrics.EMPTY;
                }).withRowFilter(schemaTableName -> {
                    if (schemaTableName.getTableName().equals("test_table_with_row_filter")) {
                        return ViewExpression.builder().identity("user").catalog("tpch").schema("tiny").expression("EXISTS (SELECT 1 FROM nation WHERE name = test_varchar)").build();
                    }
                    return null;
                }).withColumnMask((schemaTableName, columnName) -> {
                    if (schemaTableName.getTableName().equals("test_table_with_column_mask") && columnName.equals("test_varchar")) {
                        return ViewExpression.builder().identity("user").catalog("tpch").schema("tiny").expression("(SELECT cast(max(orderkey) AS varchar(15)) FROM orders)").build();
                    }
                    return null;
                }).withRedirectTable((session, schemaTableName) -> {
                    if (schemaTableName.getTableName().equals("nation_redirect")) {
                        return Optional.of(new CatalogSchemaTableName("tpch", "tiny", "nation"));
                    }
                    return Optional.empty();
                }).build();
                return ImmutableList.of((Object)connectorFactory);
            }
        });
        queryRunner.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_simple.json")));
        this.queries = new EventsAwaitingQueries(generatedEvents, (QueryRunner)queryRunner);
        return queryRunner;
    }

    private String getResourceFilePath(String fileName) {
        try {
            return new File(Resources.getResource((String)fileName).toURI()).getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private EventsAwaitingQueries.MaterializedResultWithEvents runQueryAndWaitForEvents(@Language(value="SQL") String sql) throws Exception {
        return this.queries.runQueryAndWaitForEvents(sql, this.getSession());
    }

    @Test
    public void testAnalysisFailure() throws Exception {
        this.assertFailedQuery("EXPLAIN (TYPE IO) SELECT sum(bogus) FROM lineitem", "line 1:30: Column 'bogus' cannot be resolved");
    }

    @Test
    public void testParseError() throws Exception {
        this.assertFailedQuery("You shall not parse!", "line 1:1: mismatched input 'You'. Expecting: 'ALTER', 'ANALYZE', 'CALL', 'COMMENT', 'COMMIT', 'CREATE', 'DEALLOCATE', 'DELETE', 'DENY', 'DESC', 'DESCRIBE', 'DROP', 'EXECUTE', 'EXPLAIN', 'GRANT', 'INSERT', 'MERGE', 'PREPARE', 'REFRESH', 'RESET', 'REVOKE', 'ROLLBACK', 'SET', 'SHOW', 'START', 'TRUNCATE', 'UPDATE', 'USE', 'WITH', <query>");
    }

    @Test
    public void testPlanningFailure() throws Exception {
        this.assertFailedQuery("SELECT lower(test_varchar) FROM mock.default.tests_table", "Throw from apply projection");
    }

    @Test
    public void testAbortedWhileWaitingForResources() throws Exception {
        Session mySession = Session.builder((Session)this.getSession()).setSystemProperty("required_workers_count", "17").setSystemProperty("required_workers_max_wait_time", "10ms").build();
        this.assertFailedQuery(mySession, "SELECT * FROM tpch.sf1.nation", "Insufficient active worker nodes. Waited 10.00ms for at least 17 workers, but only 1 workers are active");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testKilledWhileWaitingForResources() throws Exception {
        String testQueryMarker = "test_query_id_" + UUID.randomUUID().toString().replace("-", "");
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        try {
            Session mySession = Session.builder((Session)this.getSession()).setSystemProperty("required_workers_count", "17").setSystemProperty("required_workers_max_wait_time", "5m").build();
            String sql = String.format("SELECT nationkey AS %s  FROM tpch.sf1.nation", testQueryMarker);
            executorService.submit(() -> {
                Optional<String> queryIdValue = this.findQueryId(testQueryMarker);
                ((OptionalAssert)Assertions.assertThat(queryIdValue).as("query id", new Object[0])).isPresent();
                this.getQueryRunner().execute(String.format("CALL system.runtime.kill_query('%s', 'because') %s", queryIdValue.get(), IGNORE_EVENT_MARKER));
                return null;
            });
            this.assertFailedQuery(mySession, sql, "Query killed. Message: because");
        }
        finally {
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)executorService, (Duration)Duration.ZERO);
        }
    }

    @Test
    public void testWithInvalidExecutionPolicy() throws Exception {
        Session mySession = Session.builder((Session)this.getSession()).setSystemProperty("execution_policy", "invalid_as_hell").build();
        this.assertFailedQuery(mySession, "SELECT 1", "No execution policy invalid_as_hell");
    }

    private Optional<String> findQueryId(String queryPattern) throws InterruptedException {
        Optional queryIdValue = Optional.empty();
        while (queryIdValue.isEmpty()) {
            queryIdValue = (Optional)this.computeActual("SELECT query_id FROM system.runtime.queries WHERE query LIKE '%" + queryPattern + "%' AND query NOT LIKE '%system.runtime.queries%' -- ignore_generated_event").getOnlyColumn().map(String.class::cast).collect(MoreCollectors.toOptional());
            Thread.sleep(50L);
        }
        return queryIdValue;
    }

    private void assertFailedQuery(@Language(value="SQL") String sql, String expectedFailure) throws Exception {
        this.assertFailedQuery(this.getSession(), sql, expectedFailure);
    }

    private void assertFailedQuery(Session session, @Language(value="SQL") String sql, String expectedFailure) throws Exception {
        EventsCollector.QueryEvents queryEvents = this.queries.runQueryAndWaitForEvents(sql, session, Optional.of(expectedFailure)).getQueryEvents();
        QueryCompletedEvent queryCompletedEvent = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)queryCompletedEvent.getMetadata().getQuery()).isEqualTo(sql);
        QueryFailureInfo failureInfo = (QueryFailureInfo)queryCompletedEvent.getFailureInfo().orElseThrow(() -> new AssertionError((Object)"Expected query event to be failed"));
        Assertions.assertThat((String)expectedFailure).isEqualTo((String)failureInfo.getFailureMessage().orElse(null));
    }

    @Test
    public void testReferencedTablesAndRoutines() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT sum(linenumber) FROM lineitem").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        TableInfo table = (TableInfo)Iterables.getOnlyElement((Iterable)event.getMetadata().getTables());
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "lineitem").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("linenumber").hasNoRowFilters().hasNoTableReferences();
        RoutineInfo routine = (RoutineInfo)Iterables.getOnlyElement((Iterable)event.getMetadata().getRoutines());
        Assertions.assertThat((String)routine.getRoutine()).isEqualTo("sum");
        Assertions.assertThat((String)routine.getAuthorization()).isEqualTo("user");
    }

    @Test
    public void testReferencedTablesWithViews() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT test_column FROM mock.default.test_view").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_view").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("test_column").hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesWithMaterializedViewsStale() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT test_column FROM mock.default.test_materialized_view_stale").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("alice").isNotDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asMaterializedViewInfo().hasCatalogSchemaView("mock", "default", "test_materialized_view_stale"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_materialized_view_stale").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("test_column").hasNoRowFilters().hasNoTableReferences().hasViewText("SELECT nationkey AS test_column FROM tpch.tiny.nation");
    }

    @Test
    public void testReferencedTablesWithMaterializedViewsFresh() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT nationkey FROM mock.default.test_materialized_view_fresh").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("alice").isNotDirectlyReferenced().hasColumnsWithoutMasking("nationkey", "regionkey", "name", "comment").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asMaterializedViewInfo().hasCatalogSchemaView("mock", "default", "test_materialized_view_fresh"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_materialized_view_fresh").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasNoTableReferences().hasViewText("SELECT * FROM tpch.tiny.nation");
    }

    @Test
    public void testReferencedTablesWithViewsAndRedirection() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT test_column FROM mock.default.test_view_with_redirect").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view_with_redirect"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_view_with_redirect").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("test_column").hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesInCreateView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE VIEW mock.default.create_another_test_view AS SELECT * FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("create_another_test_view");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("nationkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey"))), new OutputColumnMetadata("name", "varchar(25)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("regionkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "regionkey"))), new OutputColumnMetadata("comment", "varchar(152)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "comment")))});
        List tables = event.getMetadata().getTables();
        TrinoAssertions.assertThat((TableInfo)Iterables.getOnlyElement((Iterable)tables)).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("nationkey", "regionkey", "name", "comment").hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesInCreateMaterializedView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE MATERIALIZED VIEW mock.default.test_view AS SELECT * FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("test_view");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("nationkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey"))), new OutputColumnMetadata("name", "varchar(25)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("regionkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "regionkey"))), new OutputColumnMetadata("comment", "varchar(152)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "comment")))});
        List tables = event.getMetadata().getTables();
        TrinoAssertions.assertThat((TableInfo)Iterables.getOnlyElement((Iterable)tables)).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("nationkey", "regionkey", "name", "comment").hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesInRefreshMaterializedView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("REFRESH MATERIALIZED VIEW mock.default.test_materialized_view_stale").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("test_materialized_view_stale");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_column", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey")))});
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(1);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesWithRowFilter() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT 1 FROM mock.default.test_table_with_row_filter").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("name").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asRowFilterInfo().hasTargetCatalogSchemaTable("mock", "default", "test_table_with_row_filter").hasExpression("(EXISTS (SELECT 1 FROM nation WHERE (name = test_varchar)))"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_table_with_row_filter").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking("test_varchar").hasRowFilters("(EXISTS (SELECT 1 FROM nation WHERE (name = test_varchar)))").hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesWithNestedView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT 1 FROM mock.default.test_view_nesting").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(3);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("nationkey").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view"), tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view_nesting"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_view").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("test_column").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view_nesting"));
        table = (TableInfo)tables.get(2);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_view_nesting").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking(new String[0]).hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesWithRowFilterAndView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT 1 FROM mock.default.test_view_with_row_filter").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(3);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "nation").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("name").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asRowFilterInfo().hasTargetCatalogSchemaTable("mock", "default", "test_table_with_row_filter").hasExpression("(EXISTS (SELECT 1 FROM nation WHERE (name = test_varchar)))"), tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view_with_row_filter"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_table_with_row_filter").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("test_varchar").hasRowFilters("(EXISTS (SELECT 1 FROM nation WHERE (name = test_varchar)))").hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asViewInfo().hasCatalogSchemaView("mock", "default", "test_view_with_row_filter"));
        table = (TableInfo)tables.get(2);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_view_with_row_filter").hasAuthorization("user").isDirectlyReferenced().hasColumnsWithoutMasking(new String[0]).hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedTablesWithColumnMask() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_table_with_referring_mask AS SELECT * FROM mock.default.test_table_with_column_mask").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("create_table_with_referring_mask");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("mock", "default", "test_table_with_column_mask", "test_varchar"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("mock", "default", "test_table_with_column_mask", "test_bigint")))});
        List tables = event.getMetadata().getTables();
        Assertions.assertThat((List)tables).hasSize(2);
        TableInfo table = (TableInfo)tables.get(0);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("tpch", "tiny", "orders").hasAuthorization("user").isNotDirectlyReferenced().hasColumnsWithoutMasking("orderkey").hasNoRowFilters().hasTableReferencesSatisfying(tableRef -> TrinoAssertions.assertThat(tableRef).asColumnMaskInfo().hasTargetCatalogSchemaTable("mock", "default", "test_table_with_column_mask").hasExpression("(SELECT CAST(max(orderkey) AS varchar(15)) FROM orders)").hasTargetColumn("test_varchar"));
        table = (TableInfo)tables.get(1);
        TrinoAssertions.assertThat(table).hasCatalogSchemaTable("mock", "default", "test_table_with_column_mask").hasAuthorization("user").isDirectlyReferenced().hasColumnNames("test_varchar", "test_bigint").hasColumnMasks("(SELECT CAST(max(orderkey) AS varchar(15)) FROM orders)", null).hasNoRowFilters().hasNoTableReferences();
    }

    @Test
    public void testReferencedColumns() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT name, nationkey FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        TableInfo table = (TableInfo)Iterables.getOnlyElement((Iterable)event.getMetadata().getTables());
        Assertions.assertThat((Collection)((Collection)table.getColumns().stream().map(ColumnInfo::getColumn).collect(ImmutableSet.toImmutableSet()))).isEqualTo((Object)ImmutableSet.of((Object)"name", (Object)"nationkey"));
        queryEvents = this.runQueryAndWaitForEvents("SELECT name, nationkey FROM nation n").getQueryEvents();
        event = queryEvents.getQueryCompletedEvent();
        table = (TableInfo)Iterables.getOnlyElement((Iterable)event.getMetadata().getTables());
        Assertions.assertThat((Collection)((Collection)table.getColumns().stream().map(ColumnInfo::getColumn).collect(ImmutableSet.toImmutableSet()))).isEqualTo((Object)ImmutableSet.of((Object)"name", (Object)"nationkey"));
        queryEvents = this.runQueryAndWaitForEvents("SELECT a, b FROM nation n(a, b, c, d)").getQueryEvents();
        event = queryEvents.getQueryCompletedEvent();
        table = (TableInfo)Iterables.getOnlyElement((Iterable)event.getMetadata().getTables());
        Assertions.assertThat((Collection)((Collection)table.getColumns().stream().map(ColumnInfo::getColumn).collect(ImmutableSet.toImmutableSet()))).isEqualTo((Object)ImmutableSet.of((Object)"name", (Object)"nationkey"));
    }

    @Test
    public void testPrepareAndExecute() throws Exception {
        String selectQuery = "SELECT count(*) FROM lineitem WHERE shipmode = ?";
        String prepareQuery = "PREPARE stmt FROM " + selectQuery;
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents(prepareQuery).getQueryEvents();
        QueryCreatedEvent queryCreatedEvent = queryEvents.getQueryCreatedEvent();
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerVersion()).isEqualTo("testversion");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getEnvironment()).isEqualTo("testing");
        Assertions.assertThat((String)((String)queryCreatedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQuery()).isEqualTo(prepareQuery);
        Assertions.assertThat((Optional)queryCreatedEvent.getMetadata().getPreparedQuery()).isEmpty();
        QueryCompletedEvent queryCompletedEvent = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((Optional)queryCompletedEvent.getContext().getResourceGroupId()).isPresent();
        Assertions.assertThat((Object)((ResourceGroupId)queryCompletedEvent.getContext().getResourceGroupId().get())).isEqualTo((Object)TestQueues.createResourceGroupId("global", "user-user"));
        Assertions.assertThat((Optional)queryCompletedEvent.getIoMetadata().getOutput()).isEqualTo(Optional.empty());
        Assertions.assertThat((List)queryCompletedEvent.getIoMetadata().getInputs()).isEmpty();
        Assertions.assertThat((String)((String)queryCompletedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQueryId()).isEqualTo(queryCompletedEvent.getMetadata().getQueryId());
        Assertions.assertThat((Optional)queryCompletedEvent.getMetadata().getPreparedQuery()).isEmpty();
        Assertions.assertThat((int)queryCompletedEvent.getStatistics().getCompletedSplits()).isEqualTo(0);
        Session sessionWithPrepare = Session.builder((Session)this.getSession()).addPreparedStatement("stmt", selectQuery).build();
        queryEvents = this.queries.runQueryAndWaitForEvents("EXECUTE stmt USING 'SHIP'", sessionWithPrepare).getQueryEvents();
        queryCreatedEvent = queryEvents.getQueryCreatedEvent();
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerVersion()).isEqualTo("testversion");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getEnvironment()).isEqualTo("testing");
        Assertions.assertThat((String)((String)queryCreatedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQuery()).isEqualTo("EXECUTE stmt USING 'SHIP'");
        Assertions.assertThat((Optional)queryCreatedEvent.getMetadata().getPreparedQuery()).isPresent();
        Assertions.assertThat((String)((String)queryCreatedEvent.getMetadata().getPreparedQuery().get())).isEqualTo(selectQuery);
        queryCompletedEvent = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((Optional)queryCompletedEvent.getContext().getResourceGroupId()).isPresent();
        Assertions.assertThat((Object)((ResourceGroupId)queryCompletedEvent.getContext().getResourceGroupId().get())).isEqualTo((Object)TestQueues.createResourceGroupId("global", "user-user"));
        Assertions.assertThat((Optional)queryCompletedEvent.getIoMetadata().getOutput()).isEqualTo(Optional.empty());
        Assertions.assertThat((List)queryCompletedEvent.getIoMetadata().getInputs()).hasSize(1);
        Assertions.assertThat((String)((String)queryCompletedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)((QueryInputMetadata)Iterables.getOnlyElement((Iterable)queryCompletedEvent.getIoMetadata().getInputs())).getCatalogName()).isEqualTo("tpch");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQueryId()).isEqualTo(queryCompletedEvent.getMetadata().getQueryId());
        Assertions.assertThat((Optional)queryCompletedEvent.getMetadata().getPreparedQuery()).isPresent();
        Assertions.assertThat((String)((String)queryCompletedEvent.getMetadata().getPreparedQuery().get())).isEqualTo(selectQuery);
    }

    @Test
    public void testOutputStats() throws Exception {
        EventsAwaitingQueries.MaterializedResultWithEvents result = this.runQueryAndWaitForEvents("SELECT 1 FROM lineitem");
        QueryCreatedEvent queryCreatedEvent = result.getQueryEvents().getQueryCreatedEvent();
        QueryCompletedEvent queryCompletedEvent = result.getQueryEvents().getQueryCompletedEvent();
        QueryStats queryStats = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getQueryStats();
        Assertions.assertThat((queryStats.getOutputDataSize().toBytes() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((queryCompletedEvent.getStatistics().getOutputBytes() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((int)result.getMaterializedResult().getRowCount()).isEqualTo(queryStats.getOutputPositions());
        Assertions.assertThat((int)result.getMaterializedResult().getRowCount()).isEqualTo(queryCompletedEvent.getStatistics().getOutputRows());
        result = this.runQueryAndWaitForEvents("SELECT COUNT(1) FROM lineitem");
        queryCreatedEvent = result.getQueryEvents().getQueryCreatedEvent();
        queryCompletedEvent = result.getQueryEvents().getQueryCompletedEvent();
        queryStats = this.getDistributedQueryRunner().getCoordinator().getQueryManager().getFullQueryInfo(new QueryId(queryCreatedEvent.getMetadata().getQueryId())).getQueryStats();
        Assertions.assertThat((queryStats.getOutputDataSize().toBytes() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((queryCompletedEvent.getStatistics().getOutputBytes() > 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)1L).isEqualTo(queryStats.getOutputPositions());
        Assertions.assertThat((long)1L).isEqualTo(queryCompletedEvent.getStatistics().getOutputRows());
        QueryStatistics statistics = queryCompletedEvent.getStatistics();
        Assertions.assertThat((long)statistics.getCpuTime().toMillis()).isEqualTo(queryStats.getTotalCpuTime().toMillis());
        Assertions.assertThat((long)statistics.getWallTime().toMillis()).isEqualTo(queryStats.getElapsedTime().toMillis());
        Assertions.assertThat((long)statistics.getQueuedTime().toMillis()).isEqualTo(queryStats.getQueuedTime().toMillis());
        Assertions.assertThat((long)((Duration)statistics.getScheduledTime().get()).toMillis()).isEqualTo(queryStats.getTotalScheduledTime().toMillis());
        Assertions.assertThat((long)((Duration)statistics.getResourceWaitingTime().get()).toMillis()).isEqualTo(queryStats.getResourceWaitingTime().toMillis());
        Assertions.assertThat((long)((Duration)statistics.getAnalysisTime().get()).toMillis()).isEqualTo(queryStats.getAnalysisTime().toMillis());
        Assertions.assertThat((long)((Duration)statistics.getPlanningTime().get()).toMillis()).isEqualTo(queryStats.getPlanningTime().toMillis());
        Assertions.assertThat((long)((Duration)statistics.getExecutionTime().get()).toMillis()).isEqualTo(queryStats.getExecutionTime().toMillis());
        Assertions.assertThat((long)statistics.getPeakUserMemoryBytes()).isEqualTo(queryStats.getPeakUserMemoryReservation().toBytes());
        Assertions.assertThat((long)statistics.getPeakTaskUserMemory()).isEqualTo(queryStats.getPeakTaskUserMemory().toBytes());
        Assertions.assertThat((long)statistics.getPeakTaskTotalMemory()).isEqualTo(queryStats.getPeakTaskTotalMemory().toBytes());
        Assertions.assertThat((long)statistics.getPhysicalInputBytes()).isEqualTo(queryStats.getPhysicalInputDataSize().toBytes());
        Assertions.assertThat((long)statistics.getPhysicalInputRows()).isEqualTo(queryStats.getPhysicalInputPositions());
        Assertions.assertThat((long)statistics.getInternalNetworkBytes()).isEqualTo(queryStats.getInternalNetworkInputDataSize().toBytes());
        Assertions.assertThat((long)statistics.getInternalNetworkRows()).isEqualTo(queryStats.getInternalNetworkInputPositions());
        Assertions.assertThat((long)statistics.getTotalBytes()).isEqualTo(queryStats.getRawInputDataSize().toBytes());
        Assertions.assertThat((long)statistics.getTotalRows()).isEqualTo(queryStats.getRawInputPositions());
        Assertions.assertThat((long)statistics.getOutputBytes()).isEqualTo(queryStats.getOutputDataSize().toBytes());
        Assertions.assertThat((long)statistics.getOutputRows()).isEqualTo(queryStats.getOutputPositions());
        Assertions.assertThat((long)statistics.getWrittenBytes()).isEqualTo(queryStats.getLogicalWrittenDataSize().toBytes());
        Assertions.assertThat((long)statistics.getWrittenRows()).isEqualTo(queryStats.getWrittenPositions());
        Assertions.assertThat((long)statistics.getSpilledBytes()).isEqualTo(queryStats.getSpilledDataSize().toBytes());
        Assertions.assertThat((double)statistics.getCumulativeMemory()).isEqualTo(queryStats.getCumulativeUserMemory());
        Assertions.assertThat((List)statistics.getStageGcStatistics()).isEqualTo((Object)queryStats.getStageGcStatistics());
        Assertions.assertThat((int)statistics.getCompletedSplits()).isEqualTo(queryStats.getCompletedDrivers());
    }

    @Test
    public void testOutputColumnsForSelect() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, orderkey AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsForSelectWithConstantExpression() throws Exception {
        this.assertLineage("SELECT '4-NOT SPECIFIED' AS test_varchar, orderkey AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of()), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsForCreateTableAsSelectAll() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_new_table AS SELECT * FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("nationkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey"))), new OutputColumnMetadata("name", "varchar(25)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("regionkey", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "regionkey"))), new OutputColumnMetadata("comment", "varchar(152)", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "comment")))});
    }

    @Test
    public void testOutputColumnsForCreateTableAsSelectAllFromView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_new_table AS SELECT * FROM mock.default.test_view").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_column", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("mock", "default", "test_view", "test_column")))});
    }

    @Test
    public void testOutputColumnsForCreateTableAsSelectAllFromMaterializedView() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_new_table AS SELECT * FROM mock.default.test_materialized_view_stale").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_column", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("mock", "default", "test_materialized_view_stale", "test_column")))});
    }

    @Test
    public void testOutputColumnsForCreateTableAsSelectWithAliasedColumn() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_new_table(aliased_bigint, aliased_varchar) AS SELECT nationkey AS keynation, concat(name, comment) FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("aliased_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey"))), new OutputColumnMetadata("aliased_varchar", "varchar", (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"), (Object)new ColumnDetail("tpch", "tiny", "nation", "comment")))});
    }

    @Test
    public void testOutputColumnsWithClause() throws Exception {
        this.assertLineage("WITH w AS (SELECT * FROM orders) SELECT lower(clerk) AS test_varchar, orderkey AS test_bigint FROM w", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsColumnAliasInWithClause() throws Exception {
        this.assertLineage("WITH w(aliased_clerk, aliased_orderkey) AS (SELECT clerk, orderkey FROM orders) SELECT lower(aliased_clerk) AS test_varchar, aliased_orderkey AS test_bigint FROM w", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithAliasedRelation() throws Exception {
        this.assertLineage("SELECT lower(clerk) AS test_varchar, orderkey AS test_bigint FROM (SELECT * FROM orders) w", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithColumnAliasInAliasedRelation() throws Exception {
        this.assertLineage("SELECT lower(aliased_clerk) AS test_varchar, aliased_orderkey AS test_bigint FROM (SELECT clerk, orderkey FROM orders) w(aliased_clerk, aliased_orderkey)", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithWhere() throws Exception {
        this.assertLineage("SELECT orderpriority AS test_varchar, orderkey AS test_bigint FROM orders WHERE orderdate > DATE '1995-10-03'", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithIfExpression() throws Exception {
        this.assertLineage("SELECT IF (orderstatus = 'O', orderpriority, clerk) AS test_varchar, orderkey AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderstatus"), (Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"), (Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithCaseExpression() throws Exception {
        this.assertLineage("SELECT CASE WHEN custkey = 100 THEN clerk WHEN custkey = 1000 then orderpriority ELSE orderstatus END AS test_varchar, orderkey AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderstatus"), (Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"), (Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"), (Object)new ColumnDetail("tpch", "tiny", "orders", "custkey"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithLimit() throws Exception {
        this.assertLineage("SELECT orderpriority AS test_varchar, orderkey AS test_bigint FROM orders LIMIT 100", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithOrderBy() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, orderkey AS test_bigint FROM orders ORDER BY orderdate", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithAggregation() throws Exception {
        this.assertLineage("SELECT max(orderpriority) AS test_varchar, min(custkey) AS test_bigint FROM orders GROUP BY orderstatus", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "custkey"))));
    }

    @Test
    public void testOutputColumnsWithAggregationWithFilter() throws Exception {
        this.assertLineage("SELECT max(orderpriority) FILTER(WHERE orderdate > DATE '2000-01-01') AS test_varchar, max(custkey) AS test_bigint FROM orders GROUP BY orderstatus", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"), (Object)new ColumnDetail("tpch", "tiny", "orders", "orderdate"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "custkey"))));
    }

    @Test
    public void testOutputColumnsWithAggregationAndHaving() throws Exception {
        this.assertLineage("SELECT min(orderpriority) AS test_varchar, max(custkey) AS test_bigint FROM orders GROUP BY orderstatus HAVING min(orderdate) > DATE '2000-01-01'", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "custkey"))));
    }

    @Test
    public void testOutputColumnsWithCountAll() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, count(*) AS test_bigint FROM orders GROUP BY clerk", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of()));
    }

    @Test
    public void testOutputColumnsWithWindowFunction() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, min(orderkey) OVER (PARTITION BY custkey ORDER BY orderdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"), (Object)new ColumnDetail("tpch", "tiny", "orders", "custkey"), (Object)new ColumnDetail("tpch", "tiny", "orders", "orderdate"))));
    }

    @Test
    public void testOutputColumnsWithPartialWindowClause() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, max(orderkey) OVER (w ORDER BY orderdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW) AS test_bigint FROM orders WINDOW w AS (PARTITION BY custkey)", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"), (Object)new ColumnDetail("tpch", "tiny", "orders", "orderdate"))));
    }

    @Test
    public void testOutputColumnsWithWindowClause() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, min(orderkey) OVER w AS test_bigint FROM orders WINDOW w AS (PARTITION BY custkey ORDER BY orderdate ROWS BETWEEN UNBOUNDED PRECEDING AND CURRENT ROW)", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"))));
    }

    @Test
    public void testOutputColumnsWithUnCorrelatedQueries() throws Exception {
        this.assertLineage("SELECT clerk AS test_varchar, (SELECT nationkey FROM nation LIMIT 1) AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders", (Object)"tpch.tiny.nation"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey"))));
    }

    @Test
    public void testOutputColumnsWithCorrelatedQueries() throws Exception {
        this.assertLineage("SELECT orderpriority AS test_varchar, (SELECT min(nationkey) FROM customer WHERE customer.custkey = orders.custkey) AS test_bigint FROM orders", (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders", (Object)"tpch.tiny.customer"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "customer", "nationkey"))));
    }

    @Test
    public void testOutputColumnsForInsertingSingleColumn() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("INSERT INTO mock.default.table_for_output(test_bigint) SELECT nationkey + 1 AS test_bigint FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey")))});
    }

    @Test
    public void testOutputColumnsForInsertingAliasedColumn() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("INSERT INTO mock.default.table_for_output(test_varchar, test_bigint) SELECT name AS aliased_name, nationkey AS aliased_varchar FROM nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey")))});
    }

    @Test
    public void testOutputColumnsForUpdatingAllColumns() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = 'reset', test_bigint = 1").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of()), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of())});
    }

    @Test
    public void testOutputColumnsForUpdatingSingleColumn() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = 're-reset' WHERE test_bigint = 1").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of())});
    }

    @Test
    public void testOutputColumnsForUpdatingColumnWithSelectQuery() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = (SELECT name from nation LIMIT 1)").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name")))});
    }

    @Test
    public void testOutputColumnsForUpdatingColumnWithSelectQueryWithAliasedField() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = (SELECT name AS aliased_name from nation LIMIT 1)").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name")))});
    }

    @Test
    public void testOutputColumnsForUpdatingColumnsWithSelectQueries() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = (SELECT name AS aliased_name from nation LIMIT 1), test_bigint = (SELECT nationkey FROM nation LIMIT 1)\n").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactlyInAnyOrder((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "nationkey")))});
    }

    @Test
    public void testOutputColumnsForUpdatingColumnsWithSelectQueryAndRawValue() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = (SELECT name AS aliased_name from nation LIMIT 1), test_bigint = 1\n").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactlyInAnyOrder((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of())});
    }

    @Test
    public void testOutputColumnsForUpdatingColumnWithSelectQueryAndWhereClauseWithOuterColumn() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("UPDATE mock.default.table_for_output SET test_varchar = (SELECT name from nation WHERE test_bigint = nationkey)\n").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "nation", "name")))});
    }

    @Test
    public void testCreateTable() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_simple_table (test_column BIGINT)").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("create_simple_table");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_column", BIGINT_TYPE, (Set)ImmutableSet.of())});
    }

    @Test
    public void testCreateTableLike() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("CREATE TABLE mock.default.create_simple_table (test_column BIGINT, LIKE mock.default.test_table)").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getCatalogName()).isEqualTo("mock");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getSchema()).isEqualTo("default");
        Assertions.assertThat((String)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getTable()).isEqualTo("create_simple_table");
        Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])new OutputColumnMetadata[]{new OutputColumnMetadata("test_column", BIGINT_TYPE, (Set)ImmutableSet.of()), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of()), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of())});
    }

    @Test
    public void testConnectorMetrics() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT * FROM mock.tiny.nation").getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        List connectorMetrics = (List)event.getIoMetadata().getInputs().stream().map(QueryInputMetadata::getConnectorMetrics).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((List)connectorMetrics).containsExactly((Object[])new Metrics[]{TEST_METRICS});
    }

    @Test
    public void testOutputColumnsForSetOperations() throws Exception {
        this.testOutputColumnsForSetOperations("UNION");
        this.testOutputColumnsForSetOperations("UNION ALL");
        this.testOutputColumnsForSetOperations("INTERSECT");
        this.testOutputColumnsForSetOperations("INTERSECT ALL");
        this.testOutputColumnsForSetOperations("EXCEPT");
        this.testOutputColumnsForSetOperations("EXCEPT ALL");
    }

    private void testOutputColumnsForSetOperations(String setOperator) throws Exception {
        this.assertLineage(String.format("SELECT orderpriority AS test_varchar, orderkey AS test_bigint FROM orders %s SELECT clerk, custkey FROM sf1.orders", setOperator), (Set<String>)ImmutableSet.of((Object)"tpch.tiny.orders", (Object)"tpch.sf1.orders"), new OutputColumnMetadata("test_varchar", VARCHAR_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderpriority"), (Object)new ColumnDetail("tpch", "sf1", "orders", "clerk"))), new OutputColumnMetadata("test_bigint", BIGINT_TYPE, (Set)ImmutableSet.of((Object)new ColumnDetail("tpch", "tiny", "orders", "orderkey"), (Object)new ColumnDetail("tpch", "sf1", "orders", "custkey"))));
    }

    @Test
    public void testTableStats() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.queries.runQueryAndWaitForEvents("SELECT l.name FROM nation l, nation r WHERE l.nationkey = r.nationkey", this.getSession(), true).getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((Optional)event.getStatistics().getPlanNodeStatsAndCosts()).isPresent();
        TypeManager typeManager = this.getQueryRunner().getPlannerContext().getTypeManager();
        ObjectMapperProvider provider = new ObjectMapperProvider();
        provider.setKeyDeserializers((Map)ImmutableMap.of(Symbol.class, (Object)new SymbolKeyDeserializer(typeManager), TypeSignature.class, (Object)new TypeSignatureKeyDeserializer()));
        provider.setJsonDeserializers((Map)ImmutableMap.of(Type.class, (Object)new TypeDeserializer(arg_0 -> ((TypeManager)typeManager).getType(arg_0))));
        JsonCodec codec = new JsonCodecFactory((Provider)provider).jsonCodec(StatsAndCosts.class);
        StatsAndCosts statsAndCosts = (StatsAndCosts)codec.fromJson((String)event.getStatistics().getPlanNodeStatsAndCosts().get());
        Assertions.assertThat(statsAndCosts.getStats().values()).allMatch(stats -> stats.getOutputRowCount() == 25.0);
    }

    @Test
    public void testAnonymizedJsonPlan() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.queries.runQueryAndWaitForEvents("SELECT quantity FROM lineitem LIMIT 10", this.getSession(), true).getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        ImmutableMap anonymizedPlan = ImmutableMap.of((Object)"0", (Object)new JsonRenderer.JsonRenderedNode("6", "Output", (Map)ImmutableMap.of((Object)"columnNames", (Object)"[column_1]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(10.0, 90.0, 0.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("100", "Limit", (Map)ImmutableMap.of((Object)"count", (Object)"10", (Object)"withTies", (Object)"", (Object)"inputPreSortedBy", (Object)"[]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(10.0, 90.0, 90.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("173", "LocalExchange", (Map)ImmutableMap.of((Object)"partitioning", (Object)"[connectorHandleType = SystemPartitioningHandle, partitioning = SINGLE, function = SINGLE]", (Object)"isReplicateNullsAndAny", (Object)"", (Object)"hashColumn", (Object)"[]", (Object)"arguments", (Object)"[]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(10.0, 90.0, 0.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("140", "RemoteSource", (Map)ImmutableMap.of((Object)"sourceFragmentIds", (Object)"[1]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of(), (List)ImmutableList.of(), (List)ImmutableList.of()))))))), (Object)"1", (Object)new JsonRenderer.JsonRenderedNode("139", "LimitPartial", (Map)ImmutableMap.of((Object)"count", (Object)"10", (Object)"withTies", (Object)"", (Object)"inputPreSortedBy", (Object)"[]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of(), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(10.0, 90.0, 90.0, 0.0, 0.0)), (List)ImmutableList.of((Object)new JsonRenderer.JsonRenderedNode("0", "TableScan", (Map)ImmutableMap.of((Object)"table", (Object)"[table = catalog_1.schema_1.table_1, connector = tpch]"), (List)ImmutableList.of((Object)new Symbol((Type)DoubleType.DOUBLE, "symbol_1")), (List)ImmutableList.of((Object)"symbol_1 := column_2"), (List)ImmutableList.of((Object)new PlanNodeStatsAndCostSummary(Double.NaN, Double.NaN, Double.NaN, 0.0, 0.0)), (List)ImmutableList.of()))));
        Assertions.assertThat((Optional)event.getMetadata().getJsonPlan()).isEqualTo(Optional.of(ANONYMIZED_PLAN_JSON_CODEC.toJson((Object)anonymizedPlan)));
    }

    @Test
    public void testAllImmediateFailureEventsPresent() throws Exception {
        String immediatelyFailingQuery = "grant select on fake_catalog_%s.fake_schema.fake_table to fake_role";
        String expectedFailure = "line 1:1: Table 'fake_catalog_%s.fake_schema.fake_table' does not exist";
        int queryCount = 100;
        for (int i = 0; i < queryCount; ++i) {
            this.assertFailedQuery(immediatelyFailingQuery.formatted(i), expectedFailure.formatted(i));
        }
    }

    private void assertLineage(String baseQuery, Set<String> inputTables, OutputColumnMetadata ... outputColumnMetadata) throws Exception {
        this.assertLineageInternal("CREATE TABLE mock.default.create_new_table AS " + baseQuery, inputTables, outputColumnMetadata);
        this.assertLineageInternal("CREATE VIEW mock.default.create_new_view AS " + baseQuery, inputTables, outputColumnMetadata);
        this.assertLineageInternal("CREATE VIEW mock.default.create_new_materialized_view AS " + baseQuery, inputTables, outputColumnMetadata);
        this.assertLineageInternal("INSERT INTO mock.default.table_for_output(test_varchar, test_bigint) " + baseQuery, inputTables, outputColumnMetadata);
        this.assertLineageInternal(String.format("DELETE FROM mock.default.table_for_output WHERE EXISTS (%s) ", baseQuery), inputTables, new OutputColumnMetadata[0]);
    }

    private void assertLineageInternal(String sql, Set<String> inputTables, OutputColumnMetadata ... outputColumnMetadata) throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents(sql).getQueryEvents();
        QueryCompletedEvent event = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((List)event.getMetadata().getTables()).map(TestEventListenerBasic::getQualifiedName).containsExactlyInAnyOrderElementsOf(inputTables);
        if (outputColumnMetadata.length != 0) {
            Assertions.assertThat((List)((List)((QueryOutputMetadata)event.getIoMetadata().getOutput().get()).getColumns().get())).containsExactly((Object[])outputColumnMetadata);
        }
    }

    private static String getQualifiedName(TableInfo tableInfo) {
        return tableInfo.getCatalog() + "." + tableInfo.getSchema() + "." + tableInfo.getTable();
    }
}

