/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.trino.execution.EventsCollector;
import io.trino.execution.TestingEventListener;
import io.trino.spi.Plugin;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import java.util.Map;
import java.util.Objects;

public class TestEventListenerPlugin {

    private static class TestingEventListenerFactory
    implements EventListenerFactory {
        private final EventsCollector eventsCollector;

        public TestingEventListenerFactory(EventsCollector eventsCollector) {
            this.eventsCollector = eventsCollector;
        }

        public String getName() {
            return "test";
        }

        public EventListener create(Map<String, String> config, EventListenerFactory.EventListenerContext context) {
            return new TestingEventListener(this.eventsCollector);
        }
    }

    static class TestingEventListenerPlugin
    implements Plugin {
        private final EventsCollector eventsCollector;

        public TestingEventListenerPlugin(EventsCollector eventsCollector) {
            this.eventsCollector = Objects.requireNonNull(eventsCollector, "eventsCollector is null");
        }

        public Iterable<EventListenerFactory> getEventListenerFactories() {
            return ImmutableList.of((Object)new TestingEventListenerFactory(this.eventsCollector));
        }
    }
}

