/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.execution.EventsAwaitingQueries;
import io.trino.execution.EventsCollector;
import io.trino.execution.TestEventListenerPlugin;
import io.trino.execution.TestQueues;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.spi.eventlistener.QueryCreatedEvent;
import io.trino.spi.eventlistener.QueryInputMetadata;
import io.trino.spi.eventlistener.QueryStatistics;
import io.trino.spi.eventlistener.SplitCompletedEvent;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedRow;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestEventListenerWithSplits
extends AbstractTestQueryFramework {
    private static final int SPLITS_PER_NODE = 3;
    private final EventsCollector generatedEvents = new EventsCollector();
    private EventsAwaitingQueries queries;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setSystemProperty("task_concurrency", "1").setCatalog("tpch").setSchema("tiny").setClientInfo("{\"clientVersion\":\"testVersion\"}").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(0).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.installPlugin((Plugin)new TestEventListenerPlugin.TestingEventListenerPlugin(this.generatedEvents));
        queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
        queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)Integer.toString(3)));
        queryRunner.installPlugin(new Plugin(this){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListTables((session, s) -> ImmutableList.of((Object)"test_table")).withApplyProjection((session, handle, projections, assignments) -> {
                    throw new RuntimeException("Throw from apply projection");
                }).build();
                return ImmutableList.of((Object)connectorFactory);
            }
        });
        queryRunner.createCatalog("mock", "mock", (Map)ImmutableMap.of());
        ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_simple.json")));
        this.queries = new EventsAwaitingQueries(this.generatedEvents, (QueryRunner)queryRunner);
        return queryRunner;
    }

    private String getResourceFilePath(String fileName) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResource(fileName).getPath();
    }

    @Test
    public void testSplitsForNormalQuery() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT sum(linenumber) FROM lineitem").getQueryEvents();
        QueryCreatedEvent queryCreatedEvent = queryEvents.getQueryCreatedEvent();
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerVersion()).isEqualTo("testversion");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getEnvironment()).isEqualTo("testing");
        Assertions.assertThat((String)((String)queryCreatedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQuery()).isEqualTo("SELECT sum(linenumber) FROM lineitem");
        Assertions.assertThat((Optional)queryCreatedEvent.getMetadata().getPreparedQuery()).isEmpty();
        QueryCompletedEvent queryCompletedEvent = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((Optional)queryCompletedEvent.getContext().getResourceGroupId()).isPresent();
        Assertions.assertThat((Object)((ResourceGroupId)queryCompletedEvent.getContext().getResourceGroupId().get())).isEqualTo((Object)TestQueues.createResourceGroupId("global", "user-user"));
        Assertions.assertThat((Optional)queryCompletedEvent.getIoMetadata().getOutput()).isEqualTo(Optional.empty());
        Assertions.assertThat((List)queryCompletedEvent.getIoMetadata().getInputs()).hasSize(1);
        Assertions.assertThat((String)((String)queryCompletedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)((QueryInputMetadata)Iterables.getOnlyElement((Iterable)queryCompletedEvent.getIoMetadata().getInputs())).getCatalogName()).isEqualTo("tpch");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQueryId()).isEqualTo(queryCompletedEvent.getMetadata().getQueryId());
        Assertions.assertThat((Optional)queryCompletedEvent.getMetadata().getPreparedQuery()).isEmpty();
        Assertions.assertThat((int)queryCompletedEvent.getStatistics().getCompletedSplits()).isEqualTo(5);
        List<SplitCompletedEvent> splitCompletedEvents = queryEvents.waitForSplitCompletedEvents(5, new Duration(30.0, TimeUnit.SECONDS));
        Assertions.assertThat(splitCompletedEvents).hasSize(5);
        Set actual = splitCompletedEvents.stream().map(SplitCompletedEvent::getQueryId).collect(Collectors.toSet());
        Assertions.assertThat(actual).isEqualTo((Object)ImmutableSet.of((Object)queryCompletedEvent.getMetadata().getQueryId()));
        long actualCompletedPositions = splitCompletedEvents.stream().filter(e -> !e.getStageId().endsWith(".0")).mapToLong(e -> e.getStatistics().getCompletedPositions()).sum();
        EventsAwaitingQueries.MaterializedResultWithEvents result = this.runQueryAndWaitForEvents("SELECT count(*) FROM lineitem");
        long expectedCompletedPositions = (Long)((MaterializedRow)result.getMaterializedResult().getMaterializedRows().get(0)).getField(0);
        Assertions.assertThat((long)actualCompletedPositions).isEqualTo(expectedCompletedPositions);
        QueryStatistics statistics = queryCompletedEvent.getStatistics();
        Assertions.assertThat((statistics.getPeakUserMemoryBytes() >= 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getPeakTaskUserMemory() >= 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getPeakTaskTotalMemory() >= 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getCumulativeMemory() >= 0.0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((long)statistics.getWrittenBytes()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getWrittenRows()).isEqualTo(0L);
        Assertions.assertThat((List)statistics.getStageGcStatistics()).hasSize(2);
        Assertions.assertThat((long)statistics.getPhysicalInputBytes()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getPhysicalInputRows()).isEqualTo(expectedCompletedPositions);
        Assertions.assertThat((long)statistics.getProcessedInputBytes()).isEqualTo(300875L);
        Assertions.assertThat((long)statistics.getProcessedInputRows()).isEqualTo(expectedCompletedPositions);
        Assertions.assertThat((long)statistics.getInternalNetworkBytes()).isEqualTo(132L);
        Assertions.assertThat((long)statistics.getInternalNetworkRows()).isEqualTo(3L);
        Assertions.assertThat((long)statistics.getTotalBytes()).isEqualTo(0L);
        Assertions.assertThat((long)statistics.getOutputBytes()).isEqualTo(9L);
        Assertions.assertThat((long)statistics.getOutputRows()).isEqualTo(1L);
        Assertions.assertThat((boolean)statistics.isComplete()).isTrue();
        Assertions.assertThat((Optional)statistics.getScheduledTime()).isPresent();
        Assertions.assertThat((Optional)statistics.getResourceWaitingTime()).isPresent();
        Assertions.assertThat((Optional)statistics.getAnalysisTime()).isPresent();
        Assertions.assertThat((Optional)statistics.getPlanningTime()).isPresent();
        Assertions.assertThat((Optional)statistics.getExecutionTime()).isPresent();
        Assertions.assertThat((Optional)statistics.getPlanNodeStatsAndCosts()).isPresent();
        Assertions.assertThat((statistics.getCpuTime().getSeconds() >= 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getWallTime().getSeconds() >= 0L ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getCpuTimeDistribution().size() > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getOperatorSummaries().size() > 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((statistics.getOutputBufferUtilization().size() > 0 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testSplitsForConstantQuery() throws Exception {
        EventsCollector.QueryEvents queryEvents = this.runQueryAndWaitForEvents("SELECT 1").getQueryEvents();
        QueryCreatedEvent queryCreatedEvent = queryEvents.getQueryCreatedEvent();
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerVersion()).isEqualTo("testversion");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getServerAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((String)queryCreatedEvent.getContext().getEnvironment()).isEqualTo("testing");
        Assertions.assertThat((String)((String)queryCreatedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((Comparable)((QueryType)queryCreatedEvent.getContext().getQueryType().get())).isEqualTo((Object)QueryType.SELECT);
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQuery()).isEqualTo("SELECT 1");
        Assertions.assertThat((Optional)queryCreatedEvent.getMetadata().getPreparedQuery()).isEmpty();
        QueryCompletedEvent queryCompletedEvent = queryEvents.getQueryCompletedEvent();
        Assertions.assertThat((Optional)queryCompletedEvent.getContext().getResourceGroupId()).isPresent();
        Assertions.assertThat((Object)((ResourceGroupId)queryCompletedEvent.getContext().getResourceGroupId().get())).isEqualTo((Object)TestQueues.createResourceGroupId("global", "user-user"));
        Assertions.assertThat((long)queryCompletedEvent.getStatistics().getTotalRows()).isEqualTo(0L);
        Assertions.assertThat((String)((String)queryCompletedEvent.getContext().getClientInfo().get())).isEqualTo("{\"clientVersion\":\"testVersion\"}");
        Assertions.assertThat((String)queryCreatedEvent.getMetadata().getQueryId()).isEqualTo(queryCompletedEvent.getMetadata().getQueryId());
        Assertions.assertThat((Optional)queryCompletedEvent.getMetadata().getPreparedQuery()).isEmpty();
        Assertions.assertThat((Comparable)((QueryType)queryCompletedEvent.getContext().getQueryType().get())).isEqualTo((Object)QueryType.SELECT);
        List<SplitCompletedEvent> splitCompletedEvents = queryEvents.waitForSplitCompletedEvents(1, new Duration(30.0, TimeUnit.SECONDS));
        Assertions.assertThat((String)splitCompletedEvents.get(0).getQueryId()).isEqualTo(queryCompletedEvent.getMetadata().getQueryId());
        Assertions.assertThat((long)splitCompletedEvents.get(0).getStatistics().getCompletedPositions()).isEqualTo(1L);
    }

    private EventsAwaitingQueries.MaterializedResultWithEvents runQueryAndWaitForEvents(@Language(value="SQL") String sql) throws Exception {
        return this.queries.runQueryAndWaitForEvents(sql, this.getSession());
    }
}

