/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestExecutionJmxMetrics {
    private static final String LONG_RUNNING_QUERY = "SELECT COUNT(*) FROM tpch.sf100000.lineitem";

    @Test
    @Timeout(value=30L)
    public void testQueryStats() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            InternalResourceGroupManager resourceGroupManager = (InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().orElseThrow(() -> new IllegalStateException("Resource manager not configured"));
            resourceGroupManager.setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getClass().getClassLoader().getResource("resource_groups_single_query.json").getPath()));
            MBeanServer mbeanServer = queryRunner.getCoordinator().getMbeanServer();
            QueryId firstDashboardQuery = QueryRunnerUtil.createQuery((QueryRunner)queryRunner, this.dashboardSession(), LONG_RUNNING_QUERY);
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, firstDashboardQuery, QueryState.RUNNING);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "RunningQueries")).isEqualTo(1L);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "QueuedQueries")).isEqualTo(0L);
            QueryId secondDashboardQuery = QueryRunnerUtil.createQuery((QueryRunner)queryRunner, this.dashboardSession(), LONG_RUNNING_QUERY);
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, secondDashboardQuery, QueryState.QUEUED);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "RunningQueries")).isEqualTo(1L);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "QueuedQueries")).isEqualTo(1L);
            QueryRunnerUtil.cancelQuery((QueryRunner)queryRunner, secondDashboardQuery);
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, secondDashboardQuery, QueryState.FAILED);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "RunningQueries")).isEqualTo(1L);
            Assertions.assertThat((long)this.getMbeanAttribute(mbeanServer, "QueuedQueries")).isEqualTo(0L);
            try {
                QueryRunnerUtil.cancelQuery((QueryRunner)queryRunner, firstDashboardQuery);
                QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, firstDashboardQuery, QueryState.FAILED);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private Session dashboardSession() {
        return TestingSession.testSessionBuilder().setSource("dashboard").build();
    }

    private long getMbeanAttribute(MBeanServer mbeanServer, String attribute) throws Exception {
        return (Long)mbeanServer.getAttribute(new ObjectName("trino.execution:name=QueryManager"), attribute);
    }
}

