/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.ClientSession;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.execution.QueryInfo;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestFinalQueryInfo {
    @Test
    @Timeout(value=240L)
    public void testFinalQueryInfoSetOnAbort() throws Exception {
        try (QueryRunner queryRunner = TestFinalQueryInfo.createQueryRunner(SessionTestUtils.TEST_SESSION);){
            QueryId queryId = TestFinalQueryInfo.startQuery("SELECT COUNT(*) FROM tpch.sf1000.lineitem", queryRunner);
            SettableFuture finalQueryInfoFuture = SettableFuture.create();
            queryRunner.getCoordinator().addFinalQueryInfoListener(queryId, arg_0 -> ((SettableFuture)finalQueryInfoFuture).set(arg_0));
            Thread.sleep(1000L);
            queryRunner.getCoordinator().getQueryManager().cancelQuery(queryId);
            QueryInfo finalQueryInfo = (QueryInfo)MoreFutures.tryGetFutureValue((Future)finalQueryInfoFuture, (int)10, (TimeUnit)TimeUnit.SECONDS).orElseThrow(() -> new AssertionError((Object)"Final query info never set"));
            Assertions.assertThat((boolean)finalQueryInfo.isFinalQueryInfo()).isTrue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryId startQuery(String sql, QueryRunner queryRunner) {
        OkHttpClient httpClient = new OkHttpClient();
        try {
            ClientSession clientSession = ClientSession.builder().server(queryRunner.getCoordinator().getBaseUrl()).user(Optional.of("user")).source("source").timeZone(ZoneId.of("America/Los_Angeles")).locale(Locale.ENGLISH).transactionId(null).clientRequestTimeout(new Duration(2.0, TimeUnit.MINUTES)).compressionDisabled(true).build();
            StatementClient client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)clientSession, (String)sql);
            while (client.isRunning() && !client.currentStatusInfo().getStats().isScheduled()) {
                client.advance();
            }
            QueryId queryId = new QueryId(client.currentStatusInfo().getId());
            return queryId;
        }
        finally {
            httpClient.dispatcher().executorService().shutdown();
            httpClient.connectionPool().evictAll();
        }
    }

    public static QueryRunner createQueryRunner(Session session) throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setWorkerCount(1).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }
}

