/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.common.Randoms;
import io.trino.connector.Grants;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MutableGrants;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.EnumSet;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TestGrantOnSchema
extends AbstractTestQueryFramework {
    private final Session admin = TestGrantOnSchema.sessionOf("admin");
    private final Grants<String> schemaGrants = new MutableGrants();

    protected QueryRunner createQueryRunner() throws Exception {
        return DistributedQueryRunner.builder((Session)this.admin).setAdditionalSetup(queryRunner -> {
            MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"information_schema", (Object)"default")).withListTables((session, schema) -> "default".equalsIgnoreCase((String)schema) ? ImmutableList.of((Object)"table_one") : ImmutableList.of()).withSchemaGrants(this.schemaGrants).build();
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)connectorFactory));
            queryRunner.createCatalog("local", "mock");
        }).build();
    }

    @BeforeAll
    public void setUp() {
        this.schemaGrants.grant(new TrinoPrincipal(PrincipalType.USER, this.admin.getUser()), (Object)"default", EnumSet.allOf(Privilege.class), true);
    }

    @Test
    public void testExistingGrants() {
        this.testExistingGrants(true);
        this.testExistingGrants(false);
    }

    private void testExistingGrants(boolean grantOption) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnSchema.sessionOf(username);
        this.schemaGrants.grant(new TrinoPrincipal(PrincipalType.USER, user.getUser()), (Object)"default", EnumSet.allOf(Privilege.class), grantOption);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema'), (VARCHAR 'default')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(user, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema'), (VARCHAR 'default')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
    }

    @Test
    public void testValidGrant() {
        this.testValidGrant("SELECT");
        this.testValidGrant("CREATE");
        this.testValidGrant("ALL PRIVILEGES");
    }

    private void testValidGrant(String privilege) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnSchema.sessionOf(username);
        this.assertUpdate(this.admin, String.format("GRANT %s ON SCHEMA default TO %s", privilege, username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(user, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema'), (VARCHAR 'default')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
    }

    @Test
    public void testValidGrantWithGrantOption() {
        this.testValidGrantWithGrantOption("SELECT");
        this.testValidGrantWithGrantOption("CREATE");
        this.testValidGrantWithGrantOption("ALL PRIVILEGES");
    }

    private void testValidGrantWithGrantOption(String privilege) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnSchema.sessionOf(username);
        this.assertUpdate(this.admin, String.format("GRANT %s ON SCHEMA default TO %s WITH GRANT OPTION", privilege, username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(user, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema'), (VARCHAR 'default')");
        this.assertUpdate(user, String.format("GRANT %s ON SCHEMA default TO %s", privilege, Randoms.randomUsername()));
        this.assertUpdate(user, String.format("GRANT %s ON SCHEMA default TO %s WITH GRANT OPTION", privilege, Randoms.randomUsername()));
    }

    @Test
    public void testGrantOnNonExistingCatalog() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT SELECT ON SCHEMA missing_catalog.missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'missing_catalog.missing_schema' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT CREATE ON SCHEMA missing_catalog.missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'missing_catalog.missing_schema' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT ALL PRIVILEGES ON SCHEMA missing_catalog.missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'missing_catalog.missing_schema' does not exist");
    }

    @Test
    public void testGrantOnNonExistingSchema() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT SELECT ON SCHEMA missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'local.missing_schema' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT CREATE ON SCHEMA missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'local.missing_schema' does not exist");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(this.admin, String.format("GRANT ALL PRIVILEGES ON SCHEMA missing_schema TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Schema 'local.missing_schema' does not exist");
    }

    @Test
    public void testAccessDenied() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(TestGrantOnSchema.sessionOf(Randoms.randomUsername()), String.format("GRANT SELECT ON SCHEMA default TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Access Denied: Cannot grant privilege SELECT on schema default");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(TestGrantOnSchema.sessionOf(Randoms.randomUsername()), String.format("GRANT CREATE ON SCHEMA default TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Access Denied: Cannot grant privilege CREATE on schema default");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(TestGrantOnSchema.sessionOf(Randoms.randomUsername()), String.format("GRANT ALL PRIVILEGES ON SCHEMA default TO %s", Randoms.randomUsername())))).failure().hasMessageContaining("Access Denied: Cannot grant privilege CREATE on schema default");
    }

    private static Session sessionOf(String username) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)username)).setCatalog("local").setSchema("default").build();
    }
}

