/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.common.Randoms;
import io.trino.connector.Grants;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MutableGrants;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.BigintType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.time.Duration;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestGrantOnTable {
    private final SchemaTableName table = new SchemaTableName("default", "table_one");
    private final SchemaTableName view = new SchemaTableName("default", "test_view");
    private final SchemaTableName materializedView = new SchemaTableName("default", "test_materialized_view");
    private final Session admin = TestGrantOnTable.sessionOf("admin");
    private final Grants<SchemaTableName> tableGrants = new MutableGrants();
    private QueryRunner queryRunner;
    private io.trino.sql.query.QueryAssertions assertions;

    @BeforeAll
    public void initClass() throws Exception {
        this.queryRunner = DistributedQueryRunner.builder((Session)this.admin).build();
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"default")).withListTables((session, schemaName) -> "default".equalsIgnoreCase((String)schemaName) ? ImmutableList.of((Object)this.table.getTableName(), (Object)this.view.getTableName(), (Object)this.materializedView.getTableName()) : ImmutableList.of()).withGetTableHandle((session, tableName) -> tableName.equals((Object)this.table) ? new MockConnectorTableHandle(tableName) : null).withSchemaGrants((Grants)new MutableGrants()).withTableGrants(this.tableGrants).withGetViews((session, schemaTablePrefix) -> ImmutableMap.of((Object)this.view, (Object)new ConnectorViewDefinition("SELECT nationkey AS test_column FROM tpch.tiny.nation", Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.empty(), true, (List)ImmutableList.of()))).withGetMaterializedViews((connectorSession, prefix) -> ImmutableMap.of((Object)this.materializedView, (Object)new ConnectorMaterializedViewDefinition("SELECT nationkey AS test_column FROM tpch.tiny.nation", Optional.of(new CatalogSchemaTableName("mock", "default", "test_materialized_view$materialized_view_storage")), Optional.of("mock"), Optional.of("default"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("test_column", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of("alice"), (List)ImmutableList.of()))).build();
        this.queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)connectorFactory));
        this.queryRunner.createCatalog("local", "mock");
        this.assertions = new io.trino.sql.query.QueryAssertions(this.queryRunner);
        this.tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, "admin"), (Object)this.table, EnumSet.allOf(Privilege.class), true);
        this.tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, "admin"), (Object)this.view, EnumSet.allOf(Privilege.class), true);
        this.tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, "admin"), (Object)this.materializedView, EnumSet.allOf(Privilege.class), true);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
        this.queryRunner = null;
    }

    @Test
    public void testExistingGrants() {
        this.testExistingGrants(true);
        this.testExistingGrants(false);
    }

    private void testExistingGrants(boolean grantOption) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnTable.sessionOf(username);
        this.tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, username), (Object)this.table, EnumSet.allOf(Privilege.class), grantOption);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(this.admin, "SHOW TABLES FROM local.default"))).matches("VALUES VARCHAR 'table_one', 'test_view', 'test_materialized_view'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM local.default"))).matches("VALUES (VARCHAR 'table_one')");
    }

    @Test
    public void testValidGrant() {
        this.testValidGrant("CREATE");
        this.testValidGrant("SELECT");
        this.testValidGrant("INSERT");
        this.testValidGrant("UPDATE");
        this.testValidGrant("DELETE");
        this.testValidGrant("ALL PRIVILEGES");
    }

    private void testValidGrant(String privilege) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnTable.sessionOf(username);
        this.queryRunner.execute(this.admin, String.format("GRANT %s ON TABLE table_one TO %s", privilege, username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
    }

    @Test
    public void testGrantOnView() {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnTable.sessionOf(username);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).result().isEmpty();
        this.queryRunner.execute(this.admin, String.format("GRANT SELECT ON TABLE test_view TO %s", username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'test_view')");
    }

    @Test
    public void testGrantOnMaterializedView() {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnTable.sessionOf(username);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).result().isEmpty();
        this.queryRunner.execute(this.admin, String.format("GRANT SELECT ON TABLE test_materialized_view TO %s", username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'test_materialized_view')");
    }

    @Test
    public void testValidGrantWithGrantOption() {
        this.testValidGrantWithGrantOption("CREATE");
        this.testValidGrantWithGrantOption("SELECT");
        this.testValidGrantWithGrantOption("INSERT");
        this.testValidGrantWithGrantOption("UPDATE");
        this.testValidGrantWithGrantOption("DELETE");
        this.testValidGrantWithGrantOption("ALL PRIVILEGES");
    }

    private void testValidGrantWithGrantOption(String privilege) {
        String username = Randoms.randomUsername();
        Session user = TestGrantOnTable.sessionOf(username);
        this.queryRunner.execute(this.admin, String.format("GRANT %s ON TABLE table_one TO %s WITH GRANT OPTION", privilege, username));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
        QueryAssertions.assertUpdate((QueryRunner)this.queryRunner, (Session)user, (String)String.format("GRANT %s ON TABLE table_one TO %s", privilege, Randoms.randomUsername()), (OptionalLong)OptionalLong.empty(), Optional.empty());
        QueryAssertions.assertUpdate((QueryRunner)this.queryRunner, (Session)user, (String)String.format("GRANT %s ON TABLE table_one TO %s WITH GRANT OPTION", privilege, Randoms.randomUsername()), (OptionalLong)OptionalLong.empty(), Optional.empty());
    }

    @Test
    public void testGrantOnNonExistingCatalog() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT CREATE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT SELECT ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT INSERT ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT UPDATE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT DELETE ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT ALL PRIVILEGES ON TABLE missing_catalog.missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testGrantOnNonExistingSchema() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT CREATE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT SELECT ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT INSERT ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT UPDATE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT DELETE ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT ALL PRIVILEGES ON TABLE missing_schema.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testGrantOnNonExistingTable() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT CREATE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT SELECT ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT INSERT ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT UPDATE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT DELETE ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(this.admin, String.format("GRANT ALL PRIVILEGES ON TABLE default.missing_table TO %s", Randoms.randomUsername()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
    }

    private static Session sessionOf(String username) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)username)).setCatalog("local").setSchema("default").build();
    }
}

