/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.execution.StageInfo;
import io.trino.execution.StageState;
import io.trino.spi.QueryId;
import io.trino.testing.QueryRunner;
import io.trino.testing.assertions.Assert;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestPendingStageState {
    private QueryRunner queryRunner;

    @BeforeAll
    public void setup() throws Exception {
        this.queryRunner = TpchQueryRunner.builder().withConnectorProperties(Map.of("tpch.splits-per-node", "10000")).build();
    }

    @Test
    @Timeout(value=30L)
    public void testPendingState() throws Exception {
        QueryId queryId = QueryRunnerUtil.createQuery(this.queryRunner, SessionTestUtils.TEST_SESSION, "SELECT * FROM tpch.sf1000.lineitem limit 1");
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, QueryState.RUNNING);
        Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assertions.assertThat((Comparable)((StageInfo)this.queryRunner.getCoordinator().getFullQueryInfo(queryId).getOutputStage().get()).getState()).isEqualTo((Object)StageState.RUNNING));
        Assert.assertEventually((Duration)new Duration(10.0, TimeUnit.SECONDS), () -> Assertions.assertThat((Comparable)((StageInfo)((StageInfo)this.queryRunner.getCoordinator().getFullQueryInfo(queryId).getOutputStage().get()).getSubStages().get(0)).getState()).isEqualTo((Object)StageState.PENDING));
        QueryInfo queryInfo = this.queryRunner.getCoordinator().getFullQueryInfo(queryId);
        Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.RUNNING);
        Assertions.assertThat((Comparable)((StageInfo)queryInfo.getOutputStage().get()).getState()).isEqualTo((Object)StageState.RUNNING);
        Assertions.assertThat((List)((StageInfo)queryInfo.getOutputStage().get()).getSubStages()).hasSize(1);
        Assertions.assertThat((Comparable)((StageInfo)((StageInfo)queryInfo.getOutputStage().get()).getSubStages().get(0)).getState()).isEqualTo((Object)StageState.PENDING);
    }

    @AfterAll
    public void tearDown() {
        if (this.queryRunner != null) {
            this.queryRunner.close();
            this.queryRunner = null;
        }
    }
}

