/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.trino.dispatcher.DispatchQuery;
import io.trino.execution.QueryState;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.eventlistener.EventListenerFactory;
import io.trino.spi.eventlistener.QueryCompletedEvent;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingDirectTrinoClient;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryCompletedEvent {
    @Test
    public void testQueryCompletedEventIssued() {
        try (StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSession());){
            queryRunner.installPlugin((Plugin)new MemoryPlugin());
            queryRunner.createCatalog("memory", "memory");
            final Set<String> queryCompletedQueryIds = Collections.synchronizedSet(new HashSet());
            final EventListener listener = new EventListener(){

                public void queryCompleted(QueryCompletedEvent queryCompletedEvent) {
                    queryCompletedQueryIds.add(queryCompletedEvent.getMetadata().getQueryId());
                }
            };
            queryRunner.installPlugin(new Plugin(){

                public Iterable<EventListenerFactory> getEventListenerFactories() {
                    return ImmutableList.of((Object)new EventListenerFactory(){

                        public String getName() {
                            return "testQueryCompletedEventIssued";
                        }

                        public EventListener create(Map<String, String> config, EventListenerFactory.EventListenerContext context) {
                            return listener;
                        }
                    });
                }
            });
            TestQueryCompletedEvent.assertQueryCompletedIssued(queryRunner, queryCompletedQueryIds, "SELECT 1");
            TestQueryCompletedEvent.assertQueryCompletedIssued(queryRunner, queryCompletedQueryIds, "CREATE SCHEMA memory.test_schema");
            TestQueryCompletedEvent.assertQueryCompletedIssued(queryRunner, queryCompletedQueryIds, "DROP SCHEMA memory.test_schema");
        }
    }

    private static void assertQueryCompletedIssued(StandaloneQueryRunner queryRunner, Set<String> queryCompletedQueryIds, String sql) {
        TestingDirectTrinoClient.Result result = queryRunner.executeWithoutResults(TestingSession.testSession(), sql);
        DispatchQuery query = queryRunner.getCoordinator().getDispatchManager().getQuery(result.queryId());
        Assertions.assertThat((Comparable)query.getState()).isEqualTo((Object)QueryState.FINISHED);
        Assert.assertEventually(() -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)queryCompletedQueryIds).describedAs("query '%s'", new Object[]{sql})).contains((Object[])new String[]{result.queryId().getId()}));
    }
}

