/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestQueryTracker
extends AbstractTestQueryFramework {
    private final CountDownLatch freeze = new CountDownLatch(1);
    private final CountDownLatch interrupted = new CountDownLatch(1);

    @AfterAll
    public void unfreeze() {
        this.freeze.countDown();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("mock").setSchema("default").setSystemProperty("query_max_planning_time", "2s").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)defaultSession).build();
        queryRunner.installPlugin(new Plugin(){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                return ImmutableList.of((Object)MockConnectorFactory.builder().withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("col", (Type)VarcharType.VARCHAR))).withApplyFilter((ignored1, ignored2, ignored3) -> (Optional)TestQueryTracker.this.freeze()).build());
            }
        });
        queryRunner.createCatalog("mock", "mock");
        return queryRunner;
    }

    @Test
    @Timeout(value=10L)
    public void testInterruptApplyFilter() throws InterruptedException {
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("SELECT * FROM t1 WHERE col = 'abc'")).hasMessageContaining("Query exceeded the maximum planning time limit of 2.00s");
        this.interrupted.await();
    }

    private <T> T freeze() {
        try {
            this.freeze.await();
        }
        catch (InterruptedException e) {
            this.interrupted.countDown();
            throw new RuntimeException(e);
        }
        return null;
    }
}

