/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.trino.Session;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.spi.session.ResourceEstimates;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestQueues {
    private static final String LONG_LASTING_QUERY = "SELECT COUNT(*) FROM lineitem";

    @Test
    @Timeout(value=240L)
    public void testResourceGroupManager() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_dashboard.json")));
            QueryId firstDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, firstDashboardQuery, QueryState.RUNNING);
            QueryId secondDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, secondDashboardQuery, QueryState.QUEUED);
            QueryId firstNonDashboardQuery = this.createAdHocQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, firstNonDashboardQuery, QueryState.RUNNING);
            QueryId secondNonDashboardQuery = this.createAdHocQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, secondNonDashboardQuery, QueryState.RUNNING);
            QueryRunnerUtil.cancelQuery(queryRunner, firstDashboardQuery);
            QueryRunnerUtil.waitForQueryState(queryRunner, firstDashboardQuery, QueryState.FAILED);
            QueryRunnerUtil.waitForQueryState(queryRunner, secondDashboardQuery, QueryState.RUNNING);
        }
    }

    @Test
    @Timeout(value=240L)
    public void testExceedSoftLimits() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_soft_limits.json")));
            QueryId scheduled1 = this.createScheduledQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, scheduled1, QueryState.RUNNING);
            QueryId scheduled2 = this.createScheduledQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, scheduled2, QueryState.RUNNING);
            QueryId scheduled3 = this.createScheduledQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, scheduled3, QueryState.RUNNING);
            QueryId backfill1 = this.createBackfill(queryRunner);
            QueryId scheduled4 = this.createScheduledQuery(queryRunner);
            QueryRunnerUtil.cancelQuery(queryRunner, scheduled1);
            QueryRunnerUtil.waitForQueryState(queryRunner, backfill1, QueryState.RUNNING);
            QueryRunnerUtil.cancelQuery(queryRunner, scheduled2);
            QueryRunnerUtil.cancelQuery(queryRunner, scheduled3);
            QueryRunnerUtil.cancelQuery(queryRunner, scheduled4);
            QueryId backfill2 = this.createBackfill(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, backfill2, QueryState.RUNNING);
            QueryId backfill3 = this.createBackfill(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, backfill3, QueryState.RUNNING);
            QueryId backfill4 = this.createBackfill(queryRunner);
            QueryId scheduled5 = this.createScheduledQuery(queryRunner);
            QueryRunnerUtil.cancelQuery(queryRunner, backfill1);
            QueryRunnerUtil.waitForQueryState(queryRunner, scheduled5, QueryState.RUNNING);
            QueryRunnerUtil.cancelQuery(queryRunner, backfill2);
            QueryRunnerUtil.cancelQuery(queryRunner, backfill3);
            QueryRunnerUtil.cancelQuery(queryRunner, backfill4);
            QueryRunnerUtil.cancelQuery(queryRunner, scheduled5);
            QueryRunnerUtil.waitForQueryState(queryRunner, scheduled5, QueryState.FAILED);
        }
    }

    private QueryId createBackfill(QueryRunner queryRunner) {
        return QueryRunnerUtil.createQuery(queryRunner, TestQueues.newSession("backfill", (Set<String>)ImmutableSet.of(), null), LONG_LASTING_QUERY);
    }

    private QueryId createScheduledQuery(QueryRunner queryRunner) {
        return QueryRunnerUtil.createQuery(queryRunner, TestQueues.newSession("scheduled", (Set<String>)ImmutableSet.of(), null), LONG_LASTING_QUERY);
    }

    @Test
    @Timeout(value=240L)
    public void testResourceGroupManagerWithTwoDashboardQueriesRequestedAtTheSameTime() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_dashboard.json")));
            QueryId firstDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryId secondDashboardQuery = this.createDashboardQuery(queryRunner);
            ImmutableSet queuedOrRunning = ImmutableSet.of((Object)QueryState.QUEUED, (Object)QueryState.RUNNING);
            QueryRunnerUtil.waitForQueryState(queryRunner, firstDashboardQuery, (Set<QueryState>)queuedOrRunning);
            QueryRunnerUtil.waitForQueryState(queryRunner, secondDashboardQuery, (Set<QueryState>)queuedOrRunning);
        }
    }

    @Test
    @Timeout(value=240L)
    public void testResourceGroupManagerWithTooManyQueriesScheduled() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_dashboard.json")));
            QueryId firstDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, firstDashboardQuery, QueryState.RUNNING);
            QueryId secondDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, secondDashboardQuery, QueryState.QUEUED);
            QueryId thirdDashboardQuery = this.createDashboardQuery(queryRunner);
            QueryRunnerUtil.waitForQueryState(queryRunner, thirdDashboardQuery, QueryState.FAILED);
        }
    }

    @Test
    @Timeout(value=240L)
    public void testResourceGroupManagerRejection() throws Exception {
        this.testRejection();
    }

    @Test
    @Timeout(value=240L)
    public void testClientTagsBasedSelection() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_client_tags_based_config.json")));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithTags((Set<String>)ImmutableSet.of((Object)"a")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "a", "default"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithTags((Set<String>)ImmutableSet.of((Object)"b")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "b"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithTags((Set<String>)ImmutableSet.of((Object)"a", (Object)"c")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "a", "c"));
        }
    }

    @Test
    public void testOriginalUserBasedSelection() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_original_user.json")));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithUsers("usr-foo", Optional.of("usr-foo-original")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "a"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithUsers("usr-foo", Optional.empty()), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "c"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithUsers("usr-foo", Optional.of("other")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "c"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithUsers("other", Optional.of("usr-foo-original")), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "b"));
        }
    }

    @Test
    @Timeout(value=240L)
    public void testSelectorResourceEstimateBasedSelection() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_resource_estimate_based_config.json")));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithResourceEstimates(new ResourceEstimates(Optional.of(Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)400L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()))), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "small"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithResourceEstimates(new ResourceEstimates(Optional.of(Duration.ofMinutes(4L)), Optional.empty(), Optional.of(DataSize.of((long)600L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes()))), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "other"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithResourceEstimates(new ResourceEstimates(Optional.of(Duration.ofMinutes(4L)), Optional.empty(), Optional.empty())), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "other"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithResourceEstimates(new ResourceEstimates(Optional.of(Duration.ofSeconds(1L)), Optional.of(Duration.ofSeconds(1L)), Optional.of(DataSize.of((long)6L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes()))), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "huge_memory"));
            this.assertResourceGroup(queryRunner, TestQueues.newSessionWithResourceEstimates(new ResourceEstimates(Optional.of(Duration.ofHours(100L)), Optional.empty(), Optional.of(DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.TERABYTE).toBytes()))), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "other"));
        }
    }

    @Test
    @Timeout(value=240L)
    public void testQueryTypeBasedSelection() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_query_type_based_config.json")));
            this.assertResourceGroup((QueryRunner)queryRunner, TestQueues.newAdhocSession(), LONG_LASTING_QUERY, TestQueues.createResourceGroupId("global", "select"));
            this.assertResourceGroup((QueryRunner)queryRunner, TestQueues.newAdhocSession(), "SHOW TABLES", TestQueues.createResourceGroupId("global", "describe"));
            this.assertResourceGroup((QueryRunner)queryRunner, TestQueues.newAdhocSession(), "EXPLAIN SELECT COUNT(*) FROM lineitem", TestQueues.createResourceGroupId("global", "explain"));
            this.assertResourceGroup((QueryRunner)queryRunner, TestQueues.newAdhocSession(), "DESCRIBE lineitem", TestQueues.createResourceGroupId("global", "describe"));
            this.assertResourceGroup((QueryRunner)queryRunner, TestQueues.newAdhocSession(), "RESET SESSION max_hash_partition_count", TestQueues.createResourceGroupId("global", "data_definition"));
        }
    }

    private void assertResourceGroup(QueryRunner queryRunner, Session session, String query, ResourceGroupId expectedResourceGroup) throws InterruptedException {
        QueryId queryId = QueryRunnerUtil.createQuery(queryRunner, session, query);
        QueryRunnerUtil.waitForQueryState(queryRunner, queryId, (Set<QueryState>)ImmutableSet.of((Object)QueryState.RUNNING, (Object)QueryState.FINISHING, (Object)QueryState.FINISHED));
        Optional resourceGroupId = queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getResourceGroupId();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resourceGroupId.isPresent()).describedAs("Query should have a resource group", new Object[0])).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)((ResourceGroupId)resourceGroupId.get())).describedAs(String.format("Expected: '%s' resource group, found: %s", expectedResourceGroup, resourceGroupId.get()), new Object[0])).isEqualTo((Object)expectedResourceGroup);
    }

    private void testRejection() throws Exception {
        try (QueryRunner queryRunner = TestQueues.createQueryRunner();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_dashboard.json")));
            QueryId queryId = QueryRunnerUtil.createQuery(queryRunner, TestQueues.newRejectionSession(), LONG_LASTING_QUERY);
            QueryRunnerUtil.waitForQueryState(queryRunner, queryId, QueryState.FAILED);
            DispatchManager dispatchManager = queryRunner.getCoordinator().getDispatchManager();
            Assertions.assertThat((Object)dispatchManager.getQueryInfo(queryId).getErrorCode()).isEqualTo((Object)StandardErrorCode.QUERY_REJECTED.toErrorCode());
        }
    }

    private static QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    private String getResourceFilePath(String fileName) {
        return this.getClass().getClassLoader().getResource(fileName).getPath();
    }

    private QueryId createDashboardQuery(QueryRunner queryRunner) {
        return QueryRunnerUtil.createQuery(queryRunner, TestQueues.newSession("dashboard", (Set<String>)ImmutableSet.of(), null), LONG_LASTING_QUERY);
    }

    private QueryId createAdHocQuery(QueryRunner queryRunner) {
        return QueryRunnerUtil.createQuery(queryRunner, TestQueues.newAdhocSession(), LONG_LASTING_QUERY);
    }

    private static Session newAdhocSession() {
        return TestQueues.newSession("adhoc", (Set<String>)ImmutableSet.of(), null);
    }

    private static Session newRejectionSession() {
        return TestQueues.newSession("reject", (Set<String>)ImmutableSet.of(), null);
    }

    private static Session newSessionWithTags(Set<String> clientTags) {
        return TestQueues.newSession("sessionWithTags", clientTags, null);
    }

    private static Session newSessionWithResourceEstimates(ResourceEstimates resourceEstimates) {
        return TestQueues.newSession("sessionWithTags", (Set<String>)ImmutableSet.of(), resourceEstimates);
    }

    private static Session newSessionWithUsers(String user, Optional<String> originalUser) {
        Session.SessionBuilder builder = TestQueues.newSessionBuilder().setIdentity(Identity.ofUser((String)user));
        originalUser.ifPresent(usr -> builder.setOriginalIdentity(Identity.ofUser((String)usr)));
        return builder.build();
    }

    private static Session newSession(String source, Set<String> clientTags, ResourceEstimates resourceEstimates) {
        return TestQueues.newSessionBuilder().setSource(source).setClientTags(clientTags).setResourceEstimates(resourceEstimates).build();
    }

    private static Session.SessionBuilder newSessionBuilder() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000");
    }

    public static ResourceGroupId createResourceGroupId(String root, String ... subGroups) {
        return new ResourceGroupId((List)ImmutableList.builder().add((Object)Objects.requireNonNull(root, "root is null")).addAll(Arrays.asList(subGroups)).build());
    }
}

