/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestRefreshMaterializedView
extends AbstractTestQueryFramework {
    private final ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private SettableFuture<Void> startRefreshMaterializedView;
    private SettableFuture<Void> finishRefreshMaterializedView;
    private SettableFuture<Void> refreshInterrupted;

    @AfterAll
    public void shutdown() {
        this.executorService.shutdownNow();
    }

    private void resetState() {
        this.startRefreshMaterializedView = SettableFuture.create();
        this.finishRefreshMaterializedView = SettableFuture.create();
        this.refreshInterrupted = SettableFuture.create();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("mock").setSchema("default").build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).build();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withListSchemaNames(connectionSession -> ImmutableList.of((Object)"default")).withGetColumns(schemaTableName -> ImmutableList.of((Object)new ColumnMetadata("nationkey", (Type)BigintType.BIGINT))).withGetTableHandle((connectorSession, tableName) -> new MockConnectorTableHandle(tableName)).withGetMaterializedViews((connectorSession, schemaTablePrefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "delegate_refresh_to_connector"), (Object)new ConnectorMaterializedViewDefinition("SELECT nationkey FROM mock.default.test_table", Optional.of(new CatalogSchemaTableName("mock", "default", "test_storage")), Optional.of("mock"), Optional.of("default"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of("alice"), (List)ImmutableList.of()))).withDelegateMaterializedViewRefreshToConnector((connectorSession, schemaTableName) -> true).withRefreshMaterializedView((connectorSession, schemaTableName) -> {
            this.startRefreshMaterializedView.set(null);
            SettableFuture refreshMaterializedView = SettableFuture.create();
            this.finishRefreshMaterializedView.addListener(() -> refreshMaterializedView.set(null), MoreExecutors.directExecutor());
            MoreFutures.addExceptionCallback((ListenableFuture)refreshMaterializedView, () -> this.refreshInterrupted.set(null));
            return MoreFutures.toCompletableFuture((ListenableFuture)refreshMaterializedView);
        }).build()));
        queryRunner.createCatalog("mock", "mock");
        return queryRunner;
    }

    @Test
    @Timeout(value=30L)
    public void testDelegateRefreshMaterializedViewToConnector() {
        this.resetState();
        ListenableFuture<Void> queryFuture = this.assertUpdateAsync("REFRESH MATERIALIZED VIEW mock.default.delegate_refresh_to_connector");
        MoreFutures.getFutureValue(this.startRefreshMaterializedView);
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        Assert.assertEventually(() -> Assertions.assertThat((boolean)queryManager.getQueries().stream().allMatch(basicQueryInfo -> basicQueryInfo.getState() == QueryState.RUNNING)).isTrue());
        this.finishRefreshMaterializedView.set(null);
        MoreFutures.getFutureValue(queryFuture);
    }

    @Test
    @Timeout(value=30L)
    public void testDelegateRefreshMaterializedViewToConnectorWithCancellation() {
        this.resetState();
        ListenableFuture<Void> queryFuture = this.assertUpdateAsync("REFRESH MATERIALIZED VIEW mock.default.delegate_refresh_to_connector");
        MoreFutures.getFutureValue(this.startRefreshMaterializedView);
        QueryManager queryManager = this.getDistributedQueryRunner().getCoordinator().getQueryManager();
        queryManager.getQueries().forEach(query -> queryManager.cancelQuery(query.getQueryId()));
        Assertions.assertThatThrownBy(() -> MoreFutures.getFutureValue((Future)queryFuture)).hasMessage("Query was canceled");
        MoreFutures.getFutureValue(this.refreshInterrupted);
    }

    private ListenableFuture<Void> assertUpdateAsync(@Language(value="SQL") String sql) {
        return Futures.submit(() -> this.assertUpdate(sql), (Executor)this.executorService);
    }
}

