/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.common.Randoms;
import io.trino.connector.Grants;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MutableGrants;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.EnumSet;
import java.util.Set;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRevokeOnSchema {
    private static final Session admin = TestRevokeOnSchema.sessionOf("admin");
    private static final Session userWithAllPrivileges = TestRevokeOnSchema.sessionOf(Randoms.randomUsername());
    private static final Session userWithSelect = TestRevokeOnSchema.sessionOf(Randoms.randomUsername());
    private QueryRunner queryRunner;
    private QueryAssertions assertions;

    @BeforeAll
    public void initClass() throws Exception {
        this.queryRunner = DistributedQueryRunner.builder((Session)userWithAllPrivileges).build();
        MutableGrants schemaGrants = new MutableGrants();
        schemaGrants.grant(new TrinoPrincipal(PrincipalType.USER, admin.getUser()), (Object)"default", EnumSet.allOf(Privilege.class), true);
        schemaGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithAllPrivileges.getUser()), (Object)"default", EnumSet.allOf(Privilege.class), true);
        schemaGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithSelect.getUser()), (Object)"default", (Set)ImmutableSet.of((Object)Privilege.SELECT), true);
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"information_schema", (Object)"default")).withSchemaGrants((Grants)schemaGrants).build();
        this.queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)connectorFactory));
        this.queryRunner.createCatalog("local", "mock");
        this.assertions = new QueryAssertions(this.queryRunner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
        this.queryRunner = null;
    }

    @Test
    public void testRevokeOnSchema() {
        this.testRevokeOnSchema("SELECT", userWithSelect);
        this.testRevokeOnSchema("ALL PRIVILEGES", userWithAllPrivileges);
    }

    private void testRevokeOnSchema(String privilege, Session user) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema'), (VARCHAR 'default')");
        this.queryRunner.execute(admin, String.format("REVOKE %s ON SCHEMA default FROM %s", privilege, user.getUser()));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW SCHEMAS FROM local"))).matches("VALUES (VARCHAR 'information_schema')");
    }

    @Test
    public void testRevokeOnNonExistingCatalog() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE SELECT ON SCHEMA missing_catalog.missing_schema FROM %s", userWithSelect.getUser()))).hasMessageContaining("Schema 'missing_catalog.missing_schema' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE ALL PRIVILEGES ON SCHEMA missing_catalog.missing_schema FROM %s", userWithAllPrivileges.getUser()))).hasMessageContaining("Schema 'missing_catalog.missing_schema' does not exist");
    }

    @Test
    public void testRevokeOnNonExistingSchema() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE SELECT ON SCHEMA missing_schema FROM %s", userWithSelect.getUser()))).hasMessageContaining("Schema 'local.missing_schema' does not exist");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE ALL PRIVILEGES ON SCHEMA missing_schema FROM %s", userWithAllPrivileges.getUser()))).hasMessageContaining("Schema 'local.missing_schema' does not exist");
    }

    @Test
    public void testAccessDenied() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnSchema.sessionOf(Randoms.randomUsername()), String.format("REVOKE CREATE ON SCHEMA default FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege CREATE on schema default");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnSchema.sessionOf(Randoms.randomUsername()), String.format("REVOKE SELECT ON SCHEMA default FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege SELECT on schema default");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnSchema.sessionOf(Randoms.randomUsername()), String.format("REVOKE ALL PRIVILEGES ON SCHEMA default FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege CREATE on schema default");
    }

    private static Session sessionOf(String username) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)username)).setCatalog("local").setSchema("default").build();
    }
}

