/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.common.Randoms;
import io.trino.connector.Grants;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.MutableGrants;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.EnumSet;
import java.util.Set;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestRevokeOnTable {
    private static final Session admin = TestRevokeOnTable.sessionOf("admin");
    private static final Session userWithAllPrivileges = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private static final Session userWithCreate = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private static final Session userWithSelect = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private static final Session userWithInsert = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private static final Session userWithUpdate = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private static final Session userWithDelete = TestRevokeOnTable.sessionOf(Randoms.randomUsername());
    private QueryRunner queryRunner;
    private QueryAssertions assertions;

    @BeforeAll
    public void initClass() throws Exception {
        SchemaTableName table = new SchemaTableName("default", "table_one");
        this.queryRunner = DistributedQueryRunner.builder((Session)userWithAllPrivileges).build();
        MutableGrants tableGrants = new MutableGrants();
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, admin.getUser()), (Object)table, EnumSet.allOf(Privilege.class), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithAllPrivileges.getUser()), (Object)table, EnumSet.allOf(Privilege.class), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithCreate.getUser()), (Object)table, (Set)ImmutableSet.of((Object)Privilege.CREATE), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithSelect.getUser()), (Object)table, (Set)ImmutableSet.of((Object)Privilege.SELECT), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithInsert.getUser()), (Object)table, (Set)ImmutableSet.of((Object)Privilege.INSERT), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithUpdate.getUser()), (Object)table, (Set)ImmutableSet.of((Object)Privilege.UPDATE), true);
        tableGrants.grant(new TrinoPrincipal(PrincipalType.USER, userWithDelete.getUser()), (Object)table, (Set)ImmutableSet.of((Object)Privilege.DELETE), true);
        MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"default")).withListTables((session, schemaName) -> "default".equalsIgnoreCase((String)schemaName) ? ImmutableList.of((Object)table.getTableName()) : ImmutableList.of()).withGetTableHandle((session, tableName) -> tableName.equals((Object)table) ? new MockConnectorTableHandle(tableName) : null).withSchemaGrants((Grants)new MutableGrants()).withTableGrants((Grants)tableGrants).build();
        this.queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)connectorFactory));
        this.queryRunner.createCatalog("local", "mock");
        this.assertions = new QueryAssertions(this.queryRunner);
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
        this.queryRunner = null;
    }

    @Test
    public void testRevokeOnSchema() {
        this.testRevokeOnSchema("CREATE", userWithCreate);
        this.testRevokeOnSchema("SELECT", userWithSelect);
        this.testRevokeOnSchema("INSERT", userWithInsert);
        this.testRevokeOnSchema("UPDATE", userWithUpdate);
        this.testRevokeOnSchema("DELETE", userWithDelete);
        this.testRevokeOnSchema("ALL PRIVILEGES", userWithAllPrivileges);
    }

    private void testRevokeOnSchema(String privilege, Session user) {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).matches("VALUES (VARCHAR 'table_one')");
        this.queryRunner.execute(admin, String.format("REVOKE %s ON TABLE table_one FROM %s", privilege, user.getUser()));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.assertions.query(user, "SHOW TABLES FROM default"))).returnsEmptyResult();
    }

    @Test
    public void testRevokeOnNonExistingCatalog() {
        this.testRevokeOnNonExistingCatalog("CREATE", userWithCreate);
        this.testRevokeOnNonExistingCatalog("SELECT", userWithSelect);
        this.testRevokeOnNonExistingCatalog("INSERT", userWithInsert);
        this.testRevokeOnNonExistingCatalog("UPDATE", userWithUpdate);
        this.testRevokeOnNonExistingCatalog("DELETE", userWithDelete);
        this.testRevokeOnNonExistingCatalog("ALL PRIVILEGES", userWithAllPrivileges);
    }

    private void testRevokeOnNonExistingCatalog(String privilege, Session user) {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE %s ON TABLE missing_catalog.missing_schema.missing_table FROM %s", privilege, user.getUser()))).hasMessageContaining("Table 'missing_catalog.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testRevokeOnNonExistingSchema() {
        this.testRevokeOnNonExistingSchema("CREATE", userWithCreate);
        this.testRevokeOnNonExistingSchema("SELECT", userWithSelect);
        this.testRevokeOnNonExistingSchema("INSERT", userWithInsert);
        this.testRevokeOnNonExistingSchema("UPDATE", userWithUpdate);
        this.testRevokeOnNonExistingSchema("DELETE", userWithDelete);
        this.testRevokeOnNonExistingSchema("ALL PRIVILEGES", userWithAllPrivileges);
    }

    private void testRevokeOnNonExistingSchema(String privilege, Session user) {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE %s ON TABLE missing_schema.missing_table FROM %s", privilege, user.getUser()))).hasMessageContaining("Table 'local.missing_schema.missing_table' does not exist");
    }

    @Test
    public void testRevokeOnNonExistingTable() {
        this.testRevokeOnNonExistingTable("CREATE", userWithCreate);
        this.testRevokeOnNonExistingTable("SELECT", userWithSelect);
        this.testRevokeOnNonExistingTable("INSERT", userWithInsert);
        this.testRevokeOnNonExistingTable("UPDATE", userWithUpdate);
        this.testRevokeOnNonExistingTable("DELETE", userWithDelete);
        this.testRevokeOnNonExistingTable("ALL PRIVILEGES", userWithAllPrivileges);
    }

    private void testRevokeOnNonExistingTable(String privilege, Session user) {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(admin, String.format("REVOKE %s ON TABLE default.missing_table FROM %s", privilege, user.getUser()))).hasMessageContaining("Table 'local.default.missing_table' does not exist");
    }

    @Test
    public void testAccessDenied() {
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE CREATE ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege CREATE on table default.table_one");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE SELECT ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege SELECT on table default.table_one");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE INSERT ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege INSERT on table default.table_one");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE UPDATE ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege UPDATE on table default.table_one");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE DELETE ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege DELETE on table default.table_one");
        Assertions.assertThatThrownBy(() -> this.queryRunner.execute(TestRevokeOnTable.sessionOf(Randoms.randomUsername()), String.format("REVOKE ALL PRIVILEGES ON TABLE table_one FROM %s", Randoms.randomUsername()))).hasMessageContaining("Access Denied: Cannot revoke privilege CREATE on table default.table_one");
    }

    private static Session sessionOf(String username) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)username)).setCatalog("local").setSchema("default").build();
    }
}

