/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.ClientSession;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.spi.ErrorCode;
import io.trino.spi.StandardErrorCode;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import java.io.File;
import java.time.ZoneId;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSetSessionAuthorization
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)SessionTestUtils.TEST_SESSION).setSystemAccessControl("file", Map.of("security.config-file", new File(Resources.getResource((String)"set_session_authorization_permissions.json").toURI()).getPath())).build();
        return queryRunner;
    }

    @Test
    public void testSetSessionAuthorizationToSelf() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION user", clientSession).getSetAuthorizationUser().get())).isEqualTo("user");
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION user", clientSession).getSetAuthorizationUser().get())).isEqualTo("user");
    }

    @Test
    public void testValidSetSessionAuthorization() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user2")).sessionUser(Optional.of("user2")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION bob", clientSession).getSetAuthorizationUser().get())).isEqualTo("bob");
    }

    @Test
    public void testInvalidSetSessionAuthorization() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        this.assertError(this.submitQuery("SET SESSION AUTHORIZATION user2", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user user2");
        this.assertError(this.submitQuery("SET SESSION AUTHORIZATION bob", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user bob");
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        this.assertError(this.submitQuery("SET SESSION AUTHORIZATION charlie", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user charlie");
        StatementClient client = this.submitQuery("START TRANSACTION", clientSession);
        clientSession = ClientSession.builder((ClientSession)clientSession).transactionId(client.getStartedTransactionId()).build();
        this.assertError(this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession), StandardErrorCode.GENERIC_USER_ERROR.toErrorCode(), "Can't set authorization user in the middle of a transaction");
    }

    @Test
    public void testInvalidTransitiveSetSessionAuthorization() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("alice")).sessionUser(Optional.of("alice")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION charlie", clientSession).getSetAuthorizationUser().get())).isEqualTo("charlie");
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        this.assertError(this.submitQuery("SET SESSION AUTHORIZATION charlie", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user charlie");
    }

    @Test
    public void testValidSessionAuthorizationExecution() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("alice")).build();
        Assertions.assertThat((Object)this.submitQuery("SELECT 1+1", clientSession).currentStatusInfo().getError()).isEqualTo(null);
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("user")).build();
        Assertions.assertThat((Object)this.submitQuery("SELECT 1+1", clientSession).currentStatusInfo().getError()).isEqualTo(null);
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).authorizationUser(Optional.of("alice")).build();
        Assertions.assertThat((Object)this.submitQuery("SELECT 1+1", clientSession).currentStatusInfo().getError()).isEqualTo(null);
    }

    @Test
    public void testInvalidSessionAuthorizationExecution() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("user2")).build();
        this.assertError(this.submitQuery("SELECT 1+1", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user user2");
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("user3")).build();
        this.assertError(this.submitQuery("SELECT 1+1", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user user3");
        clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("charlie")).build();
        this.assertError(this.submitQuery("SELECT 1+1", clientSession), StandardErrorCode.PERMISSION_DENIED.toErrorCode(), "Access Denied: User user cannot impersonate user charlie");
    }

    @Test
    public void testSelectCurrentUser() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).authorizationUser(Optional.of("alice")).build();
        ImmutableList.Builder data = ImmutableList.builder();
        this.submitQuery("SELECT CURRENT_USER", clientSession, (ImmutableList.Builder<List<Object>>)data);
        ImmutableList rows = data.build();
        Assertions.assertThat((String)((String)((List)rows.get(0)).get(0))).isEqualTo("alice");
    }

    @Test
    public void testResetSessionAuthorization() {
        ClientSession clientSession = this.defaultClientSessionBuilder().user(Optional.of("user")).sessionUser(Optional.of("user")).build();
        this.assertResetAuthorizationUser(this.submitQuery("RESET SESSION AUTHORIZATION", clientSession));
        Assertions.assertThat((String)((String)this.submitQuery("SET SESSION AUTHORIZATION alice", clientSession).getSetAuthorizationUser().get())).isEqualTo("alice");
        this.assertResetAuthorizationUser(this.submitQuery("RESET SESSION AUTHORIZATION", clientSession));
        StatementClient client = this.submitQuery("START TRANSACTION", clientSession);
        clientSession = ClientSession.builder((ClientSession)clientSession).transactionId(client.getStartedTransactionId()).build();
        this.assertError(this.submitQuery("RESET SESSION AUTHORIZATION", clientSession), StandardErrorCode.GENERIC_USER_ERROR.toErrorCode(), "Can't reset authorization user in the middle of a transaction");
    }

    private void assertError(StatementClient client, ErrorCode errorCode, String errorMessage) {
        Assertions.assertThat((Optional)client.getSetAuthorizationUser()).isEqualTo(Optional.empty());
        Assertions.assertThat((String)client.currentStatusInfo().getError().getErrorName()).isEqualTo(errorCode.getName());
        Assertions.assertThat((String)client.currentStatusInfo().getError().getMessage()).isEqualTo(errorMessage);
    }

    private void assertResetAuthorizationUser(StatementClient client) {
        Assertions.assertThat((boolean)client.isResetAuthorizationUser()).isTrue();
        Assertions.assertThat((Optional)client.getSetAuthorizationUser()).isEmpty();
    }

    private ClientSession.Builder defaultClientSessionBuilder() {
        return ClientSession.builder().server(this.getDistributedQueryRunner().getCoordinator().getBaseUrl()).source("source").timeZone(ZoneId.of("America/Los_Angeles")).locale(Locale.ENGLISH).clientRequestTimeout(new Duration(2.0, TimeUnit.MINUTES));
    }

    private StatementClient submitQuery(String query, ClientSession clientSession) {
        OkHttpClient httpClient = new OkHttpClient();
        try {
            StatementClient statementClient;
            block10: {
                StatementClient client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)clientSession, (String)query);
                try {
                    while (client.isRunning() && !client.currentStatusInfo().getStats().isScheduled()) {
                        client.advance();
                    }
                    statementClient = client;
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            return statementClient;
        }
        finally {
            httpClient.dispatcher().executorService().shutdown();
            httpClient.connectionPool().evictAll();
        }
    }

    private StatementClient submitQuery(String query, ClientSession clientSession, ImmutableList.Builder<List<Object>> data) {
        OkHttpClient httpClient = new OkHttpClient();
        try {
            StatementClient statementClient;
            block11: {
                StatementClient client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)clientSession, (String)query);
                try {
                    while (client.isRunning() && !Thread.currentThread().isInterrupted()) {
                        data.addAll((Iterable)client.currentRows());
                        client.advance();
                    }
                    while (client.isRunning() && !client.currentStatusInfo().getStats().isScheduled()) {
                        client.advance();
                    }
                    statementClient = client;
                    if (client == null) break block11;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            return statementClient;
        }
        finally {
            httpClient.dispatcher().executorService().shutdown();
            httpClient.connectionPool().evictAll();
        }
    }
}

