/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import io.trino.client.StageStats;
import io.trino.client.StatementStats;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStatementStats {
    @Test
    public void testUniqueNodeCounts() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"query-manager.required-workers", (Object)"2"))).setWorkerCount(1)).build();){
            MaterializedResult result = queryRunner.execute(TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build(), "SELECT COUNT(*) from lineitem LIMIT 10");
            Assertions.assertThat((Optional)result.getStatementStats()).isPresent();
            StatementStats stats = (StatementStats)result.getStatementStats().get();
            Assertions.assertThat((int)stats.getNodes()).isEqualTo(2);
            StageStats rootStage = stats.getRootStage();
            Assertions.assertThat((Object)rootStage).isNotNull();
            Assertions.assertThat((int)rootStage.getNodes()).isEqualTo(1);
            Assertions.assertThat((List)rootStage.getSubStages()).hasSize(1);
            Assertions.assertThat((int)((StageStats)rootStage.getSubStages().get(0)).getNodes()).isEqualTo(2);
        }
    }
}

