/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorInsertTableHandle;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.optimizations.PlanNodeSearcher;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.TableWriterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTableRedirection
extends AbstractTestQueryFramework {
    private static final String CATALOG_NAME = "test_catalog";
    private static final String SCHEMA_ONE = "test_schema_1";
    private static final String SCHEMA_TWO = "test_schema_2";
    private static final String SCHEMA_THREE = "test_schema_3";
    private static final List<String> SCHEMAS = ImmutableList.of((Object)"test_schema_1", (Object)"test_schema_2", (Object)"test_schema_3");
    private static final String TABLE_FOO = "table_foo";
    private static final String TABLE_BAR = "table_bar";
    private static final String VALID_REDIRECTION_SRC = "valid_redirection_src";
    private static final String VALID_REDIRECTION_TARGET = "valid_redirection_target";
    private static final String BAD_REDIRECTION_SRC = "bad_redirection_src";
    private static final String NON_EXISTENT_TABLE = "non_existent_table";
    private static final String REDIRECTION_TWICE_SRC = "redirection_twice_src";
    private static final String INTERMEDIATE_TABLE = "intermediate_table";
    private static final String REDIRECTION_LOOP_PING = "redirection_loop_ping";
    private static final String REDIRECTION_LOOP_PONG = "redirection_loop_pong";
    private static final List<String> REDIRECTION_CHAIN = (List)IntStream.range(0, 11).boxed().map(i -> "redirection_chain_table_" + i).collect(ImmutableList.toImmutableList());
    private static final String C0 = "c0";
    private static final String C1 = "c1";
    private static final String C2 = "c2";
    private static final String C3 = "c3";
    private static final String C4 = "c4";
    private static final Map<String, Set<String>> SCHEMA_TABLE_MAPPING = ImmutableMap.of((Object)"test_schema_1", (Object)ImmutableSet.of((Object)"table_foo", (Object)"valid_redirection_src", (Object)"bad_redirection_src", (Object)"redirection_twice_src", (Object)"redirection_loop_ping"), (Object)"test_schema_2", (Object)ImmutableSet.of((Object)"table_bar", (Object)"valid_redirection_target", (Object)"intermediate_table", (Object)"redirection_loop_pong"), (Object)"test_schema_3", (Object)ImmutableSet.copyOf(REDIRECTION_CHAIN));
    private static final Map<SchemaTableName, SchemaTableName> REDIRECTIONS = ImmutableMap.builder().put((Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"valid_redirection_src"), (Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"valid_redirection_target")).put((Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"bad_redirection_src"), (Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"non_existent_table")).put((Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"redirection_twice_src"), (Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"intermediate_table")).put((Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"intermediate_table"), (Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"table_foo")).put((Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"redirection_loop_ping"), (Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"redirection_loop_pong")).put((Object)SchemaTableName.schemaTableName((String)"test_schema_2", (String)"redirection_loop_pong"), (Object)SchemaTableName.schemaTableName((String)"test_schema_1", (String)"redirection_loop_ping")).putAll((Map)IntStream.range(0, REDIRECTION_CHAIN.size() - 1).boxed().collect(ImmutableMap.toImmutableMap(i -> SchemaTableName.schemaTableName((String)SCHEMA_THREE, (String)REDIRECTION_CHAIN.get((int)i)), i -> SchemaTableName.schemaTableName((String)SCHEMA_THREE, (String)REDIRECTION_CHAIN.get(i + 1))))).buildOrThrow();
    private static final Map<String, List<ColumnMetadata>> columnMetadatas = ImmutableMap.of((Object)"test_schema_1", (Object)ImmutableList.of((Object)new ColumnMetadata("c0", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("c1", (Type)BigintType.BIGINT)), (Object)"test_schema_2", (Object)ImmutableList.of((Object)new ColumnMetadata("c2", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("c3", (Type)BigintType.BIGINT)), (Object)"test_schema_3", (Object)ImmutableList.of((Object)new ColumnMetadata("c4", (Type)BigintType.BIGINT)));
    private static final Function<SchemaTableName, List<ColumnMetadata>> columnsGetter = table -> {
        List<ColumnMetadata> columns = columnMetadatas.get(table.getSchemaName());
        if (columns != null) {
            return columns;
        }
        throw new RuntimeException(String.format("Unknown schema: %s", table.getSchemaName()));
    };
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().setCatalog("test_catalog").build();

    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TEST_SESSION).build();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)this.createMockConnectorFactory()));
        queryRunner.createCatalog(CATALOG_NAME, "mock", (Map)ImmutableMap.of());
        return queryRunner;
    }

    private MockConnectorFactory createMockConnectorFactory() {
        return MockConnectorFactory.builder().withListSchemaNames(session -> SCHEMAS).withListTables((session, schemaName) -> (List)SCHEMA_TABLE_MAPPING.getOrDefault(schemaName, (Set<String>)ImmutableSet.of()).stream().collect(ImmutableList.toImmutableList())).withStreamTableColumns((session, prefix) -> {
            List allColumnsMetadata = (List)SCHEMA_TABLE_MAPPING.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(table -> new SchemaTableName((String)entry.getKey(), table))).map(schemaTableName -> {
                if (REDIRECTIONS.containsKey(schemaTableName)) {
                    return TableColumnsMetadata.forRedirectedTable((SchemaTableName)schemaTableName);
                }
                return TableColumnsMetadata.forTable((SchemaTableName)schemaTableName, columnsGetter.apply((SchemaTableName)schemaTableName));
            }).collect(ImmutableList.toImmutableList());
            if (prefix.isEmpty()) {
                return allColumnsMetadata.iterator();
            }
            String schema = (String)prefix.getSchema().get();
            if (SCHEMAS.contains(schema)) {
                return allColumnsMetadata.stream().filter(columnsMetadata -> columnsMetadata.getTable().getSchemaName().equals(schema)).filter(columnsMetadata -> prefix.getTable().map(columnsMetadata.getTable().getTableName()::equals).orElse(true)).iterator();
            }
            return Collections.emptyIterator();
        }).withGetTableHandle((session, tableName) -> {
            if (SCHEMA_TABLE_MAPPING.getOrDefault(tableName.getSchemaName(), (Set<String>)ImmutableSet.of()).contains(tableName.getTableName()) && !REDIRECTIONS.containsKey(tableName)) {
                return new MockConnectorTableHandle(tableName);
            }
            return null;
        }).withGetViews((connectorSession, prefix) -> ImmutableMap.of()).withGetColumns(schemaTableName -> {
            if (!REDIRECTIONS.containsKey(schemaTableName)) {
                return columnsGetter.apply((SchemaTableName)schemaTableName);
            }
            throw new RuntimeException("Columns do not exist for: " + String.valueOf(schemaTableName));
        }).withRedirectTable((connectorSession, schemaTableName) -> Optional.ofNullable(REDIRECTIONS.get(schemaTableName)).map(target -> new CatalogSchemaTableName(CATALOG_NAME, target))).build();
    }

    @Test
    public void testTableScans() {
        this.assertQuery(String.format("SELECT c2 FROM %s.%s", SCHEMA_ONE, VALID_REDIRECTION_SRC), "SELECT 1 WHERE 1=0", this.verifySingleTableScan(SCHEMA_TWO, VALID_REDIRECTION_TARGET));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c0 FROM %s.%s", SCHEMA_ONE, BAD_REDIRECTION_SRC)))).failure().hasMessageContaining("Table '%s' redirected to '%s', but the target table '%s' does not exist", new Object[]{new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, BAD_REDIRECTION_SRC), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE)});
        this.assertQuery(String.format("SELECT c0 FROM %s.%s", SCHEMA_ONE, REDIRECTION_TWICE_SRC), "SELECT 1 WHERE 1=0", this.verifySingleTableScan(SCHEMA_ONE, TABLE_FOO));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c0 FROM %s.%s", SCHEMA_ONE, REDIRECTION_LOOP_PING)))).failure().hasMessageContaining("Table redirections form a loop: %s -> %s -> %s", new Object[]{new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, REDIRECTION_LOOP_PING), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, REDIRECTION_LOOP_PONG), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, REDIRECTION_LOOP_PING)});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SELECT c4 FROM %s.%s", SCHEMA_THREE, REDIRECTION_CHAIN.get(0))))).failure().hasMessageContaining("Table redirected too many times (10): [%s]", new Object[]{REDIRECTION_CHAIN.stream().map(table -> new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_THREE, table).toString()).collect(Collectors.joining(", "))});
    }

    @Test
    public void testTableListing() {
        this.assertQuery(String.format("SHOW TABLES FROM %s", SCHEMA_ONE), String.format("VALUES %s", SCHEMA_TABLE_MAPPING.get(SCHEMA_ONE).stream().map(table -> "('" + table + "')").collect(Collectors.joining(","))));
        this.assertQuery(String.format("SELECT table_name FROM system.jdbc.tables WHERE table_cat = '%s' AND table_schem ='%s'", CATALOG_NAME, SCHEMA_ONE), String.format("VALUES %s", SCHEMA_TABLE_MAPPING.get(SCHEMA_ONE).stream().map(table -> "('" + table + "')").collect(Collectors.joining(","))));
        this.assertQuery(String.format("SHOW TABLES FROM %s", SCHEMA_TWO), String.format("VALUES %s", SCHEMA_TABLE_MAPPING.get(SCHEMA_TWO).stream().map(table -> "('" + table + "')").collect(Collectors.joining(","))));
        this.assertQuery(String.format("SELECT table_name FROM system.jdbc.tables WHERE table_cat = '%s' AND table_schem ='%s'", CATALOG_NAME, SCHEMA_TWO), String.format("VALUES %s", SCHEMA_TABLE_MAPPING.get(SCHEMA_TWO).stream().map(table -> "('" + table + "')").collect(Collectors.joining(","))));
        this.assertQuery("SELECT table_schema, table_name FROM information_schema.tables WHERE table_schema != 'information_schema'", String.format("VALUES %s", SCHEMA_TABLE_MAPPING.entrySet().stream().map(mappings -> ((Set)mappings.getValue()).stream().map(tableName -> TestTableRedirection.row((String)mappings.getKey(), tableName))).flatMap(Function.identity()).collect(Collectors.joining(","))));
        this.assertQuery(String.format("SELECT table_schema, table_name FROM information_schema.tables WHERE table_catalog='%s' AND table_schema = '%s' AND table_name='%s'", CATALOG_NAME, SCHEMA_ONE, VALID_REDIRECTION_SRC), String.format("VALUES ('%s', '%s')", SCHEMA_ONE, VALID_REDIRECTION_SRC));
        this.assertQuery(String.format("SELECT table_schema, table_name FROM information_schema.tables WHERE table_catalog='%s' AND table_schema = '%s' AND table_name='%s'", CATALOG_NAME, SCHEMA_ONE, BAD_REDIRECTION_SRC), String.format("VALUES ('%s', '%s')", SCHEMA_ONE, BAD_REDIRECTION_SRC));
        this.assertQuery(String.format("SELECT table_schema, table_name FROM information_schema.tables WHERE table_catalog='%s' AND table_schema = '' AND table_name = ''", CATALOG_NAME));
    }

    @Test
    public void testTableColumnsListing() {
        String schemaOneColumns = "VALUES " + TestTableRedirection.row(SCHEMA_ONE, TABLE_FOO, C0) + "," + TestTableRedirection.row(SCHEMA_ONE, TABLE_FOO, C1) + "," + TestTableRedirection.row(SCHEMA_ONE, VALID_REDIRECTION_SRC, C2) + "," + TestTableRedirection.row(SCHEMA_ONE, VALID_REDIRECTION_SRC, C3) + "," + TestTableRedirection.row(SCHEMA_ONE, REDIRECTION_TWICE_SRC, C0) + "," + TestTableRedirection.row(SCHEMA_ONE, REDIRECTION_TWICE_SRC, C1);
        this.assertQuery(String.format("SELECT table_schema, table_name, column_name FROM information_schema.columns WHERE table_schema = '%s'", SCHEMA_ONE), schemaOneColumns);
        this.assertQuery(String.format("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem = '%s' AND table_cat = '%s'", SCHEMA_ONE, CATALOG_NAME), schemaOneColumns);
        String schemaTwoColumns = "VALUES " + TestTableRedirection.row(SCHEMA_TWO, TABLE_BAR, C2) + "," + TestTableRedirection.row(SCHEMA_TWO, TABLE_BAR, C3) + "," + TestTableRedirection.row(SCHEMA_TWO, VALID_REDIRECTION_TARGET, C2) + "," + TestTableRedirection.row(SCHEMA_TWO, VALID_REDIRECTION_TARGET, C3) + "," + TestTableRedirection.row(SCHEMA_TWO, INTERMEDIATE_TABLE, C0) + "," + TestTableRedirection.row(SCHEMA_TWO, INTERMEDIATE_TABLE, C1);
        this.assertQuery(String.format("SELECT table_schema, table_name, column_name FROM information_schema.columns WHERE table_schema = '%s'", SCHEMA_TWO), schemaTwoColumns);
        this.assertQuery(String.format("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem = '%s' AND table_cat = '%s'", SCHEMA_TWO, CATALOG_NAME), schemaTwoColumns);
        String validRedirectionSrcColumns = "VALUES " + TestTableRedirection.row(SCHEMA_ONE, VALID_REDIRECTION_SRC, C2) + "," + TestTableRedirection.row(SCHEMA_ONE, VALID_REDIRECTION_SRC, C3);
        this.assertQuery(String.format("SELECT table_schema, table_name, column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", SCHEMA_ONE, VALID_REDIRECTION_SRC), validRedirectionSrcColumns);
        this.assertQuery(String.format("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem = '%s' AND table_name='%s' AND table_cat = '%s'", SCHEMA_ONE, VALID_REDIRECTION_SRC, CATALOG_NAME), validRedirectionSrcColumns);
        String emptyResult = "SELECT '', '', '' WHERE 1 = 0";
        this.assertQuery(String.format("SELECT table_schema, table_name, column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", SCHEMA_ONE, BAD_REDIRECTION_SRC), emptyResult);
        this.assertQuery(String.format("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem = '%s' AND table_name='%s' AND table_cat = '%s'", SCHEMA_ONE, BAD_REDIRECTION_SRC, CATALOG_NAME), emptyResult);
        this.assertQuery(String.format("SELECT table_schema, table_name, column_name FROM information_schema.columns WHERE table_schema = '%s' AND table_name = '%s'", SCHEMA_ONE, REDIRECTION_LOOP_PING), emptyResult);
        this.assertQuery(String.format("SELECT table_schem, table_name, column_name FROM system.jdbc.columns WHERE table_schem = '%s' AND table_name = '%s' AND table_cat = '%s'", SCHEMA_ONE, REDIRECTION_LOOP_PING, CATALOG_NAME), emptyResult);
    }

    @Test
    public void testShowCreate() {
        String showCreateValidSource = (String)this.computeScalar(String.format("SHOW CREATE TABLE %s.%s", SCHEMA_ONE, VALID_REDIRECTION_SRC));
        String showCreateValidTarget = (String)this.computeScalar(String.format("SHOW CREATE TABLE %s.%s", SCHEMA_TWO, VALID_REDIRECTION_TARGET));
        Assertions.assertThat((String)showCreateValidTarget).isEqualTo(showCreateValidSource.replace("test_schema_1.valid_redirection_src", "test_schema_2.valid_redirection_target"));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SHOW CREATE TABLE %s.%s", SCHEMA_ONE, BAD_REDIRECTION_SRC)))).failure().hasMessageContaining("Table '%s' redirected to '%s', but the target table '%s' does not exist", new Object[]{new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, BAD_REDIRECTION_SRC), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE)});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SHOW CREATE TABLE %s.%s", SCHEMA_ONE, REDIRECTION_LOOP_PING)))).failure().hasMessageContaining("Table redirections form a loop");
    }

    @Test
    public void testDescribeTable() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("DESCRIBE %s.%s", SCHEMA_ONE, VALID_REDIRECTION_SRC)))).matches(String.format("DESCRIBE %s.%s", SCHEMA_TWO, VALID_REDIRECTION_TARGET));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("DESCRIBE %s.%s", SCHEMA_ONE, BAD_REDIRECTION_SRC)))).failure().hasMessageContaining("Table '%s' redirected to '%s', but the target table '%s' does not exist", new Object[]{new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, BAD_REDIRECTION_SRC), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE)});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("DESCRIBE %s.%s", SCHEMA_ONE, REDIRECTION_LOOP_PING)))).failure().hasMessageContaining("Table redirections form a loop");
    }

    @Test
    public void testShowColumns() {
        this.assertQuery(String.format("SHOW COLUMNS FROM %s.%s", SCHEMA_ONE, VALID_REDIRECTION_SRC), "VALUES " + TestTableRedirection.row(C2, BigintType.BIGINT.getDisplayName(), "", "") + "," + TestTableRedirection.row(C3, BigintType.BIGINT.getDisplayName(), "", ""));
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SHOW COLUMNS FROM %s.%s", SCHEMA_ONE, BAD_REDIRECTION_SRC)))).failure().hasMessageContaining("Table '%s' redirected to '%s', but the target table '%s' does not exist", new Object[]{new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_ONE, BAD_REDIRECTION_SRC), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE), new CatalogSchemaTableName(CATALOG_NAME, SCHEMA_TWO, NON_EXISTENT_TABLE)});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(String.format("SHOW COLUMNS FROM %s.%s", SCHEMA_ONE, REDIRECTION_LOOP_PING)))).failure().hasMessageContaining("Table redirections form a loop");
    }

    @Test
    public void testInsert() {
        this.assertUpdate(this.getSession(), String.format("INSERT INTO %s.%s VALUES (5, 6)", SCHEMA_ONE, VALID_REDIRECTION_SRC), 1L, plan -> {
            TableFinishNode finishNode = (TableFinishNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(TableFinishNode.class::isInstance).findOnlyElement();
            TableWriterNode.InsertTarget insertTarget = (TableWriterNode.InsertTarget)finishNode.getTarget();
            Assertions.assertThat((Object)((MockConnectorInsertTableHandle)insertTarget.getHandle().connectorHandle()).getTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
            Assertions.assertThat((Object)insertTarget.getSchemaTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
        });
    }

    @Test
    public void testDelete() {
        this.assertUpdate(this.getSession(), String.format("DELETE FROM %s.%s WHERE %s = 5", SCHEMA_ONE, VALID_REDIRECTION_SRC, C2), 0L, plan -> {
            TableFinishNode finishNode = (TableFinishNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(TableFinishNode.class::isInstance).findOnlyElement();
            TableWriterNode.MergeTarget mergeTarget = (TableWriterNode.MergeTarget)finishNode.getTarget();
            Assertions.assertThat((Object)((MockConnectorTableHandle)mergeTarget.getHandle().connectorHandle()).getTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
            Assertions.assertThat((Object)mergeTarget.getSchemaTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
        });
    }

    @Test
    public void testUpdate() {
        this.assertUpdate(this.getSession(), String.format("UPDATE %s.%s SET %s = 5 WHERE %s = 1", SCHEMA_ONE, VALID_REDIRECTION_SRC, C3, C2), 0L, plan -> {
            TableFinishNode finishNode = (TableFinishNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(TableFinishNode.class::isInstance).findOnlyElement();
            TableWriterNode.MergeTarget mergeTarget = (TableWriterNode.MergeTarget)finishNode.getTarget();
            Assertions.assertThat((Object)((MockConnectorTableHandle)mergeTarget.getHandle().connectorHandle()).getTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
            Assertions.assertThat((Object)mergeTarget.getSchemaTableName()).isEqualTo((Object)SchemaTableName.schemaTableName((String)SCHEMA_TWO, (String)VALID_REDIRECTION_TARGET));
        });
    }

    private static String row(String ... values) {
        return Arrays.stream(values).map(value -> "'" + value + "'").collect(Collectors.joining(",", "(", ")"));
    }

    private Consumer<Plan> verifySingleTableScan(String schemaName, String tableName) {
        return plan -> {
            TableScanNode tableScan = (TableScanNode)PlanNodeSearcher.searchFrom((PlanNode)plan.getRoot()).where(TableScanNode.class::isInstance).findOnlyElement();
            SchemaTableName actual = ((MockConnectorTableHandle)tableScan.getTable().connectorHandle()).getTableName();
            Assertions.assertThat((Object)actual).isEqualTo((Object)SchemaTableName.schemaTableName((String)schemaName, (String)tableName));
        };
    }
}

