/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.client.ClientSession;
import io.trino.client.QueryError;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import jakarta.annotation.Nullable;
import java.io.File;
import java.time.ZoneId;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestUserImpersonationAccessControl
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        String securityConfigFile = new File(Resources.getResource((String)"access_control_rules.json").toURI()).getPath();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)SessionTestUtils.TEST_SESSION).setWorkerCount(0).setSystemAccessControl("file", Map.of("security.config-file", securityConfigFile)).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testReadAccessControl() {
        QueryError aliceQueryError = this.trySelectQuery("alice");
        Assertions.assertThat((Object)aliceQueryError).isNull();
        QueryError bobQueryError = this.trySelectQuery("bob");
        Assertions.assertThat((Object)bobQueryError).isNotNull();
        Assertions.assertThat((String)bobQueryError.getErrorType()).isEqualTo("USER_ERROR");
        Assertions.assertThat((String)bobQueryError.getErrorName()).isEqualTo("PERMISSION_DENIED");
        QueryError charlieQueryError = this.trySelectQuery("charlie");
        Assertions.assertThat((Object)charlieQueryError).isNull();
    }

    @Nullable
    private QueryError trySelectQuery(String sessionUser) {
        OkHttpClient httpClient = new OkHttpClient();
        try {
            QueryError queryError;
            block10: {
                ClientSession clientSession = ClientSession.builder().server(this.getDistributedQueryRunner().getCoordinator().getBaseUrl()).user(Optional.of("user")).sessionUser(Optional.of(sessionUser)).source("source").timeZone(ZoneId.of("America/Los_Angeles")).locale(Locale.ENGLISH).clientRequestTimeout(new Duration(2.0, TimeUnit.MINUTES)).compressionDisabled(true).build();
                StatementClient client = StatementClientFactory.newStatementClient((Call.Factory)httpClient, (ClientSession)clientSession, (String)"SELECT * FROM tpch.tiny.nation");
                try {
                    while (client.isRunning() && !client.currentStatusInfo().getStats().isScheduled()) {
                        client.advance();
                    }
                    queryError = client.currentStatusInfo().getError();
                    if (client == null) break block10;
                }
                catch (Throwable throwable) {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                client.close();
            }
            return queryError;
        }
        finally {
            httpClient.dispatcher().executorService().shutdown();
            httpClient.connectionPool().evictAll();
        }
    }
}

