/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.client.Warning;
import io.trino.spi.WarningCode;
import io.trino.spi.connector.StandardWarningCode;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Fail;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestWarnings {
    private static final int STAGE_COUNT_WARNING_THRESHOLD = 20;
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() throws Exception {
        this.queryRunner = ((TpchQueryRunner.Builder)TpchQueryRunner.builder().addExtraProperty("query.stage-count-warning-threshold", String.valueOf(20))).build();
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testStageCountWarningThreshold() {
        StringBuilder queryBuilder = new StringBuilder("SELECT name FROM nation WHERE nationkey = 0");
        String noWarningsQuery = queryBuilder.toString();
        for (int stageIndex = 1; stageIndex <= 20; ++stageIndex) {
            queryBuilder.append("  UNION").append("  SELECT name FROM nation WHERE nationkey = ").append(stageIndex);
        }
        String query = queryBuilder.toString();
        TestWarnings.assertWarnings(this.queryRunner, query, (List<WarningCode>)ImmutableList.of((Object)StandardWarningCode.TOO_MANY_STAGES.toWarningCode()));
        TestWarnings.assertWarnings(this.queryRunner, noWarningsQuery, (List<WarningCode>)ImmutableList.of());
    }

    private static void assertWarnings(QueryRunner queryRunner, @Language(value="SQL") String sql, List<WarningCode> expectedWarnings) {
        Set warnings = (Set)queryRunner.execute(sql).getWarnings().stream().map(Warning::getWarningCode).map(Warning.Code::getCode).collect(ImmutableSet.toImmutableSet());
        for (WarningCode warningCode : expectedWarnings) {
            if (warnings.contains(warningCode.getCode())) continue;
            Fail.fail((String)("Expected warning: " + String.valueOf(warningCode)));
        }
    }
}

