/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.plugin.resourcegroups.ResourceGroupManagerPlugin;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.Plugin;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestResourceGroupIntegration {
    @Test
    public void testMemoryFraction() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            TestResourceGroupIntegration.getResourceGroupManager((QueryRunner)queryRunner).setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_memory_percentage.json")));
            queryRunner.execute("SELECT COUNT(*), clerk FROM orders GROUP BY clerk");
            TestResourceGroupIntegration.waitForGlobalResourceGroup((QueryRunner)queryRunner);
        }
    }

    @Test
    public void testPathToRoot() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            queryRunner.installPlugin((Plugin)new ResourceGroupManagerPlugin());
            InternalResourceGroupManager<?> manager = TestResourceGroupIntegration.getResourceGroupManager((QueryRunner)queryRunner);
            manager.setConfigurationManager("file", (Map)ImmutableMap.of((Object)"resource-groups.config-file", (Object)this.getResourceFilePath("resource_groups_config_dashboard.json")));
            queryRunner.execute(TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSource("dashboard-foo").build(), "SELECT COUNT(*), clerk FROM orders GROUP BY clerk");
            List path = (List)manager.tryGetPathToRoot(new ResourceGroupId(new ResourceGroupId(new ResourceGroupId("global"), "user-user"), "dashboard-user")).orElseThrow(() -> new IllegalStateException("Resource group not found"));
            Assertions.assertThat((List)path).hasSize(3);
            Assertions.assertThat((Optional)((ResourceGroupInfo)path.get(1)).subGroups()).isPresent();
            Assertions.assertThat((Object)((ResourceGroupInfo)path.get(2)).id()).isEqualTo((Object)new ResourceGroupId("global"));
            Assertions.assertThat((int)((ResourceGroupInfo)path.get(2)).hardConcurrencyLimit()).isEqualTo(100);
            Assertions.assertThat((Optional)((ResourceGroupInfo)path.get(2)).runningQueries()).isNotPresent();
        }
    }

    private String getResourceFilePath(String fileName) {
        return this.getClass().getClassLoader().getResource(fileName).getPath();
    }

    public static void waitForGlobalResourceGroup(QueryRunner queryRunner) throws InterruptedException {
        long startTime = System.nanoTime();
        while (true) {
            TimeUnit.SECONDS.sleep(1L);
            ResourceGroupInfo global = (ResourceGroupInfo)TestResourceGroupIntegration.getResourceGroupManager(queryRunner).tryGetResourceGroupInfo(new ResourceGroupId("global")).orElseThrow(() -> new IllegalStateException("Resource group not found"));
            if (global.softMemoryLimit().toBytes() > 0L) break;
            Assertions.assertThat((long)Duration.nanosSince((long)startTime).roundTo(TimeUnit.SECONDS)).isLessThan(60L);
        }
    }

    private static InternalResourceGroupManager<?> getResourceGroupManager(QueryRunner queryRunner) {
        return (InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().orElseThrow(() -> new IllegalArgumentException("no resource group manager"));
    }
}

