/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups.db;

import com.google.inject.Injector;
import com.google.inject.Module;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.json.JsonModule;
import io.airlift.node.NodeModule;
import io.trino.execution.resourcegroups.db.H2ResourceGroupsModule;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.ForEnvironment;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.memory.ClusterMemoryPoolManager;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManager;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerContext;
import io.trino.spi.resourcegroups.ResourceGroupConfigurationManagerFactory;
import java.util.Map;
import java.util.Objects;

public class H2ResourceGroupConfigurationManagerFactory
implements ResourceGroupConfigurationManagerFactory {
    private final ClassLoader classLoader;

    public H2ResourceGroupConfigurationManagerFactory(ClassLoader classLoader) {
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    public String getName() {
        return "h2";
    }

    public ResourceGroupConfigurationManager<?> create(Map<String, String> config, ResourceGroupConfigurationManagerContext context) {
        try (ThreadContextClassLoader threadContextClassLoader = new ThreadContextClassLoader(this.classLoader);){
            Bootstrap app = new Bootstrap(new Module[]{new JsonModule(), new H2ResourceGroupsModule(), new NodeModule(), binder -> binder.bind(String.class).annotatedWith(ForEnvironment.class).toInstance((Object)context.getEnvironment()), binder -> binder.bind(ClusterMemoryPoolManager.class).toInstance((Object)context.getMemoryPoolManager())});
            Injector injector = app.doNotInitializeLogging().setRequiredConfigurationProperties(config).quiet().initialize();
            ResourceGroupConfigurationManager resourceGroupConfigurationManager = (ResourceGroupConfigurationManager)injector.getInstance(DbResourceGroupConfigurationManager.class);
            return resourceGroupConfigurationManager;
        }
    }
}

