/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.trino.Session;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.execution.resourcegroups.db.H2ResourceGroupManagerPlugin;
import io.trino.plugin.resourcegroups.ResourceGroupSelector;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfig;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.H2DaoProvider;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.resourcegroups.QueryType;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class H2TestUtil {
    private static final String CONFIGURATION_MANAGER_TYPE = "h2";
    public static final String TEST_ENVIRONMENT = "test_environment";
    public static final String TEST_ENVIRONMENT_2 = "test_environment_2";
    public static final JsonCodec<List<String>> CLIENT_TAGS_CODEC = JsonCodec.listJsonCodec(String.class);

    private H2TestUtil() {
    }

    public static Session adhocSession() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("adhoc").build();
    }

    public static Session dashboardSession() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("dashboard").build();
    }

    public static Session rejectingSession() {
        return TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("reject").build();
    }

    public static void waitForCompleteQueryCount(QueryRunner queryRunner, int expectedCount) throws InterruptedException {
        H2TestUtil.waitForQueryCount(queryRunner, QueryState.TERMINAL_QUERY_STATES, expectedCount);
    }

    public static void waitForRunningQueryCount(QueryRunner queryRunner, int expectedCount) throws InterruptedException {
        H2TestUtil.waitForQueryCount(queryRunner, (Set<QueryState>)ImmutableSet.of((Object)QueryState.RUNNING), expectedCount);
    }

    public static void waitForQueryCount(QueryRunner queryRunner, Set<QueryState> countingStates, int expectedCount) throws InterruptedException {
        QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
        while (queryManager.getQueries().stream().filter(q -> countingStates.contains(q.getState())).count() != (long)expectedCount) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
    }

    public static String getDbConfigUrl() {
        return "jdbc:h2:mem:test_" + Math.abs(new Random().nextLong()) + ";NON_KEYWORDS=KEY,VALUE";
    }

    public static H2ResourceGroupsDao getDao(String url) {
        DbResourceGroupConfig dbResourceGroupConfig = new DbResourceGroupConfig().setConfigDbUrl(url);
        H2ResourceGroupsDao dao = new H2DaoProvider(dbResourceGroupConfig).get();
        dao.createResourceGroupsTable();
        dao.createSelectorsTable();
        dao.createResourceGroupsGlobalPropertiesTable();
        return dao;
    }

    public static QueryRunner createQueryRunner(String dbConfigUrl, H2ResourceGroupsDao dao) throws Exception {
        return H2TestUtil.createQueryRunner(dbConfigUrl, dao, TEST_ENVIRONMENT);
    }

    public static QueryRunner createQueryRunner(String dbConfigUrl, H2ResourceGroupsDao dao, String environment) throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build()).setWorkerCount(1).setEnvironment(environment).build();
        try {
            H2ResourceGroupManagerPlugin h2ResourceGroupManagerPlugin = new H2ResourceGroupManagerPlugin();
            queryRunner.installPlugin((Plugin)h2ResourceGroupManagerPlugin);
            ((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).setConfigurationManager(CONFIGURATION_MANAGER_TYPE, (Map)ImmutableMap.of((Object)"resource-groups.config-db-url", (Object)dbConfigUrl, (Object)"node.environment", (Object)environment));
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            H2TestUtil.setup((QueryRunner)queryRunner, dao, environment);
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }

    public static QueryRunner getSimpleQueryRunner() throws Exception {
        String dbConfigUrl = H2TestUtil.getDbConfigUrl();
        H2ResourceGroupsDao dao = H2TestUtil.getDao(dbConfigUrl);
        return H2TestUtil.createQueryRunner(dbConfigUrl, dao);
    }

    private static void setup(QueryRunner queryRunner, H2ResourceGroupsDao dao, String environment) throws InterruptedException {
        dao.insertResourceGroupsGlobalProperties("cpu_quota_period", "1h");
        dao.insertResourceGroup(1L, "global", "1MB", 100, Integer.valueOf(1000), 1000, null, null, null, null, null, null, TEST_ENVIRONMENT);
        dao.insertResourceGroup(2L, "bi-${USER}", "1MB", 3, Integer.valueOf(2), 2, null, null, null, null, null, Long.valueOf(1L), TEST_ENVIRONMENT);
        dao.insertResourceGroup(3L, "user-${USER}", "1MB", 3, Integer.valueOf(3), 3, null, null, null, null, null, Long.valueOf(1L), TEST_ENVIRONMENT);
        dao.insertResourceGroup(4L, "adhoc-${USER}", "1MB", 3, Integer.valueOf(3), 3, null, null, null, null, null, Long.valueOf(3L), TEST_ENVIRONMENT);
        dao.insertResourceGroup(5L, "dashboard-${USER}", "1MB", 1, Integer.valueOf(1), 1, null, null, null, null, null, Long.valueOf(3L), TEST_ENVIRONMENT);
        dao.insertResourceGroup(6L, "no-queueing", "1MB", 0, Integer.valueOf(1), 1, null, null, null, null, null, null, TEST_ENVIRONMENT_2);
        dao.insertResourceGroup(7L, "explain", "1MB", 0, Integer.valueOf(1), 1, null, null, null, null, null, null, TEST_ENVIRONMENT);
        dao.insertSelector(2L, 10000L, "user.*", null, null, null, "test", null, null, null);
        dao.insertSelector(4L, 1000L, "user.*", null, null, null, "(?i).*adhoc.*", null, null, null);
        dao.insertSelector(5L, 100L, "user.*", null, null, null, "(?i).*dashboard.*", null, null, null);
        dao.insertSelector(4L, 10L, "user.*", null, null, null, null, null, CLIENT_TAGS_CODEC.toJson((Object)ImmutableList.of((Object)"tag1", (Object)"tag2")), null);
        dao.insertSelector(2L, 1L, "user.*", null, null, null, null, null, CLIENT_TAGS_CODEC.toJson((Object)ImmutableList.of((Object)"tag1")), null);
        dao.insertSelector(6L, 6L, ".*", null, null, null, ".*", null, null, null);
        dao.insertSelector(7L, 100000L, null, null, null, null, null, QueryType.EXPLAIN.name(), null, null);
        int expectedSelectors = 6;
        if (environment.equals(TEST_ENVIRONMENT_2)) {
            expectedSelectors = 1;
        }
        while (H2TestUtil.getSelectors(queryRunner).size() != expectedSelectors) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
    }

    public static List<ResourceGroupSelector> getSelectors(QueryRunner queryRunner) {
        try {
            return ((DbResourceGroupConfigurationManager)((InternalResourceGroupManager)queryRunner.getCoordinator().getResourceGroupManager().get()).getConfigurationManager()).getSelectors();
        }
        catch (TrinoException e) {
            if (e.getErrorCode() == StandardErrorCode.CONFIGURATION_INVALID.toErrorCode()) {
                return ImmutableList.of();
            }
            throw e;
        }
    }
}

