/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups.db;

import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.execution.resourcegroups.db.H2TestUtil;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.spi.QueryId;
import io.trino.testing.QueryRunner;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestEnvironments {
    private static final String LONG_LASTING_QUERY = "SELECT COUNT(*) FROM lineitem";

    @Test
    @Timeout(value=240L)
    public void testEnvironment1() throws Exception {
        String dbConfigUrl = H2TestUtil.getDbConfigUrl();
        H2ResourceGroupsDao dao = H2TestUtil.getDao(dbConfigUrl);
        try (QueryRunner runner = H2TestUtil.createQueryRunner(dbConfigUrl, dao, "test_environment");){
            QueryId firstQuery = QueryRunnerUtil.createQuery(runner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
            QueryRunnerUtil.waitForQueryState(runner, firstQuery, QueryState.RUNNING);
            QueryId secondQuery = QueryRunnerUtil.createQuery(runner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
            QueryRunnerUtil.waitForQueryState(runner, secondQuery, QueryState.RUNNING);
        }
    }

    @Test
    @Timeout(value=240L)
    public void testEnvironment2() throws Exception {
        String dbConfigUrl = H2TestUtil.getDbConfigUrl();
        H2ResourceGroupsDao dao = H2TestUtil.getDao(dbConfigUrl);
        try (QueryRunner runner = H2TestUtil.createQueryRunner(dbConfigUrl, dao, "test_environment_2");){
            QueryId firstQuery = QueryRunnerUtil.createQuery(runner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
            QueryRunnerUtil.waitForQueryState(runner, firstQuery, QueryState.RUNNING);
            QueryId secondQuery = QueryRunnerUtil.createQuery(runner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
            QueryRunnerUtil.waitForQueryState(runner, secondQuery, QueryState.FAILED);
        }
    }
}

