/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups.db;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.Session;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.execution.TestQueues;
import io.trino.execution.resourcegroups.InternalResourceGroupManager;
import io.trino.execution.resourcegroups.db.H2TestUtil;
import io.trino.plugin.resourcegroups.db.DbResourceGroupConfigurationManager;
import io.trino.plugin.resourcegroups.db.H2ResourceGroupsDao;
import io.trino.server.BasicQueryInfo;
import io.trino.server.ResourceGroupInfo;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.resourcegroups.ResourceGroupId;
import io.trino.spi.security.Identity;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.assertions.Assert;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestQueuesDb {
    private static final String LONG_LASTING_QUERY = "SELECT COUNT(*) FROM lineitem";
    private QueryRunner queryRunner;
    private H2ResourceGroupsDao dao;

    @BeforeEach
    public void setup() throws Exception {
        String dbConfigUrl = H2TestUtil.getDbConfigUrl();
        this.dao = H2TestUtil.getDao(dbConfigUrl);
        this.queryRunner = H2TestUtil.createQueryRunner(dbConfigUrl, this.dao);
    }

    @AfterEach
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    @Timeout(value=60L)
    public void testRunningQuery() throws Exception {
        ResourceGroupInfo global;
        this.queryRunner.execute("SELECT COUNT(*), clerk FROM orders GROUP BY clerk");
        while ((global = (ResourceGroupInfo)((InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get()).tryGetResourceGroupInfo(new ResourceGroupId(new ResourceGroupId("global"), "bi-user")).orElseThrow(() -> new IllegalStateException("Resource group not found"))).softMemoryLimit().toBytes() <= 0L) {
            TimeUnit.SECONDS.sleep(2L);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testBasic() throws Exception {
        QueryId firstDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.RUNNING);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 1);
        QueryId secondDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        TimeUnit.MILLISECONDS.sleep(2000L);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondDashboardQuery, QueryState.QUEUED);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 1);
        this.dao.updateResourceGroup(3L, "user-${USER}", "1MB", 3, Integer.valueOf(4), 4, null, null, null, null, null, Long.valueOf(1L), "test_environment");
        this.dao.updateResourceGroup(5L, "dashboard-${USER}", "1MB", 1, Integer.valueOf(2), 2, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondDashboardQuery, QueryState.RUNNING);
        QueryId thirdDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdDashboardQuery, QueryState.QUEUED);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 2);
        QueryId firstNonDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstNonDashboardQuery, QueryState.RUNNING);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 3);
        QueryId secondNonDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.adhocSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondNonDashboardQuery, QueryState.RUNNING);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 4);
        QueryRunnerUtil.cancelQuery(this.queryRunner, firstDashboardQuery);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.FAILED);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdDashboardQuery, QueryState.RUNNING);
        H2TestUtil.waitForRunningQueryCount(this.queryRunner, 4);
        H2TestUtil.waitForCompleteQueryCount(this.queryRunner, 1);
    }

    @Test
    @Timeout(value=60L)
    public void testTwoQueriesAtSameTime() throws Exception {
        QueryId firstDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryId secondDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondDashboardQuery, QueryState.QUEUED);
    }

    @Test
    @Timeout(value=90L)
    public void testTooManyQueries() throws Exception {
        QueryId firstDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.RUNNING);
        QueryId secondDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondDashboardQuery, QueryState.QUEUED);
        QueryId thirdDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdDashboardQuery, QueryState.FAILED);
        this.dao.updateResourceGroup(3L, "user-${USER}", "1MB", 3, Integer.valueOf(4), 4, null, null, null, null, null, Long.valueOf(1L), "test_environment");
        this.dao.updateResourceGroup(5L, "dashboard-${USER}", "1MB", 1, Integer.valueOf(2), 2, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        dbConfigurationManager.load();
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondDashboardQuery, QueryState.RUNNING);
        thirdDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdDashboardQuery, QueryState.QUEUED);
        this.dao.updateResourceGroup(5L, "dashboard-${USER}", "1MB", 1, Integer.valueOf(1), 1, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        dbConfigurationManager.load();
        QueryRunnerUtil.cancelQuery(this.queryRunner, firstDashboardQuery);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.FAILED);
        TimeUnit.MILLISECONDS.sleep(2000L);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdDashboardQuery, QueryState.QUEUED);
    }

    @Test
    @Timeout(value=60L)
    public void testRejection() throws Exception {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        QueryId queryId = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.rejectingSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, QueryState.FAILED);
        DispatchManager dispatchManager = this.queryRunner.getCoordinator().getDispatchManager();
        Assertions.assertThat((Object)dispatchManager.getQueryInfo(queryId).getErrorCode()).isEqualTo((Object)StandardErrorCode.QUERY_REJECTED.toErrorCode());
        int selectorCount = H2TestUtil.getSelectors(this.queryRunner).size();
        this.dao.insertSelector(4L, 100000L, "user.*", null, null, null, "(?i).*reject.*", null, null, null);
        dbConfigurationManager.load();
        Assertions.assertThat(H2TestUtil.getSelectors(this.queryRunner)).hasSize(selectorCount + 1);
        queryId = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.rejectingSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, QueryState.RUNNING);
        this.dao.deleteSelector(4L, "user.*", null, null, null, "(?i).*reject.*", null);
        dbConfigurationManager.load();
        queryId = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.rejectingSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, QueryState.FAILED);
    }

    @Test
    @Timeout(value=60L)
    public void testQuerySystemTableResourceGroup() throws Exception {
        QueryId firstQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQuery, QueryState.RUNNING);
        MaterializedResult result = this.queryRunner.execute("SELECT resource_group_id FROM system.runtime.queries WHERE source = 'dashboard'");
        Assertions.assertThat((Object)result.getOnlyValue()).isEqualTo((Object)ImmutableList.of((Object)"global", (Object)"user-user", (Object)"dashboard-user"));
    }

    @Test
    @Timeout(value=60L)
    public void testSelectorPriority() throws Exception {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get();
        QueryManager queryManager = this.queryRunner.getCoordinator().getQueryManager();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        QueryId firstQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQuery, QueryState.RUNNING);
        Optional resourceGroup = queryManager.getFullQueryInfo(firstQuery).getResourceGroupId();
        Assertions.assertThat((Optional)resourceGroup).isPresent();
        Assertions.assertThat((String)((ResourceGroupId)resourceGroup.get()).toString()).isEqualTo("global.user-user.dashboard-user");
        this.dao.insertResourceGroup(8L, "reject-all-queries", "1MB", 0, Integer.valueOf(0), 0, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        this.dao.insertSelector(8L, 200L, "user.*", null, null, null, "(?i).*dashboard.*", null, null, null);
        dbConfigurationManager.load();
        QueryId secondQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.FAILED);
        DispatchManager dispatchManager = this.queryRunner.getCoordinator().getDispatchManager();
        BasicQueryInfo basicQueryInfo = dispatchManager.getQueryInfo(secondQuery);
        if (!StandardErrorCode.QUERY_QUEUE_FULL.toErrorCode().equals((Object)basicQueryInfo.getErrorCode())) {
            AssertionError failure = new AssertionError((Object)"Expected query to fail with QUERY_QUEUE_FULL error code, but got: %s".formatted(basicQueryInfo.getErrorCode()));
            dispatchManager.getFullQueryInfo(secondQuery).map(QueryInfo::getFailureInfo).map(ExecutionFailureInfo::toException).ifPresent(arg_0 -> failure.addSuppressed(arg_0));
            throw failure;
        }
    }

    @Test
    @Timeout(value=60L)
    public void testQueryExecutionTimeLimit() throws Exception {
        QueryManager queryManager = this.queryRunner.getCoordinator().getQueryManager();
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        QueryId firstQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("dashboard").setSystemProperty("query_max_execution_time", "1ms").build(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQuery, QueryState.FAILED);
        Assertions.assertThat((Object)queryManager.getFullQueryInfo(firstQuery).getErrorCode()).isEqualTo((Object)StandardErrorCode.EXCEEDED_TIME_LIMIT.toErrorCode());
        Assertions.assertThat((String)queryManager.getFullQueryInfo(firstQuery).getFailureInfo().getMessage()).contains(new CharSequence[]{"Query exceeded the maximum execution time limit of 1.00ms"});
        this.dao.updateResourceGroup(5L, "dashboard-${USER}", "1MB", 1, null, 0, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        dbConfigurationManager.load();
        QueryId secondQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("dashboard").setSystemProperty("query_max_execution_time", "1ms").build(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.QUEUED);
        Thread.sleep(5000L);
        DispatchManager dispatchManager = this.queryRunner.getCoordinator().getDispatchManager();
        Assertions.assertThat((Comparable)dispatchManager.getQueryInfo(secondQuery).getState()).isEqualTo((Object)QueryState.QUEUED);
        this.dao.updateResourceGroup(5L, "dashboard-${USER}", "1MB", 1, null, 1, null, null, null, null, null, Long.valueOf(3L), "test_environment");
        dbConfigurationManager.load();
        dispatchManager.cancelQuery(firstQuery);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.FAILED);
    }

    @Test
    public void testQueryTypeBasedSelection() throws InterruptedException {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").build();
        QueryId queryId = QueryRunnerUtil.createQuery(this.queryRunner, session, "EXPLAIN SELECT COUNT(*) FROM lineitem");
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, (Set<QueryState>)ImmutableSet.of((Object)QueryState.RUNNING, (Object)QueryState.FINISHED));
        Optional resourceGroupId = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getResourceGroupId();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resourceGroupId.isPresent()).describedAs("Query should have a resource group", new Object[0])).isTrue();
        Assertions.assertThat((Object)((ResourceGroupId)resourceGroupId.get())).isEqualTo((Object)TestQueues.createResourceGroupId("explain", new String[0]));
    }

    @Test
    public void testClientTagsBasedSelection() throws InterruptedException {
        this.assertResourceGroupWithClientTags((Set<String>)ImmutableSet.of((Object)"tag1"), TestQueues.createResourceGroupId("global", "bi-user"));
        this.assertResourceGroupWithClientTags((Set<String>)ImmutableSet.of((Object)"tag1", (Object)"tag2"), TestQueues.createResourceGroupId("global", "user-user", "adhoc-user"));
    }

    @Test
    public void testNonLeafGroup() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("non-leaf").build();
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().get();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        int originalSize = H2TestUtil.getSelectors(this.queryRunner).size();
        this.dao.insertSelector(3L, 100L, "user.*", null, null, null, "(?i).*non-leaf.*", null, null, null);
        dbConfigurationManager.load();
        while (H2TestUtil.getSelectors(this.queryRunner).size() != originalSize + 1) {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        QueryId firstDashboardQuery = QueryRunnerUtil.createQuery(this.queryRunner, H2TestUtil.dashboardSession(), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.RUNNING);
        QueryRunnerUtil.cancelQuery(this.queryRunner, firstDashboardQuery);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstDashboardQuery, QueryState.FAILED);
        QueryId invalidResourceGroupQuery = QueryRunnerUtil.createQuery(this.queryRunner, session, LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, invalidResourceGroupQuery, QueryState.FAILED);
        Assertions.assertThat((Object)this.queryRunner.getCoordinator().getDispatchManager().getQueryInfo(invalidResourceGroupQuery).getErrorCode()).isEqualTo((Object)StandardErrorCode.INVALID_RESOURCE_GROUP.toErrorCode());
    }

    @Test
    public void testUpdateSoftMemoryLimit() {
        this.queryRunner.execute("SELECT COUNT(*), clerk FROM orders GROUP BY clerk");
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().orElseThrow();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        this.dao.updateResourceGroup(2L, "bi-${USER}", "100%", 3, Integer.valueOf(2), 2, null, null, null, null, null, Long.valueOf(1L), "test_environment");
        dbConfigurationManager.load();
        Assertions.assertThat((long)((ResourceGroupInfo)manager.tryGetResourceGroupInfo(new ResourceGroupId(new ResourceGroupId("global"), "bi-user")).orElseThrow(() -> new IllegalStateException("Resource group not found"))).softMemoryLimit().toBytes()).isEqualTo(this.queryRunner.getCoordinator().getClusterMemoryManager().getClusterMemoryBytes());
        this.dao.updateResourceGroup(2L, "bi-${USER}", "123MB", 3, Integer.valueOf(2), 2, null, null, null, null, null, Long.valueOf(1L), "test_environment");
        dbConfigurationManager.load();
        Assert.assertEventually((Duration)new Duration(2.0, TimeUnit.SECONDS), (Duration)new Duration(100.0, TimeUnit.MILLISECONDS), () -> Assertions.assertThat((Comparable)((ResourceGroupInfo)manager.tryGetResourceGroupInfo(new ResourceGroupId(new ResourceGroupId("global"), "bi-user")).orElseThrow(() -> new IllegalStateException("Resource group not found"))).softMemoryLimit()).isEqualTo((Object)DataSize.of((long)123L, (DataSize.Unit)DataSize.Unit.MEGABYTE)));
    }

    @Test
    @Timeout(value=60L)
    public void testAddSubGroup() throws InterruptedException {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().orElseThrow();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        this.dao.insertResourceGroup(10L, "queued", "80%", 10, null, 1, null, null, null, null, null, null, "test_environment");
        this.dao.insertSelector(10L, 1L, null, null, null, null, null, null, "[\"queued\"]", null);
        this.dao.insertResourceGroup(11L, "running", "80%", 10, null, 2, null, null, null, null, null, null, "test_environment");
        this.dao.insertSelector(11L, 1L, null, null, null, null, null, null, "[\"running\"]", null);
        dbConfigurationManager.load();
        QueryId firstQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryId secondQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromQueuedGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromQueuedGroup, QueryState.QUEUED);
        QueryId firstQueryFromRunningGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "running"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromRunningGroup, QueryState.RUNNING);
        this.dao.deleteSelectors(10L);
        this.dao.insertResourceGroup(12L, "subgroup", "80%", 10, null, 1, null, null, null, null, null, Long.valueOf(10L), "test_environment");
        this.dao.insertSelector(12L, 1L, null, null, null, null, null, null, "[\"queued\"]", null);
        this.dao.deleteSelectors(11L);
        this.dao.insertResourceGroup(13L, "subgroup", "80%", 10, null, 1, null, null, null, null, null, Long.valueOf(11L), "test_environment");
        this.dao.insertSelector(13L, 1L, null, null, null, null, null, null, "[\"running\"]", null);
        dbConfigurationManager.load();
        QueryId thirdQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryId secondQueryFromRunningGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "running"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromQueuedGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromQueuedGroup, QueryState.QUEUED);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdQueryFromQueuedGroup, QueryState.FAILED);
        this.assertFailureMessage(thirdQueryFromQueuedGroup, "Cannot add sub group to 'queued' while queries are queued");
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromRunningGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromRunningGroup, QueryState.RUNNING);
    }

    @Test
    @Timeout(value=60L)
    public void testDisableSubGroup() throws InterruptedException {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().orElseThrow();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        this.dao.insertResourceGroup(10L, "queued", "80%", 10, null, 3, null, null, null, null, null, null, "test_environment");
        this.dao.insertResourceGroup(11L, "subgroup", "80%", 10, null, 1, null, null, null, null, null, Long.valueOf(10L), "test_environment");
        this.dao.insertSelector(11L, 1L, null, null, null, null, null, null, "[\"queued\"]", null);
        this.dao.insertResourceGroup(12L, "running", "80%", 10, null, 3, null, null, null, null, null, null, "test_environment");
        this.dao.insertResourceGroup(13L, "subgroup", "80%", 10, null, 1, null, null, null, null, null, Long.valueOf(12L), "test_environment");
        this.dao.insertSelector(13L, 1L, null, null, null, null, null, null, "[\"running\"]", null);
        dbConfigurationManager.load();
        QueryId firstQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryId secondQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromQueuedGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromQueuedGroup, QueryState.QUEUED);
        QueryId firstQueryFromRunningGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "running"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromRunningGroup, QueryState.RUNNING);
        this.dao.deleteSelectors(11L);
        this.dao.deleteResourceGroup(11L);
        this.dao.insertSelector(10L, 1L, null, null, null, null, null, null, "[\"queued\"]", null);
        this.dao.deleteSelectors(13L);
        this.dao.deleteResourceGroup(13L);
        this.dao.insertSelector(12L, 1L, null, null, null, null, null, null, "[\"running\"]", null);
        dbConfigurationManager.load();
        QueryId thirdQueryFromQueuedGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "queued"), LONG_LASTING_QUERY);
        QueryId secondQueryFromRunningGroup = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("alice", "running"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromQueuedGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromQueuedGroup, QueryState.QUEUED);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdQueryFromQueuedGroup, QueryState.FAILED);
        this.assertFailureMessage(thirdQueryFromQueuedGroup, "Cannot add queries to 'queued'. It is not a leaf group.");
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQueryFromRunningGroup, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQueryFromRunningGroup, QueryState.RUNNING);
    }

    @Test
    @Timeout(value=60L)
    public void testSwitchGroupNameBetweenTemplateAndFixedValue() throws InterruptedException {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().orElseThrow();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        this.dao.insertResourceGroup(10L, "${USER}", "80%", 0, null, 0, null, null, null, null, null, null, "test_environment");
        this.dao.insertSelector(10L, 1L, null, null, null, null, null, null, "[\"tag\"]", null);
        dbConfigurationManager.load();
        QueryId firstQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQuery, QueryState.FAILED);
        this.assertFailureMessage(firstQuery, "Too many queued queries for \"admin\"");
        this.dao.updateResourceGroup(10L, "admin", "80%", 1, null, 0, null, null, null, null, null, null, "test_environment");
        dbConfigurationManager.load();
        QueryId secondQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.QUEUED);
        this.dao.updateResourceGroup(10L, "${USER}", "80%", 1, null, 2, null, null, null, null, null, null, "test_environment");
        dbConfigurationManager.load();
        QueryId thirdQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.RUNNING);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdQuery, QueryState.RUNNING);
    }

    @Test
    @Timeout(value=60L)
    public void testGroupHasSingleConfig() throws InterruptedException {
        InternalResourceGroupManager manager = (InternalResourceGroupManager)this.queryRunner.getCoordinator().getResourceGroupManager().orElseThrow();
        DbResourceGroupConfigurationManager dbConfigurationManager = (DbResourceGroupConfigurationManager)manager.getConfigurationManager();
        this.dao.insertResourceGroup(10L, "${USER}", "80%", 100, null, 100, null, null, null, null, null, null, "test_environment");
        this.dao.insertSelector(10L, 100L, null, null, null, null, null, null, "[\"tag\"]", null);
        dbConfigurationManager.load();
        QueryId firstQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, firstQuery, QueryState.RUNNING);
        this.dao.updateResourceGroup(10L, "admin", "80%", 100, null, 100, null, null, null, null, null, null, "test_environment");
        dbConfigurationManager.load();
        QueryId secondQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, secondQuery, QueryState.RUNNING);
        this.dao.insertResourceGroup(11L, "${USER}", "80%", 0, null, 0, null, null, null, null, null, null, "test_environment");
        this.dao.insertSelector(11L, 101L, null, null, null, null, null, null, "[\"tag\"]", null);
        dbConfigurationManager.load();
        QueryId thirdQuery = QueryRunnerUtil.createQuery(this.queryRunner, TestQueuesDb.session("admin", "tag"), LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, thirdQuery, QueryState.RUNNING);
    }

    private static Session session(String user, String clientTag) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)user)).setCatalog("tpch").setSchema("sf100000").setClientTags((Set)ImmutableSet.of((Object)clientTag)).build();
    }

    private void assertFailureMessage(QueryId queryId, String message) {
        Optional fullQueryInfo = this.queryRunner.getCoordinator().getDispatchManager().getFullQueryInfo(queryId);
        Assertions.assertThat((boolean)fullQueryInfo.isPresent()).isTrue();
        ExecutionFailureInfo failureInfo = ((QueryInfo)fullQueryInfo.get()).getFailureInfo();
        Assertions.assertThat((Object)failureInfo).isNotNull();
        Assertions.assertThat((String)failureInfo.getMessage()).isEqualTo(message);
    }

    private void assertResourceGroupWithClientTags(Set<String> clientTags, ResourceGroupId expectedResourceGroup) throws InterruptedException {
        Session session = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("sf100000").setSource("client_tags").setClientTags(clientTags).build();
        QueryId queryId = QueryRunnerUtil.createQuery(this.queryRunner, session, LONG_LASTING_QUERY);
        QueryRunnerUtil.waitForQueryState(this.queryRunner, queryId, (Set<QueryState>)ImmutableSet.of((Object)QueryState.RUNNING, (Object)QueryState.FINISHED));
        Optional resourceGroupId = this.queryRunner.getCoordinator().getQueryManager().getFullQueryInfo(queryId).getResourceGroupId();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)resourceGroupId.isPresent()).describedAs("Query should have a resource group", new Object[0])).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)((ResourceGroupId)resourceGroupId.get())).describedAs(String.format("Expected: '%s' resource group, found: %s", expectedResourceGroup, resourceGroupId.get()), new Object[0])).isEqualTo((Object)expectedResourceGroup);
    }
}

