/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.SessionTestUtils;
import io.trino.execution.QueryState;
import io.trino.memory.ClusterMemoryLeakDetector;
import io.trino.operator.BlockedReason;
import io.trino.operator.RetryPolicy;
import io.trino.server.BasicQueryInfo;
import io.trino.server.BasicQueryStats;
import io.trino.spi.QueryId;
import io.trino.spi.resourcegroups.ResourceGroupId;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.joda.time.DateTime;
import org.junit.jupiter.api.Test;

public class TestClusterMemoryLeakDetector {
    @Test
    public void testLeakDetector() {
        QueryId testQuery = new QueryId("test");
        ClusterMemoryLeakDetector leakDetector = new ClusterMemoryLeakDetector();
        leakDetector.checkForMemoryLeaks(ImmutableList::of, (Map)ImmutableMap.of());
        Assertions.assertThat((int)leakDetector.getNumberOfLeakedQueries()).isEqualTo(0);
        leakDetector.checkForMemoryLeaks(() -> ImmutableList.of((Object)TestClusterMemoryLeakDetector.createQueryInfo(testQuery.getId(), QueryState.RUNNING)), (Map)ImmutableMap.of((Object)testQuery, (Object)1L));
        Assertions.assertThat((int)leakDetector.getNumberOfLeakedQueries()).isEqualTo(0);
        leakDetector.checkForMemoryLeaks(() -> ImmutableList.of((Object)TestClusterMemoryLeakDetector.createQueryInfo(testQuery.getId(), QueryState.FINISHED)), (Map)ImmutableMap.of((Object)testQuery, (Object)1L));
        Assertions.assertThat((int)leakDetector.getNumberOfLeakedQueries()).isEqualTo(1);
        leakDetector.checkForMemoryLeaks(() -> ImmutableList.of((Object)TestClusterMemoryLeakDetector.createQueryInfo(testQuery.getId(), QueryState.FINISHED)), (Map)ImmutableMap.of((Object)testQuery, (Object)0L));
        Assertions.assertThat((int)leakDetector.getNumberOfLeakedQueries()).isEqualTo(0);
        leakDetector.checkForMemoryLeaks(ImmutableList::of, (Map)ImmutableMap.of((Object)testQuery, (Object)1L));
        Assertions.assertThat((int)leakDetector.getNumberOfLeakedQueries()).isEqualTo(1);
    }

    private static BasicQueryInfo createQueryInfo(String queryId, QueryState state) {
        return new BasicQueryInfo(new QueryId(queryId), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), Optional.of(new ResourceGroupId("global")), state, true, URI.create("1"), "", Optional.empty(), Optional.empty(), new BasicQueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), new Duration(8.0, TimeUnit.MINUTES), new Duration(7.0, TimeUnit.MINUTES), new Duration(34.0, TimeUnit.MINUTES), 99, 13, 14, 15, 100, 0, DataSize.valueOf((String)"21GB"), 22L, DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"23GB"), 24.0, 25.0, DataSize.valueOf((String)"26GB"), DataSize.valueOf((String)"27GB"), DataSize.valueOf((String)"28GB"), DataSize.valueOf((String)"29GB"), new Duration(30.0, TimeUnit.MINUTES), new Duration(31.0, TimeUnit.MINUTES), new Duration(32.0, TimeUnit.MINUTES), new Duration(33.0, TimeUnit.MINUTES), new Duration(34.0, TimeUnit.MINUTES), new Duration(35.0, TimeUnit.MINUTES), new Duration(36.0, TimeUnit.MINUTES), new Duration(37.0, TimeUnit.MINUTES), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), OptionalDouble.of(20.0), OptionalDouble.of(0.0)), null, null, Optional.empty(), RetryPolicy.NONE);
    }
}

