/*
 * Decompiled with CFR 0.152.
 */
package io.trino.memory;

import io.trino.Session;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestMemorySessionProperties
extends AbstractTestQueryFramework {
    public static final String sql = "SELECT COUNT(*), clerk FROM orders GROUP BY clerk";

    protected QueryRunner createQueryRunner() throws Exception {
        return ((TpchQueryRunner.Builder)TpchQueryRunner.builder().setWorkerCount(1)).build();
    }

    @Test
    @Timeout(value=240L)
    public void testSessionQueryMemoryPerNodeLimit() {
        this.assertQuery(sql);
        Session session = Session.builder((Session)this.getSession()).setSystemProperty("query_max_memory_per_node", "1kB").build();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(session, sql)).isInstanceOf(RuntimeException.class)).hasMessageStartingWith("Query exceeded per-node memory limit of ");
    }
}

