/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Scopes;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.plugin.base.security.AllowAllSystemAccessControl;
import io.trino.plugin.base.security.DefaultSystemAccessControl;
import io.trino.plugin.base.security.ForwardingSystemAccessControl;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.security.TestingSystemSecurityMetadata;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.SchemaFunctionName;
import io.trino.spi.function.Signature;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.GroupProvider;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.SystemAccessControl;
import io.trino.spi.security.SystemSecurityContext;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.SqlPath;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingGroupProvider;
import io.trino.testing.TestingNames;
import io.trino.testing.TestingSession;
import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestAccessControl
extends AbstractTestQueryFramework {
    private static final String DEFAULT_SCHEMA = "default";
    private static final String REDIRECTED_SOURCE = "redirected_source";
    private static final String REDIRECTED_TARGET = "redirected_target";
    private final AtomicReference<SystemAccessControl> systemAccessControl = new AtomicReference<DefaultSystemAccessControl>(new DefaultSystemAccessControl());
    private final TestingGroupProvider groupProvider = new TestingGroupProvider();
    private TestingSystemSecurityMetadata systemSecurityMetadata;

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setSource("test").setCatalog("blackhole").setSchema(DEFAULT_SCHEMA).setPath(SqlPath.buildPath((String)"mock.function", Optional.empty())).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, SystemSecurityMetadata.class).setBinding().to(TestingSystemSecurityMetadata.class).in(Scopes.SINGLETON)).setWorkerCount(0).setSystemAccessControl((SystemAccessControl)new ForwardingSystemAccessControl(){

            protected SystemAccessControl delegate() {
                return TestAccessControl.this.systemAccessControl.get();
            }
        }).build();
        queryRunner.getGroupProvider().setConfiguredGroupProvider((GroupProvider)this.groupProvider);
        queryRunner.installPlugin((Plugin)new BlackHolePlugin());
        queryRunner.createCatalog("blackhole", "blackhole");
        queryRunner.installPlugin((Plugin)new MemoryPlugin());
        queryRunner.createCatalog("memory", "memory", Map.of());
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withGetTableHandle((session1, schemaTableName) -> {
            if (schemaTableName.getTableName().startsWith("new")) {
                return null;
            }
            return new MockConnectorTableHandle(schemaTableName);
        }).withListSchemaNames(connectorSession -> ImmutableList.of((Object)DEFAULT_SCHEMA)).withListTables((connectorSession, schemaName) -> {
            if (schemaName.equals(DEFAULT_SCHEMA)) {
                return ImmutableList.of((Object)REDIRECTED_SOURCE);
            }
            return ImmutableList.of();
        }).withGetViews((connectorSession, prefix) -> {
            ConnectorViewDefinition definitionRunAsDefiner = new ConnectorViewDefinition("SELECT 1 AS test", Optional.of("mock"), Optional.of(DEFAULT_SCHEMA), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of("admin"), false, (List)ImmutableList.of());
            ConnectorViewDefinition definitionRunAsInvoker = new ConnectorViewDefinition("SELECT 1 AS test", Optional.of("mock"), Optional.of(DEFAULT_SCHEMA), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.empty(), true, (List)ImmutableList.of());
            return ImmutableMap.of((Object)new SchemaTableName(DEFAULT_SCHEMA, "test_view_definer"), (Object)definitionRunAsDefiner, (Object)new SchemaTableName(DEFAULT_SCHEMA, "test_view_invoker"), (Object)definitionRunAsInvoker);
        }).withGetMaterializedViews((BiFunction)new BiFunction<ConnectorSession, SchemaTablePrefix, Map<SchemaTableName, ConnectorMaterializedViewDefinition>>(this){

            @Override
            public Map<SchemaTableName, ConnectorMaterializedViewDefinition> apply(ConnectorSession session, SchemaTablePrefix schemaTablePrefix) {
                ConnectorMaterializedViewDefinition materializedViewDefinition = new ConnectorMaterializedViewDefinition("SELECT 1 AS test", Optional.empty(), Optional.empty(), Optional.empty(), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("test", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.of("comment"), Optional.of("owner"), (List)ImmutableList.of());
                return ImmutableMap.of((Object)new SchemaTableName(TestAccessControl.DEFAULT_SCHEMA, "test_materialized_view"), (Object)materializedViewDefinition);
            }
        }).withListRoleGrants((connectorSession, roles, grantees, limit) -> ImmutableSet.of((Object)new RoleGrant(new TrinoPrincipal(PrincipalType.USER, "alice"), "alice_role", false))).withAnalyzeProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"another_property", (String)"description", (Integer)0, (boolean)false), (Object)PropertyMetadata.integerProperty((String)"integer_analyze_property", (String)"description", (Integer)0, (boolean)false))).withGetMaterializedViewProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"another_property", (String)"description", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"string_materialized_view_property", (String)"description", (String)"", (boolean)false))).withSchemaProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"another_property", (String)"description", (Integer)0, (boolean)false), (Object)PropertyMetadata.booleanProperty((String)"boolean_schema_property", (String)"description", (Boolean)false, (boolean)false))).withTableProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"another_property", (String)"description", (Integer)0, (boolean)false), (Object)PropertyMetadata.doubleProperty((String)"double_table_property", (String)"description", (Double)0.0, (boolean)false))).withColumnProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"another_property", (String)"description", (Integer)0, (boolean)false), (Object)PropertyMetadata.stringProperty((String)"string_column_property", (String)"description", (String)"", (boolean)false))).withRedirectTable((connectorSession, schemaTableName) -> {
            if (schemaTableName.equals((Object)SchemaTableName.schemaTableName((String)DEFAULT_SCHEMA, (String)REDIRECTED_SOURCE))) {
                return Optional.of(new CatalogSchemaTableName("mock", SchemaTableName.schemaTableName((String)DEFAULT_SCHEMA, (String)REDIRECTED_TARGET)));
            }
            return Optional.empty();
        }).withGetComment(schemaTableName -> {
            if (schemaTableName.getTableName().equals(REDIRECTED_TARGET)) {
                return Optional.of("this is a redirected table");
            }
            return Optional.empty();
        }).withFunctions((Collection)ImmutableList.builder().add((Object)FunctionMetadata.scalarBuilder((String)"my_function").signature(Signature.builder().argumentType((Type)BigintType.BIGINT).returnType((Type)BigintType.BIGINT).build()).noDescription().build()).add((Object)FunctionMetadata.scalarBuilder((String)"other_function").signature(Signature.builder().argumentType((Type)BigintType.BIGINT).returnType((Type)BigintType.BIGINT).build()).noDescription().build()).build()).withFunctionProvider(Optional.of(new FunctionProvider(this){

            public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
                return ScalarFunctionImplementation.builder().methodHandle(MethodHandles.identity(Long.TYPE)).build();
            }
        })).build()));
        queryRunner.createCatalog("mock", "mock");
        queryRunner.installPlugin((Plugin)new JdbcPlugin("base_jdbc", TestingH2JdbcModule::new));
        queryRunner.createCatalog("jdbc", "base_jdbc", TestingH2JdbcModule.createProperties());
        for (String tableName : ImmutableList.of((Object)"orders", (Object)"nation", (Object)"region", (Object)"lineitem")) {
            queryRunner.execute(String.format("CREATE TABLE %1$s AS SELECT * FROM tpch.tiny.%1$s WITH NO DATA", tableName));
        }
        this.systemSecurityMetadata = (TestingSystemSecurityMetadata)queryRunner.getCoordinator().getInstance(Key.get(SystemSecurityMetadata.class));
        return queryRunner;
    }

    private void reset() {
        this.systemAccessControl.set((SystemAccessControl)new DefaultSystemAccessControl());
        Objects.requireNonNull(this.systemSecurityMetadata, "systemSecurityMetadata is null").reset();
        this.getQueryRunner().getAccessControl().reset();
        this.groupProvider.reset();
    }

    @Test
    public void testAccessControl() {
        this.reset();
        this.assertAccessDenied("SELECT * FROM orders", "Cannot execute query", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_QUERY)});
        this.assertAccessDenied("INSERT INTO orders SELECT * FROM orders", "Cannot insert into table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertAccessDenied("DELETE FROM orders", "Cannot delete from table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE)});
        this.assertAccessDenied("TRUNCATE TABLE orders", "Cannot truncate table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.TRUNCATE_TABLE)});
        this.assertAccessDenied("CREATE TABLE foo AS SELECT * FROM orders", "Cannot create table .*.foo.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE)});
        this.assertAccessDenied("ALTER TABLE orders SET PROPERTIES field_length = 32", "Cannot set table properties to .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_TABLE_PROPERTIES)});
        this.assertAccessDenied("ALTER TABLE orders ALTER COLUMN orderkey SET DATA TYPE char(100)", "Cannot alter a column for table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ALTER_COLUMN)});
        this.assertAccessDenied("SELECT * FROM nation", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT * FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT name FROM (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT name FROM nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT n1.nationkey, n2.regionkey FROM nation n1, nation n2", "Cannot select from columns \\[nationkey, regionkey] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT count(name) as c FROM nation where comment > 'abc' GROUP BY regionkey having max(nationkey) > 10", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT 1 FROM region, nation where region.regionkey = nation.nationkey", "Cannot select from columns \\[nationkey] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT count(*) FROM nation", "Cannot select from columns \\[] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("WITH t1 AS (SELECT * FROM nation) SELECT * FROM t1", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT name AS my_alias FROM nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT my_alias from (SELECT name AS my_alias FROM nation)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"my_alias", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT name AS my_alias FROM nation", "Cannot select from columns \\[name] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.name", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT 1 FROM mock.default.test_materialized_view", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT 1 FROM mock.default.test_materialized_view", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_materialized_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT * FROM mock.default.test_materialized_view", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT * FROM mock.default.test_materialized_view", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_materialized_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT 1 FROM mock.default.test_view_definer", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT 1 FROM mock.default.test_view_definer", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_definer", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT * FROM mock.default.test_view_definer", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT * FROM mock.default.test_view_definer", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_definer", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT 1 FROM mock.default.test_view_invoker", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT 1 FROM mock.default.test_view_invoker", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_invoker", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT * FROM mock.default.test_view_invoker", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT * FROM mock.default.test_view_invoker", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_invoker", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT count(*) FROM mock.default.test_materialized_view", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT count(*) FROM mock.default.test_materialized_view", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_materialized_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT count(*) FROM mock.default.test_view_invoker", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT count(*) FROM mock.default.test_view_invoker", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_invoker", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SELECT count(*) FROM mock.default.test_view_definer", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT count(*) FROM mock.default.test_view_definer", "Cannot select from columns.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_view_definer", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT orders.custkey, lineitem.quantity FROM orders JOIN lineitem USING (orderkey)", "Cannot select from columns \\[orderkey, custkey] in table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT orders.custkey, lineitem.quantity FROM orders JOIN lineitem USING (orderkey)", "Cannot select from columns \\[orderkey, quantity] in table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"lineitem.orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW CREATE TABLE orders", "Cannot show create table for .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        this.assertAccessAllowed("SHOW CREATE TABLE lineitem", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        this.assertAccessDenied("SELECT my_function(1)", "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SELECT my_function(1)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"max", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SELECT abs(-10)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SELECT abs(-10)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"system.builtin.abs", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SHOW STATS FOR lineitem", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SHOW STATS FOR lineitem", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("SHOW STATS FOR (SELECT * FROM lineitem)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SHOW STATS FOR (SELECT * FROM lineitem)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT nationkey FROM nation)", "Cannot select from columns \\[nationkey] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT nationkey FROM nation)", "Cannot select from columns \\[nationkey] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT *, nationkey FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT *, * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT linenumber, orderkey FROM lineitem)", "Cannot select from columns \\[linenumber, orderkey] in table or view .*.lineitem.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"lineitem", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT linenumber, orderkey, quantity FROM lineitem)", "Cannot select from columns \\[linenumber, orderkey, quantity] in table or view .*.lineitem.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"lineitem.linenumber", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN), TestingAccessControlManager.privilege((String)"lineitem.orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT nationkey FROM nation)", "Cannot select from columns \\[nationkey] in table or view .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SHOW STATS FOR (SELECT * FROM nation)", "Cannot select from columns \\[nationkey, regionkey, name, comment] in table or view .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testViewColumnAccessControl() {
        this.reset();
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_view_access_owner")).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        String columnAccessViewName = "test_view_column_access_" + TestingNames.randomNameSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + columnAccessViewName + " AS SELECT * FROM orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessDenied("SELECT * FROM " + columnAccessViewName, "View owner does not have sufficient privileges: View owner 'test_view_access_owner' cannot create view that selects from \\w+.\\w+.orders\\w*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed(viewOwnerSession, "SELECT * FROM " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed("SELECT * FROM " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed("SELECT * FROM " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        Session nestedViewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_nested_view_access_owner")).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        String nestedViewName = "test_nested_view_column_access_" + TestingNames.randomNameSuffix();
        this.assertAccessAllowed(nestedViewOwnerSession, "CREATE VIEW " + nestedViewName + " AS SELECT * FROM " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessDenied("SELECT * FROM " + nestedViewName, "View owner does not have sufficient privileges: View owner 'test_nested_view_access_owner' cannot create view that selects from \\w+.\\w+.test_view_column_access\\w*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)nestedViewOwnerSession.getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed("SELECT * FROM " + nestedViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed("SELECT * FROM " + nestedViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)columnAccessViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        String invokerViewName = "test_invoker_view_column_access_" + TestingNames.randomNameSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + invokerViewName + " SECURITY INVOKER AS SELECT * FROM orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.assertAccessAllowed("SELECT * FROM " + invokerViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("SELECT * FROM " + invokerViewName, "Cannot select from columns \\[.*] in table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.getQueryRunner().getAccessControl().denyIdentityTable((identity, table) -> identity.getGroups().contains("testgroup") || !"orders".equals(table));
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(this.getSession(), "SELECT * FROM " + columnAccessViewName)).hasMessageMatching("Access Denied: View owner does not have sufficient privileges: View owner 'test_view_access_owner' cannot create view that selects from \\w+.\\w+.orders");
        this.groupProvider.setUserGroups((Map)ImmutableMap.of((Object)viewOwnerSession.getUser(), (Object)ImmutableSet.of((Object)"testgroup")));
        this.getQueryRunner().execute(this.getSession(), "SELECT * FROM " + columnAccessViewName);
        this.assertAccessDenied("SHOW CREATE VIEW " + nestedViewName, "Cannot show create table for .*test_nested_view_column_access.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)nestedViewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        this.assertAccessAllowed("SHOW CREATE VIEW " + nestedViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"test_denied_access_view", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_CREATE_TABLE)});
        this.assertAccessAllowed(nestedViewOwnerSession, "DROP VIEW " + nestedViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + columnAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + invokerViewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testViewOwnersRoleGrants() {
        this.reset();
        String viewOwner = "view_owner";
        TrinoPrincipal viewOwnerPrincipal = new TrinoPrincipal(PrincipalType.USER, viewOwner);
        String viewName = "test_view_column_access_" + TestingNames.randomNameSuffix();
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of("view_owner_role"), Set.of(viewOwnerPrincipal), false, Optional.empty());
        this.systemSecurityMetadata.setEntityOwner(this.getSession(), new EntityKindAndName("VIEW", List.of("blackhole", DEFAULT_SCHEMA, viewName)), viewOwnerPrincipal);
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)viewOwner).withEnabledRoles(Set.of("view_owner_role")).build()).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + viewName + " AS SELECT * FROM orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.getQueryRunner().getAccessControl().denyIdentityTable((identity, table) -> !identity.getEnabledRoles().contains("view_owner_role_without_access") || !"orders".equals(table));
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of("view_owner_role_without_access"), Set.of(viewOwnerPrincipal), false, Optional.empty());
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM " + viewName)).hasMessageMatching("Access Denied: Cannot select from columns \\[.*] in table or view \\w+\\.\\w+\\.orders");
        this.systemSecurityMetadata.revokeRoles(this.getSession(), Set.of("view_owner_role_without_access"), Set.of(viewOwnerPrincipal), false, Optional.empty());
        this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM " + viewName);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + viewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testJoinBaseTableWithView() {
        this.reset();
        String viewOwner = "view_owner";
        TrinoPrincipal viewOwnerPrincipal = new TrinoPrincipal(PrincipalType.USER, viewOwner);
        String viewName = "test_join_base_table_with_view_" + TestingNames.randomNameSuffix();
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of("view_owner_role"), Set.of(viewOwnerPrincipal), false, Optional.empty());
        this.systemSecurityMetadata.setEntityOwner(this.getSession(), new EntityKindAndName("VIEW", List.of("blackhole", DEFAULT_SCHEMA, viewName)), viewOwnerPrincipal);
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)viewOwner).withEnabledRoles(Set.of("view_owner_role")).build()).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + viewName + " AS SELECT * FROM orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW_WITH_SELECT_COLUMNS)});
        this.getQueryRunner().getAccessControl().denyIdentityTable((identity, table) -> !identity.getEnabledRoles().contains("view_owner_role_without_access") || !"orders".equals(table));
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of("view_owner_role_without_access"), Set.of(viewOwnerPrincipal), false, Optional.empty());
        String errorMessage = "Access Denied: Cannot select from columns \\[.*] in table or view \\w+\\.\\w+\\.orders";
        this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM orders");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM " + viewName)).hasMessageMatching(errorMessage);
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM orders, " + viewName)).hasMessageMatching(errorMessage);
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(viewOwnerSession, "SELECT * FROM %s, orders".formatted(viewName))).hasMessageMatching(errorMessage);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + viewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testAllowCallFunction() {
        this.reset();
        String functionOwner = "function_owner";
        CatalogSchemaFunctionName outerFunction = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "function_allow_outer"));
        CatalogSchemaFunctionName innerFunction = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "function_allow_inner"));
        Session functionOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)functionOwner)).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(functionOwnerSession, "CREATE FUNCTION memory.default.function_allow_inner (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(innerFunction)).isEqualTo(functionOwner);
        this.assertAccessAllowed(functionOwnerSession, "SELECT memory.default.function_allow_inner(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SELECT memory.default.function_allow_inner(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(functionOwnerSession, "CREATE FUNCTION memory.default.function_allow_outer (x integer) RETURNS bigint RETURN x + memory.default.function_allow_inner(58)", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(outerFunction)).isEqualTo(functionOwner);
        this.assertAccessAllowed(functionOwnerSession, "SELECT memory.default.function_allow_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SELECT memory.default.function_allow_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SELECT memory.default.function_allow_outer(2)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"memory.default.function_allow_inner", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessDenied("SELECT memory.default.function_allow_inner(2)", "Cannot execute function memory.default.function_allow_inner", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"memory.default.function_allow_inner", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
    }

    @Test
    public void testAllowCallFunctionWithRoleGrant() {
        this.reset();
        String functionOwner = "function_owner";
        CatalogSchemaFunctionName outerFunction = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "function_deny_outer"));
        CatalogSchemaFunctionName innerFunction = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "function_deny_inner"));
        TrinoPrincipal functionOwnerPrincipal = new TrinoPrincipal(PrincipalType.USER, functionOwner);
        this.systemSecurityMetadata.grantRoles(this.getSession(), (Set<String>)ImmutableSet.of((Object)"function_owner_role"), (Set<TrinoPrincipal>)ImmutableSet.of((Object)functionOwnerPrincipal), false, Optional.empty());
        Session functionOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)functionOwner).withEnabledRoles(Set.of("function_owner_role")).build()).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(functionOwnerSession, "CREATE FUNCTION memory.default.function_deny_inner (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(innerFunction)).isEqualTo(functionOwner);
        this.assertAccessAllowed(functionOwnerSession, "CREATE FUNCTION memory.default.function_deny_outer (x integer) RETURNS bigint RETURN x + memory.default.function_deny_inner(58)", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(outerFunction)).isEqualTo(functionOwner);
        this.assertAccessAllowed(functionOwnerSession, "SELECT memory.default.function_deny_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SELECT memory.default.function_deny_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.getQueryRunner().getAccessControl().denyIdentityFunction((identity, function) -> !identity.getEnabledRoles().contains("function_owner_role_without_access") || !"default.function_deny_inner".equals(function));
        this.systemSecurityMetadata.grantRoles(this.getSession(), (Set<String>)ImmutableSet.of((Object)"function_owner_role_without_access"), (Set<TrinoPrincipal>)ImmutableSet.of((Object)functionOwnerPrincipal), false, Optional.empty());
        this.assertAccessDenied(functionOwnerSession, "SELECT memory.default.function_deny_outer(2)", "Cannot execute function memory.default.function_deny_inner", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT memory.default.function_deny_outer(2)", "Cannot execute function memory.default.function_deny_inner", new TestingAccessControlManager.TestingPrivilege[0]);
        this.systemSecurityMetadata.revokeRoles(this.getSession(), (Set<String>)ImmutableSet.of((Object)"function_owner_role_without_access"), (Set<TrinoPrincipal>)ImmutableSet.of((Object)functionOwnerPrincipal), false, Optional.empty());
        this.assertAccessAllowed(functionOwnerSession, "SELECT memory.default.function_deny_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("SELECT memory.default.function_deny_outer(2)", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testFunctionOwnerWhenDroppingFunction() {
        this.reset();
        String functionOwner1 = "function_owner1";
        String functionOwner2 = "function_owner2";
        CatalogSchemaFunctionName functionName = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "my_function"));
        Session functionOwnerSession1 = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)functionOwner1)).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        Session functionOwnerSession2 = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)functionOwner2)).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(functionOwnerSession1, "CREATE FUNCTION memory.default.my_function (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(functionName)).isEqualTo(functionOwner1);
        this.assertAccessAllowed(functionOwnerSession1, "DROP FUNCTION memory.default.my_function(integer)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(functionOwnerSession2, "CREATE FUNCTION memory.default.my_function (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(functionName)).isEqualTo(functionOwner2);
    }

    @Test
    public void testFunctionOwnerWhenReplacingFunction() {
        this.reset();
        String functionOwner1 = "function_owner1";
        String functionOwner2 = "function_owner2";
        CatalogSchemaFunctionName functionName = new CatalogSchemaFunctionName("memory", new SchemaFunctionName(DEFAULT_SCHEMA, "my_replace_function"));
        Session functionOwnerSession1 = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)functionOwner1)).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        Session functionOwnerSession2 = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)functionOwner2)).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).build();
        this.assertAccessAllowed(functionOwnerSession1, "CREATE FUNCTION memory.default.my_replace_function (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(functionName)).isEqualTo(functionOwner1);
        this.assertAccessAllowed(functionOwnerSession2, "CREATE OR REPLACE FUNCTION memory.default.my_replace_function (x integer) RETURNS bigint RETURN x + 42", new TestingAccessControlManager.TestingPrivilege[0]);
        Assertions.assertThat((String)this.systemSecurityMetadata.getFunctionOwner(functionName)).isEqualTo(functionOwner2);
    }

    @Test
    public void testViewFunctionAccessControl() {
        this.reset();
        Session viewOwnerSession = TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)"test_view_access_owner")).setCatalog(this.getSession().getCatalog()).setSchema(this.getSession().getSchema()).setPath(SqlPath.buildPath((String)"mock.function", Optional.empty())).build();
        String functionAccessViewName = "test_view_function_access_" + TestingNames.randomNameSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + functionAccessViewName + " AS SELECT my_function(1) AS c", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION)});
        this.assertAccessDenied("SELECT * FROM " + functionAccessViewName, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SELECT * FROM " + functionAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        String invokerFunctionAccessViewName = "test_invoker_view_function_access_" + TestingNames.randomNameSuffix();
        this.assertAccessAllowed(viewOwnerSession, "CREATE VIEW " + invokerFunctionAccessViewName + " SECURITY INVOKER AS SELECT my_function(1) AS c", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION)});
        this.assertAccessAllowed("SELECT * FROM " + invokerFunctionAccessViewName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewOwnerSession.getUser(), (String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessDenied("SELECT * FROM " + invokerFunctionAccessViewName, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (String)"mock.function.my_function", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + functionAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed(viewOwnerSession, "DROP VIEW " + invokerFunctionAccessViewName, new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testFunctionAccessControl() {
        this.reset();
        this.assertAccessDenied("SELECT my_function(42)", "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[]{new TestingAccessControlManager.TestingPrivilege(Optional.empty(), "mock.function.my_function", TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION)});
        TestingAccessControlManager.TestingPrivilege denyAllFunctionCalls = new TestingAccessControlManager.TestingPrivilege(Optional.empty(), name -> true, TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION);
        this.assertAccessAllowed("SELECT abs(42)", new TestingAccessControlManager.TestingPrivilege[]{denyAllFunctionCalls});
        this.assertAccessAllowed("WITH FUNCTION foo() RETURNS int RETURN 42 SELECT foo()", new TestingAccessControlManager.TestingPrivilege[]{denyAllFunctionCalls});
        this.assertAccessDenied("SELECT my_function(42)", "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[]{denyAllFunctionCalls});
        TestingAccessControlManager.TestingPrivilege denyNonMyFunctionCalls = new TestingAccessControlManager.TestingPrivilege(Optional.empty(), name -> !name.equals("mock.function.my_function"), TestingAccessControlManager.TestingPrivilegeType.EXECUTE_FUNCTION);
        this.assertAccessAllowed("SELECT my_function(42)", new TestingAccessControlManager.TestingPrivilege[]{denyNonMyFunctionCalls});
        this.assertAccessDenied("SELECT other_function(42)", "Cannot execute function other_function", new TestingAccessControlManager.TestingPrivilege[]{denyNonMyFunctionCalls});
    }

    @Test
    public void testTableFunctionRequiredColumns() {
        this.reset();
        this.assertAccessDenied("SELECT * FROM TABLE(exclude_columns(TABLE(nation), descriptor(regionkey, comment)))", "Cannot select from columns \\[nationkey, name] in table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testAnalyzeAccessControl() {
        this.reset();
        this.assertAccessAllowed("ANALYZE nation", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ANALYZE nation", "Cannot ANALYZE \\(missing insert privilege\\) table .*.nation.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertAccessDenied("ANALYZE nation", "Cannot select from columns \\[.*] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessDenied("ANALYZE nation", "Cannot select from columns \\[.*nationkey.*] in table or view .*.nation", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.nationkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testMetadataFilterColumns() {
        this.reset();
        this.getQueryRunner().getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"nation.regionkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT column_name FROM information_schema.columns WHERE table_catalog = CURRENT_CATALOG AND table_schema = CURRENT_SCHEMA and table_name = 'nation'"))).matches("VALUES VARCHAR 'nationkey', 'name', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT column_name FROM system.jdbc.columns WHERE table_cat = CURRENT_CATALOG AND table_schem = CURRENT_SCHEMA and table_name = 'nation'"))).matches("VALUES VARCHAR 'nationkey', 'name', 'comment'");
    }

    @Test
    public void testCommentView() {
        this.reset();
        String viewName = "comment_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " COMMENT 'old comment' AS SELECT * FROM orders");
        this.assertAccessDenied("COMMENT ON VIEW " + viewName + " IS 'new comment'", "Cannot comment view to .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.COMMENT_VIEW)});
        this.assertAccessAllowed("COMMENT ON VIEW " + viewName + " IS 'new comment'", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testCommentOnRedirectedTable() {
        this.reset();
        String query = "SELECT * FROM system.metadata.table_comments WHERE catalog_name = 'mock' AND schema_name = 'default' AND table_name LIKE 'redirected%'";
        this.assertQuery(query, "VALUES ('mock', 'default', 'redirected_source', 'this is a redirected table')");
        this.getQueryRunner().getAccessControl().denyTables(schemaTableName -> !schemaTableName.getTableName().equals(REDIRECTED_TARGET));
        this.assertQueryReturnsEmptyResult(query);
    }

    @Test
    public void testViewWithTableFunction() {
        this.reset();
        for (boolean securityDefiner : Arrays.asList(true, false)) {
            Session viewOwner = this.getSession();
            Session otherUser = Session.builder((Session)this.getSession()).setIdentity(Identity.ofUser((String)(this.getSession().getUser() + "-someone-else"))).build();
            String viewName = "memory.default.definer_view_with_ptf";
            this.assertUpdate(viewOwner, "CREATE VIEW " + viewName + " SECURITY " + (securityDefiner ? "DEFINER" : "INVOKER") + " AS SELECT * FROM TABLE (jdbc.system.query('SELECT ''from h2'', monthname(CAST(''2005-09-10'' AS date))'))");
            String viewValues = "VALUES ('from h2', 'September') ";
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(viewOwner, "TABLE " + viewName))).matches(viewValues);
            ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(otherUser, "TABLE " + viewName))).matches(viewValues);
            TestingAccessControlManager.TestingPrivilege grantExecute = TestingAccessControlManager.privilege((String)"jdbc.system.query", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.GRANT_EXECUTE_FUNCTION);
            this.assertAccessAllowed(viewOwner, "TABLE " + viewName, new TestingAccessControlManager.TestingPrivilege[]{grantExecute});
            if (securityDefiner) {
                this.assertAccessDenied(otherUser, "TABLE " + viewName, "Cannot execute function jdbc.system.query", new TestingAccessControlManager.TestingPrivilege[]{grantExecute});
            } else {
                this.assertAccessAllowed(otherUser, "TABLE " + viewName, new TestingAccessControlManager.TestingPrivilege[]{grantExecute});
            }
            this.assertUpdate("DROP VIEW " + viewName);
        }
    }

    @Test
    public void testCommentColumnView() {
        this.reset();
        String viewName = "comment_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM orders");
        this.assertAccessDenied("COMMENT ON COLUMN " + viewName + ".orderkey IS 'new order key comment'", "Cannot comment column to .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.COMMENT_COLUMN)});
        this.assertUpdate(this.getSession(), "COMMENT ON COLUMN " + viewName + ".orderkey IS 'new comment'");
    }

    @Test
    public void testCommentColumnMaterializedView() {
        this.reset();
        String viewName = "comment_materialized_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE MATERIALIZED VIEW mock.default." + viewName + " AS SELECT * FROM orders");
        this.assertAccessDenied("COMMENT ON COLUMN mock.default." + viewName + ".column_0 IS 'new comment'", "Cannot comment column to .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.COMMENT_COLUMN)});
        this.assertUpdate(this.getSession(), "COMMENT ON COLUMN mock.default." + viewName + ".column_0 IS 'new comment'");
    }

    @Test
    public void testAddColumn() {
        this.reset();
        String tableName = "test_add_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", 0L);
        this.assertAccessDenied("ALTER TABLE " + tableName + " ADD COLUMN new_col char(100)", "Cannot add a column to table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN)});
        this.assertAccessAllowed("ALTER TABLE " + tableName + " ADD COLUMN new_col char(100)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(tableName + ".orderkey"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN)});
    }

    @Test
    public void testDropColumn() {
        this.reset();
        String tableName = "test_drop_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", 0L);
        this.assertAccessDenied("ALTER TABLE " + tableName + " DROP COLUMN orderkey", "Cannot drop a column from table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN)});
        this.assertAccessAllowed("ALTER TABLE " + tableName + " DROP COLUMN orderkey", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(tableName + ".orderkey"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN)});
    }

    @Test
    public void testRenameColumn() {
        this.reset();
        String tableName = "test_rename_column" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", 0L);
        this.assertAccessDenied("ALTER TABLE " + tableName + " RENAME COLUMN orderkey TO renamed", "Cannot rename a column in table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN)});
        this.assertAccessAllowed("ALTER TABLE " + tableName + " RENAME COLUMN orderkey TO renamed", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(tableName + ".orderkey"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN)});
    }

    @Test
    public void testSetColumnType() {
        this.reset();
        String tableName = "test_set_colun_type" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", 0L);
        this.assertAccessDenied("ALTER TABLE " + tableName + " ALTER COLUMN orderkey SET DATA TYPE char(100)", "Cannot alter a column for table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ALTER_COLUMN)});
        this.assertAccessAllowed("ALTER TABLE " + tableName + " ALTER COLUMN orderkey SET DATA TYPE char(100)", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(tableName + ".orderkey"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ALTER_COLUMN)});
    }

    @Test
    public void testDropNotNullConstraint() {
        this.reset();
        String tableName = "test_drop_not_null" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT * FROM orders", 0L);
        this.assertAccessDenied("ALTER TABLE " + tableName + " ALTER COLUMN orderkey DROP NOT NULL", "Cannot alter a column for table .*." + tableName + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)tableName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ALTER_COLUMN)});
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(this.getSession(), "ALTER TABLE " + tableName + " ALTER COLUMN orderkey DROP NOT NULL")).hasMessageContaining("Column is already nullable");
    }

    @Test
    public void testSetTableProperties() {
        this.reset();
        this.assertAccessDenied("ALTER TABLE orders SET PROPERTIES field_length = 32", "Cannot set table properties to .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_TABLE_PROPERTIES)});
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(this.getSession(), "ALTER TABLE orders SET PROPERTIES field_length = 32")).hasMessageContaining("This connector does not support setting table properties");
    }

    @Test
    public void testDeleteAccessControl() {
        this.reset();
        this.assertAccessDenied("DELETE FROM orders WHERE orderkey < 12", "Cannot select from columns \\[orderkey] in table or view .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("DELETE FROM orders WHERE orderkey < 12", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderdate", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("DELETE FROM orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testTruncateAccessControl() {
        this.reset();
        this.assertAccessAllowed("TRUNCATE TABLE orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testUpdateAccessControl() {
        this.reset();
        this.assertAccessDenied("UPDATE orders SET orderkey=123", "Cannot update columns \\[orderkey] in table .*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.UPDATE_TABLE)});
        this.assertAccessDenied("UPDATE orders SET orderkey=123 WHERE custkey < 12", "Cannot select from columns \\[custkey] in table or view .*.default.orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.custkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertAccessAllowed("UPDATE orders SET orderkey=123", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testMergeAccessControl() {
        this.reset();
        String catalogName = (String)this.getSession().getCatalog().orElseThrow();
        String schemaName = (String)this.getSession().getSchema().orElseThrow();
        String targetTable = "merge_nation_target_" + TestingNames.randomNameSuffix();
        String targetName = String.format("%s.%s.%s", catalogName, schemaName, targetTable);
        String sourceTable = "merge_nation_source_" + TestingNames.randomNameSuffix();
        String sourceName = String.format("%s.%s.%s", catalogName, schemaName, sourceTable);
        this.assertUpdate(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", targetTable));
        this.assertUpdate(String.format("CREATE TABLE %s (nation_name VARCHAR, region_name VARCHAR)", sourceTable));
        String baseMergeSql = String.format("MERGE INTO %s t USING %s s", targetTable, sourceTable) + "    ON (t.nation_name = s.nation_name)";
        String deleteCase = "    WHEN MATCHED AND t.nation_name > (SELECT name FROM tpch.tiny.region WHERE name = t.region_name AND name LIKE ('A%'))        THEN DELETE";
        String updateCase = "    WHEN MATCHED AND t.nation_name = 'GERMANY'        THEN UPDATE SET nation_name = concat(s.nation_name, '_foo')";
        String insertCase = "    WHEN NOT MATCHED AND s.region_name = 'EUROPE'        THEN INSERT VALUES(s.nation_name, (SELECT 'EUROPE'))";
        for (String mergeCase : ImmutableList.of((Object)deleteCase, (Object)updateCase, (Object)insertCase)) {
            this.assertAccessDenied(baseMergeSql + mergeCase, "Cannot select from columns .* in table or view " + sourceName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)sourceTable, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        }
        for (String mergeCase : ImmutableList.of((Object)deleteCase, (Object)updateCase, (Object)insertCase)) {
            this.assertAccessDenied(baseMergeSql + mergeCase, "Cannot select from columns .* in table or view " + targetName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)targetTable, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        }
        this.assertAccessDenied(baseMergeSql + insertCase, "Cannot insert into table " + targetName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)targetTable, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.INSERT_TABLE)});
        this.assertAccessDenied(baseMergeSql + deleteCase, "Cannot delete from table " + targetName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)targetTable, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DELETE_TABLE)});
        this.assertAccessDenied(baseMergeSql + updateCase, "Cannot update columns \\[nation_name] in table " + targetName, new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)targetTable, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.UPDATE_TABLE)});
        this.assertAccessAllowed("MERGE INTO orders o USING region r ON (o.orderkey = r.regionkey)\nWHEN MATCHED AND o.orderkey % 2 = 0 THEN DELETE\nWHEN MATCHED AND o.orderkey % 2 = 1 THEN UPDATE SET orderkey = null\nWHEN NOT MATCHED THEN INSERT VALUES (null, null, null, null, null, null, null, null, null)\n", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertUpdate("DROP TABLE " + sourceTable);
        this.assertUpdate("DROP TABLE " + targetTable);
    }

    @Test
    public void testNonQueryAccessControl() {
        this.reset();
        this.assertAccessDenied("SET SESSION query_max_memory = '10MB'", "Cannot set system session property query_max_memory", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"query_max_memory", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_SESSION)});
        this.assertAccessDenied("CREATE TABLE foo (pk bigint)", "Cannot create table .*.foo.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_TABLE)});
        this.assertAccessDenied("DROP TABLE orders", "Cannot drop table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE)});
        this.assertAccessDenied("ALTER TABLE orders RENAME TO foo", "Cannot rename table .*.orders.* to .*.foo.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_TABLE)});
        this.assertAccessDenied("ALTER TABLE orders SET PROPERTIES field_length = 32", "Cannot set table properties to .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_TABLE_PROPERTIES)});
        this.assertAccessDenied("ALTER TABLE orders ADD COLUMN foo bigint", "Cannot add a column to table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN)});
        this.assertAccessDenied("ALTER TABLE orders DROP COLUMN foo", "Cannot drop a column from table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN)});
        this.assertAccessDenied("ALTER TABLE orders RENAME COLUMN orderkey TO foo", "Cannot rename a column in table .*.orders.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN)});
        this.assertAccessDenied("CREATE VIEW foo as SELECT * FROM orders", "Cannot create view .*.foo.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_VIEW)});
        this.assertAccessDenied("CREATE MATERIALIZED VIEW foo as SELECT * FROM orders", "Cannot create materialized view .*.foo.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"foo", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.CREATE_MATERIALIZED_VIEW)});
        try {
            this.assertAccessDenied("SELECT 1", "Principal .* cannot become user " + this.getSession().getUser() + ".*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)this.getSession().getUser(), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SET_USER)});
        }
        catch (AssertionError e) {
            Assertions.assertThat((Throwable)((Object)e)).hasMessageContaining("statusCode=403");
        }
    }

    @Test
    public void testDescribe() {
        this.reset();
        this.assertAccessDenied("DESCRIBE orders", "Cannot show columns of table default.orders", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_COLUMNS)});
        this.getQueryRunner().getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"orders.orderkey", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertQuery("DESCRIBE orders", "VALUES ('custkey', 'bigint', '', ''),('orderstatus', 'varchar(1)', '', ''),('totalprice', 'double', '', ''),('orderdate', 'date', '', ''),('orderpriority', 'varchar(15)', '', ''),('clerk', 'varchar(15)', '', ''),('shippriority', 'integer', '', ''),('comment', 'varchar(79)', '', '')");
    }

    @Test
    public void testDescribeForViews() {
        this.reset();
        String viewName = "describe_orders_view" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE VIEW " + viewName + " AS SELECT * FROM orders");
        this.assertAccessDenied("DESCRIBE " + viewName, "Cannot show columns of table default.*", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)viewName, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SHOW_COLUMNS)});
        this.getQueryRunner().getAccessControl().deny(new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)(viewName + ".orderkey"), (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
        this.assertQuery("DESCRIBE " + viewName, "VALUES ('custkey', 'bigint', '', ''),('orderstatus', 'varchar(1)', '', ''),('totalprice', 'double', '', ''),('orderdate', 'date', '', ''),('orderpriority', 'varchar(15)', '', ''),('clerk', 'varchar(15)', '', ''),('shippriority', 'integer', '', ''),('comment', 'varchar(79)', '', '')");
        this.assertUpdate("DROP VIEW " + viewName);
    }

    @Test
    public void testNoCatalogIsNeededInSessionForShowRoles() {
        this.reset();
        Session session = TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)"alice").withConnectorRoles((Map)ImmutableMap.of((Object)"mock", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("alice_role")))).build()).build();
        this.assertQuery(session, "SHOW ROLES IN mock", "VALUES 'alice_role'");
        this.assertQuery(session, "SHOW ROLE GRANTS IN mock", "VALUES 'alice_role'");
        this.assertQuery(session, "SHOW CURRENT ROLES FROM mock", "VALUES 'alice_role'");
        this.assertQuery(session, "SELECT * FROM mock.information_schema.applicable_roles", "SELECT 'alice', 'USER', 'alice_role', 'NO'");
    }

    @Test
    public void testShowRolesWithLegacyCatalogRoles() {
        this.reset();
        Session session = TestingSession.testSessionBuilder().setCatalog("mock").setIdentity(Identity.forUser((String)"alice").withConnectorRoles((Map)ImmutableMap.of((Object)"mock", (Object)new SelectedRole(SelectedRole.Type.ROLE, Optional.of("alice_role")))).build()).setSystemProperty("legacy_catalog_roles", "true").build();
        this.assertQuery(session, "SHOW ROLES", "VALUES 'alice_role'");
        this.assertQuery(session, "SHOW ROLE GRANTS", "VALUES 'alice_role'");
        this.assertQuery(session, "SHOW CURRENT ROLES", "VALUES 'alice_role'");
        this.assertQuery(session, "SELECT * FROM mock.information_schema.applicable_roles", "SELECT 'alice', 'USER', 'alice_role', 'NO'");
    }

    @Test
    public void testEmptyRoles() {
        this.reset();
        this.assertQueryReturnsEmptyResult("SHOW ROLES");
        this.assertQueryReturnsEmptyResult("SHOW ROLE GRANTS");
        this.assertQueryReturnsEmptyResult("SHOW CURRENT ROLES");
        this.assertQueryReturnsEmptyResult("SELECT * FROM information_schema.applicable_roles");
    }

    @Test
    public void testSetViewAuthorizationWithSecurityDefiner() {
        this.reset();
        this.assertQuerySucceeds("ALTER VIEW mock.default.test_view_definer SET AUTHORIZATION some_other_user");
    }

    @Test
    public void testSetViewAuthorizationWithSecurityInvoker() {
        this.reset();
        this.assertQuerySucceeds("ALTER VIEW mock.default.test_view_invoker SET AUTHORIZATION some_other_user");
    }

    @Test
    public void testSystemMetadataAnalyzePropertiesFilteringValues() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("mock"));
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.metadata.analyze_properties");
    }

    @Test
    public void testSystemMetadataMaterializedViewPropertiesFilteringValues() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("mock"));
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.metadata.materialized_view_properties");
    }

    @Test
    public void testSystemMetadataSchemaPropertiesFilteringValues() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("mock"));
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.metadata.schema_properties");
    }

    @Test
    public void testSystemMetadataTablePropertiesFilteringValues() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("blackhole") && !catalog.equals("mock"));
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.metadata.table_properties");
    }

    @Test
    public void testSystemMetadataColumnPropertiesFilteringValues() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("mock"));
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.metadata.column_properties");
    }

    @Test
    public void testUseStatementAccessControl() {
        this.reset();
        Session session = TestingSession.testSessionBuilder().setCatalog(Optional.empty()).setSchema(Optional.empty()).build();
        this.getQueryRunner().execute(session, "USE tpch.tiny");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("USE not_exists_catalog.tiny")).hasMessageMatching("Catalog 'not_exists_catalog' not found");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("USE tpch.not_exists_schema")).hasMessageMatching("Schema does not exist: tpch.not_exists_schema");
    }

    @Test
    public void testUseStatementAccessControlWithDeniedCatalog() {
        this.reset();
        this.getQueryRunner().getAccessControl().denyCatalogs(catalog -> !catalog.equals("tpch"));
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("USE tpch.tiny")).hasMessageMatching("Access Denied: Cannot access catalog tpch");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("USE tpch.not_exists_schema")).hasMessageMatching("Access Denied: Cannot access catalog tpch");
    }

    @Test
    public void testUseStatementAccessControlWithDeniedSchema() {
        this.reset();
        this.getQueryRunner().getAccessControl().denySchemas(schema -> !schema.equals("tiny"));
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute("USE tpch.tiny")).hasMessageMatching("Access Denied: Cannot access schema: tpch.tiny");
    }

    @Test
    public void testPropertiesAccessControl() {
        this.reset();
        this.systemAccessControl.set((SystemAccessControl)new DenySetPropertiesSystemAccessControl());
        this.assertAccessDenied("CREATE TABLE mock.default.new_table (pk bigint) WITH (double_table_property = 0.0)", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table (pk bigint) WITH (double_table_property = 1.0)", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table (pk bigint) WITH (double_table_property = 1.0, another_property = 1)", "Cannot access properties: \\[another_property, double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table (pk bigint) WITH (DOUBLE_TABLE_PROPERTY = 1.0)", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table WITH (double_table_property = 0.0) AS SELECT 1 pk", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table WITH (double_table_property = 1.0) AS SELECT 1 pk", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table WITH (double_table_property = 1.0, another_property = 1) AS SELECT 1 pk", "Cannot access properties: \\[another_property, double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE TABLE mock.default.new_table WITH (DOUBLE_TABLE_PROPERTY = 1.0) AS SELECT 1 pk", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE SCHEMA mock.new_schema WITH (boolean_schema_property = false)", "Cannot access properties: \\[boolean_schema_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE SCHEMA mock.new_schema WITH (boolean_schema_property = true)", "Cannot access properties: \\[boolean_schema_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE SCHEMA mock.new_schema WITH (another_property = 1, boolean_schema_property = true)", "Cannot access properties: \\[another_property, boolean_schema_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE SCHEMA mock.new_schema WITH (BOOLEAN_SCHEMA_PROPERTY = true)", "Cannot access properties: \\[boolean_schema_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE MATERIALIZED VIEW mock.default.new_materialized_view WITH (string_materialized_view_property = '') AS SELECT 1 a", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE MATERIALIZED VIEW mock.default.new_materialized_view WITH (string_materialized_view_property = 'value') AS SELECT 1 a", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE MATERIALIZED VIEW mock.default.new_materialized_view WITH (string_materialized_view_property = 'value', another_property = 1) AS SELECT 1 a", "Cannot access properties: \\[another_property, string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("CREATE MATERIALIZED VIEW mock.default.new_materialized_view WITH (STRING_MATERIALIZED_VIEW_PROPERTY = 'value') AS SELECT 1 a", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE mock.default.foo SET PROPERTIES double_table_property = 0.0", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE mock.default.foo SET PROPERTIES double_table_property = 1.0, another_property = 1", "Cannot access properties: \\[another_property, double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE mock.default.foo SET PROPERTIES double_table_property = 1.0", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE mock.default.foo SET PROPERTIES DOUBLE_TABLE_PROPERTY = 1.0", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE mock.default.foo SET PROPERTIES double_table_property = DEFAULT", "Cannot access properties: \\[double_table_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER MATERIALIZED VIEW mock.default.test_materialized_view SET PROPERTIES string_materialized_view_property = ''", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER MATERIALIZED VIEW mock.default.test_materialized_view SET PROPERTIES string_materialized_view_property = 'value'", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER MATERIALIZED VIEW mock.default.test_materialized_view SET PROPERTIES string_materialized_view_property = 'value', another_property = 1", "Cannot access properties: \\[another_property, string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER MATERIALIZED VIEW mock.default.test_materialized_view SET PROPERTIES STRING_MATERIALIZED_VIEW_PROPERTY = 'value'", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER MATERIALIZED VIEW mock.default.test_materialized_view SET PROPERTIES string_materialized_view_property = DEFAULT", "Cannot access properties: \\[string_materialized_view_property]", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testPropertiesAccessControlIsSkippedWhenUsingDefaults() {
        this.reset();
        this.systemAccessControl.set((SystemAccessControl)new DenySetPropertiesSystemAccessControl());
        this.systemAccessControl.set((SystemAccessControl)new DenySetPropertiesSystemAccessControl());
        this.assertAccessAllowed("CREATE TABLE mock.default.new_table (pk bigint)", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("CREATE SCHEMA mock.new_schema", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessAllowed("CREATE MATERIALIZED VIEW mock.default.new_materialized_view AS SELECT 1 a", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testAccessControlWithGroupsAndColumnMask() {
        this.reset();
        this.groupProvider.setUserGroups((Map)ImmutableMap.of((Object)this.getSession().getUser(), (Object)ImmutableSet.of((Object)"group")));
        TestingAccessControlManager accessControlManager = this.getQueryRunner().getAccessControl();
        accessControlManager.denyIdentityTable((identity, table) -> identity.getGroups().contains("group") && "orders".equals(table));
        accessControlManager.columnMask(new QualifiedObjectName("blackhole", DEFAULT_SCHEMA, "orders"), "comment", this.getSession().getUser(), ViewExpression.builder().expression("substr(comment,1,3)").build());
        this.assertAccessAllowed("SELECT comment FROM orders", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testAccessControlWithGroupsAndRowFilter() {
        this.reset();
        this.groupProvider.setUserGroups((Map)ImmutableMap.of((Object)this.getSession().getUser(), (Object)ImmutableSet.of((Object)"group")));
        TestingAccessControlManager accessControlManager = this.getQueryRunner().getAccessControl();
        accessControlManager.denyIdentityTable((identity, table) -> identity.getGroups().contains("group") && "nation".equals(table));
        accessControlManager.rowFilter(new QualifiedObjectName("blackhole", DEFAULT_SCHEMA, "nation"), this.getSession().getUser(), ViewExpression.builder().expression("nationkey % 2 = 0").build());
        this.assertAccessAllowed("SELECT nationkey FROM nation", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testAccessControlWithRolesAndColumnMask() {
        this.reset();
        String role = "role";
        String user = "user";
        Session session = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)user).withEnabledRoles((Set)ImmutableSet.of((Object)role)).build()).build();
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of(role), Set.of(new TrinoPrincipal(PrincipalType.USER, user)), false, Optional.empty());
        TestingAccessControlManager accessControlManager = this.getQueryRunner().getAccessControl();
        accessControlManager.denyIdentityTable((identity, table) -> identity.getEnabledRoles().contains(role) && "orders".equals(table));
        accessControlManager.columnMask(new QualifiedObjectName("blackhole", DEFAULT_SCHEMA, "orders"), "comment", this.getSession().getUser(), ViewExpression.builder().expression("substr(comment,1,3)").build());
        this.assertAccessAllowed(session, "SELECT comment FROM orders", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testAccessControlWithRolesAndRowFilter() {
        this.reset();
        String role = "role";
        String user = "user";
        Session session = Session.builder((Session)this.getSession()).setIdentity(Identity.forUser((String)user).withEnabledRoles((Set)ImmutableSet.of((Object)role)).build()).build();
        this.systemSecurityMetadata.grantRoles(this.getSession(), Set.of(role), Set.of(new TrinoPrincipal(PrincipalType.USER, user)), false, Optional.empty());
        TestingAccessControlManager accessControlManager = this.getQueryRunner().getAccessControl();
        accessControlManager.denyIdentityTable((identity, table) -> identity.getEnabledRoles().contains(role) && "nation".equals(table));
        accessControlManager.rowFilter(new QualifiedObjectName("blackhole", DEFAULT_SCHEMA, "nation"), this.getSession().getUser(), ViewExpression.builder().expression("nationkey % 2 = 0").build());
        this.assertAccessAllowed(session, "SELECT nationkey FROM nation", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    private static final class DenySetPropertiesSystemAccessControl
    extends AllowAllSystemAccessControl {
        private DenySetPropertiesSystemAccessControl() {
        }

        public void checkCanCreateSchema(SystemSecurityContext context, CatalogSchemaName schema, Map<String, Object> properties) {
            DenySetPropertiesSystemAccessControl.checkProperties(properties);
        }

        public void checkCanCreateTable(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Object> properties) {
            DenySetPropertiesSystemAccessControl.checkProperties(properties);
        }

        public void checkCanCreateMaterializedView(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Object> properties) {
            DenySetPropertiesSystemAccessControl.checkProperties(properties);
        }

        public void checkCanSetTableProperties(SystemSecurityContext context, CatalogSchemaTableName table, Map<String, Optional<Object>> properties) {
            DenySetPropertiesSystemAccessControl.checkProperties(properties);
        }

        public void checkCanSetMaterializedViewProperties(SystemSecurityContext context, CatalogSchemaTableName materializedView, Map<String, Optional<Object>> properties) {
            DenySetPropertiesSystemAccessControl.checkProperties(properties);
        }

        private static void checkProperties(Map<?, ?> properties) {
            if (!properties.isEmpty()) {
                List keys = properties.keySet().stream().map(Object::toString).sorted().collect(Collectors.toList());
                throw new AccessDeniedException("Cannot access properties: " + String.valueOf(keys));
            }
        }
    }
}

