/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.metadata.DisabledSystemSecurityMetadata;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestAccessControlTableRedirection
extends AbstractTestQueryFramework {
    private static final String CATALOG_NAME = "test_catalog";
    private static final String SCHEMA_NAME = "test_schema";
    private static final String REDIRECTION_SOURCE_TABLE_NAME = "redirection_source";
    private static final String REDIRECTION_TARGET_TABLE_NAME = "redirection_target";
    private static final SchemaTableName REDIRECTION_TARGET_SCHEMA_TABLE_NAME = new SchemaTableName("test_schema", "redirection_target");
    private static final String DATA_COLUMN_NAME = "data_column";
    private static final String ID_COLUMN_NAME = "id_column";
    private static final Map<String, Set<String>> SCHEMA_TABLE_MAPPING = ImmutableMap.of((Object)"test_schema", (Object)ImmutableSet.of((Object)"redirection_source", (Object)"redirection_target"));
    private static final Map<SchemaTableName, SchemaTableName> TABLE_REDIRECTIONS = ImmutableMap.of((Object)SchemaTableName.schemaTableName((String)"test_schema", (String)"redirection_source"), (Object)SchemaTableName.schemaTableName((String)"test_schema", (String)"redirection_target"));

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog(CATALOG_NAME).setSchema(SCHEMA_NAME).build();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)session).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, SystemSecurityMetadata.class).setBinding().toInstance((Object)new DisabledSystemSecurityMetadata(this){

            public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            }

            public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
            }

            public boolean roleExists(Session session, String role) {
                return true;
            }

            public void setEntityOwner(Session session, EntityKindAndName entityKindAndName, TrinoPrincipal principal) {
            }

            public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
            }
        })).build();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)TestAccessControlTableRedirection.createMockConnectorFactory()));
        queryRunner.createCatalog(CATALOG_NAME, "mock", (Map)ImmutableMap.of());
        return queryRunner;
    }

    @Test
    public void testSelect() {
        this.assertAccessAllowed("SELECT * FROM redirection_source", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("SELECT * FROM redirection_source", "Cannot select from columns \\[data_column, id_column] in table or view test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)"redirection_target.data_column", (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.SELECT_COLUMN)});
    }

    @Test
    public void testDropTable() {
        this.assertAccessAllowed("DROP TABLE redirection_source", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("DROP TABLE redirection_source", "Cannot drop table test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_TABLE)});
    }

    @Test
    public void testCommentTable() {
        this.assertAccessAllowed("COMMENT ON TABLE redirection_source IS 'This is my redirection target table'", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("COMMENT ON TABLE redirection_source IS 'This is my redirection target table'", "Cannot comment table to test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.COMMENT_TABLE)});
    }

    @Test
    public void testCommentColumn() {
        this.assertAccessAllowed("COMMENT ON COLUMN redirection_source.data_column IS 'Data is the new oil'", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("COMMENT ON COLUMN redirection_source.data_column IS 'Data is the new oil'", "Cannot comment column to test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.COMMENT_COLUMN)});
    }

    @Test
    public void testShowGrants() {
        this.assertAccessAllowed("SHOW GRANTS ON redirection_target", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQueryFails("SHOW GRANTS ON redirection_source", ".* Table redirection_source is redirected to test_catalog.test_schema.redirection_target and SHOW GRANTS is not supported with table redirections");
    }

    @Test
    public void testGrant() {
        this.assertAccessAllowed("GRANT SELECT ON redirection_target TO ROLE PUBLIC", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQueryFails("GRANT SELECT ON redirection_source TO ROLE PUBLIC", ".* Table test_catalog.test_schema.redirection_source is redirected to test_catalog.test_schema.redirection_target and GRANT is not supported with table redirections");
    }

    @Test
    public void testRevoke() {
        this.assertAccessAllowed("REVOKE SELECT ON redirection_target FROM ROLE PUBLIC", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQueryFails("REVOKE SELECT ON redirection_source FROM ROLE PUBLIC", ".* Table test_catalog.test_schema.redirection_source is redirected to test_catalog.test_schema.redirection_target and REVOKE is not supported with table redirections");
    }

    @Test
    public void testSetTableAuthorization() {
        this.assertAccessAllowed("ALTER TABLE redirection_target SET AUTHORIZATION ROLE PUBLIC", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQueryFails("ALTER TABLE redirection_source SET AUTHORIZATION ROLE PUBLIC", ".* Table test_catalog.test_schema.redirection_source is redirected to test_catalog.test_schema.redirection_target and SET TABLE AUTHORIZATION is not supported with table redirections");
    }

    @Test
    public void testDeny() {
        this.assertAccessAllowed("DENY DELETE ON redirection_target TO ROLE PUBLIC", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQueryFails("DENY DELETE ON redirection_source TO ROLE PUBLIC", ".* Table test_catalog.test_schema.redirection_source is redirected to test_catalog.test_schema.redirection_target and DENY is not supported with table redirections");
    }

    @Test
    public void testAddColumn() {
        this.assertAccessAllowed("ALTER TABLE redirection_source ADD COLUMN a_new_column integer", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE redirection_source ADD COLUMN a_new_column integer", "Cannot add a column to table test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.ADD_COLUMN)});
    }

    @Test
    public void testDropColumn() {
        this.assertAccessAllowed("ALTER TABLE redirection_source DROP COLUMN data_column", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE redirection_source DROP COLUMN data_column", "Cannot drop a column from table test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.DROP_COLUMN)});
    }

    @Test
    public void testRenameColumn() {
        this.assertAccessAllowed("ALTER TABLE redirection_source RENAME COLUMN data_column TO new_oil_column", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE redirection_source RENAME COLUMN data_column TO new_oil_column", "Cannot rename a column in table test_catalog.test_schema.redirection_target", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_COLUMN)});
    }

    @Test
    public void testRenameTable() {
        this.assertAccessAllowed("ALTER TABLE redirection_source RENAME TO renamed_table", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertAccessDenied("ALTER TABLE redirection_source RENAME TO renamed_table", "Cannot rename table from test_catalog.test_schema.redirection_target to test_catalog.test_schema.renamed_table", new TestingAccessControlManager.TestingPrivilege[]{TestingAccessControlManager.privilege((String)REDIRECTION_TARGET_TABLE_NAME, (TestingAccessControlManager.TestingPrivilegeType)TestingAccessControlManager.TestingPrivilegeType.RENAME_TABLE)});
    }

    private static MockConnectorFactory createMockConnectorFactory() {
        return MockConnectorFactory.builder().withListTables((session, schemaName) -> (List)SCHEMA_TABLE_MAPPING.getOrDefault(schemaName, (Set<String>)ImmutableSet.of()).stream().collect(ImmutableList.toImmutableList())).withGetTableHandle((session, tableName) -> {
            if (SCHEMA_TABLE_MAPPING.getOrDefault(tableName.getSchemaName(), (Set<String>)ImmutableSet.of()).contains(tableName.getTableName()) && !TABLE_REDIRECTIONS.containsKey(tableName)) {
                return new MockConnectorTableHandle(tableName);
            }
            return null;
        }).withGetViews((connectorSession, prefix) -> ImmutableMap.of()).withRedirectTable((connectorSession, schemaTableName) -> Optional.ofNullable(TABLE_REDIRECTIONS.get(schemaTableName)).map(target -> new CatalogSchemaTableName(CATALOG_NAME, target))).withGetColumns(schemaTableName -> {
            if (REDIRECTION_TARGET_SCHEMA_TABLE_NAME.equals(schemaTableName)) {
                return ImmutableList.of((Object)new ColumnMetadata(ID_COLUMN_NAME, (Type)IntegerType.INTEGER), (Object)new ColumnMetadata(DATA_COLUMN_NAME, (Type)VarcharType.VARCHAR));
            }
            throw new RuntimeException("Columns do not exist for: " + String.valueOf(schemaTableName));
        }).build();
    }
}

