/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.TestingTableFunctions;
import io.trino.plugin.blackhole.BlackHolePlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.Signature;
import io.trino.spi.security.Identity;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.sql.SqlPath;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingAccessControlManager;
import io.trino.testing.TestingSession;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.junit.jupiter.api.Test;

public class TestFunctionsInViewsWithFileBasedSystemAccessControl
extends AbstractTestQueryFramework {
    public static final Session ALICE_USER = TestFunctionsInViewsWithFileBasedSystemAccessControl.user("alice");
    public static final Session BOB_USER = TestFunctionsInViewsWithFileBasedSystemAccessControl.user("bob");
    public static final Session CHARLIE_USER = TestFunctionsInViewsWithFileBasedSystemAccessControl.user("charlie");

    protected QueryRunner createQueryRunner() throws Exception {
        String securityConfigFile = new File(Resources.getResource((String)"file-based-system-functions-access.json").toURI()).getPath();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog(Optional.empty()).setSchema(Optional.empty()).setPath(SqlPath.buildPath((String)"mock.function", Optional.empty())).build()).setWorkerCount(0).setSystemAccessControl("file", Map.of("security.config-file", securityConfigFile)).build();
        queryRunner.installPlugin((Plugin)new BlackHolePlugin());
        queryRunner.createCatalog("blackhole", "blackhole");
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withTableFunctions((Iterable)ImmutableSet.of((Object)new TestingTableFunctions.SimpleTableFunction())).withApplyTableFunction((session, handle) -> {
            if (handle instanceof TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle) {
                TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle functionHandle = (TestingTableFunctions.SimpleTableFunction.SimpleTableFunctionHandle)handle;
                return Optional.of(new TableFunctionApplicationResult((Object)functionHandle.getTableHandle(), (List)functionHandle.getTableHandle().getColumns().orElseThrow()));
            }
            throw new IllegalStateException("Unsupported table function handle: " + handle.getClass().getSimpleName());
        }).withFunctions((Collection)ImmutableList.builder().add((Object)FunctionMetadata.scalarBuilder((String)"my_function").signature(Signature.builder().returnType((Type)BigintType.BIGINT).build()).noDescription().build()).build()).withFunctionProvider(Optional.of(new FunctionProvider(this){

            public ScalarFunctionImplementation getScalarFunctionImplementation(FunctionId functionId, BoundSignature boundSignature, FunctionDependencies functionDependencies, InvocationConvention invocationConvention) {
                return ScalarFunctionImplementation.builder().methodHandle(MethodHandles.constant(Long.TYPE, 42L)).build();
            }
        })).build()));
        queryRunner.createCatalog("mock", "mock");
        return queryRunner;
    }

    @Test
    public void testPtfSecurityDefinerViewCreatedByAlice() {
        this.assertQuerySucceeds(ALICE_USER, "CREATE VIEW blackhole.default.view_ptf_alice_security_definer SECURITY DEFINER AS SELECT * FROM TABLE(mock.system.simple_table_function())");
        String securityDefinerQuery = "SELECT * FROM blackhole.default.view_ptf_alice_security_definer";
        this.assertQuerySucceeds(ALICE_USER, securityDefinerQuery);
        this.assertQuerySucceeds(BOB_USER, securityDefinerQuery);
        this.assertQuerySucceeds(CHARLIE_USER, securityDefinerQuery);
    }

    @Test
    public void testPtfSecurityInvokerViewCreatedByAlice() {
        this.assertQuerySucceeds(ALICE_USER, "CREATE VIEW blackhole.default.view_ptf_alice_security_invoker SECURITY INVOKER AS SELECT * FROM TABLE(mock.system.simple_table_function())");
        String securityInvokerQuery = "SELECT * FROM blackhole.default.view_ptf_alice_security_invoker";
        this.assertQuerySucceeds(ALICE_USER, securityInvokerQuery);
        this.assertQuerySucceeds(BOB_USER, securityInvokerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityInvokerQuery, "Cannot execute function mock.system.simple_table_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testFunctionSecurityDefinerViewCreatedByAlice() {
        this.assertQuerySucceeds(ALICE_USER, "CREATE VIEW blackhole.default.view_function_alice_security_definer SECURITY DEFINER AS SELECT my_function() AS t");
        String securityDefinerQuery = "SELECT * FROM blackhole.default.view_function_alice_security_definer";
        this.assertQuerySucceeds(ALICE_USER, securityDefinerQuery);
        this.assertQuerySucceeds(BOB_USER, securityDefinerQuery);
        this.assertQuerySucceeds(CHARLIE_USER, securityDefinerQuery);
    }

    @Test
    public void testFunctionSecurityInvokerViewCreatedByAlice() {
        this.assertQuerySucceeds(ALICE_USER, "CREATE VIEW blackhole.default.view_function_alice_security_invoker SECURITY INVOKER AS SELECT my_function() AS t");
        String securityInvokerQuery = "SELECT * FROM blackhole.default.view_function_alice_security_invoker";
        this.assertQuerySucceeds(ALICE_USER, securityInvokerQuery);
        this.assertQuerySucceeds(BOB_USER, securityInvokerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityInvokerQuery, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testPtfSecurityDefinerViewCreatedByBob() {
        this.assertQuerySucceeds(BOB_USER, "CREATE VIEW blackhole.default.view_ptf_bob_security_definer SECURITY DEFINER AS SELECT * FROM TABLE(mock.system.simple_table_function())");
        String securityDefinerQuery = "SELECT * FROM blackhole.default.view_ptf_bob_security_definer";
        this.assertAccessDenied(ALICE_USER, securityDefinerQuery, "Cannot execute function mock.system.simple_table_function", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQuerySucceeds(BOB_USER, securityDefinerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityDefinerQuery, "Cannot execute function mock.system.simple_table_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testPtfSecurityInvokerViewCreatedByBob() {
        this.assertQuerySucceeds(BOB_USER, "CREATE VIEW blackhole.default.view_ptf_bob_security_invoker SECURITY INVOKER AS SELECT * FROM TABLE(mock.system.simple_table_function())");
        String securityInvokerQuery = "SELECT * FROM blackhole.default.view_ptf_bob_security_invoker";
        this.assertQuerySucceeds(ALICE_USER, securityInvokerQuery);
        this.assertQuerySucceeds(BOB_USER, securityInvokerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityInvokerQuery, "Cannot execute function mock.system.simple_table_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testFunctionSecurityDefinerViewCreatedByBob() {
        this.assertQuerySucceeds(BOB_USER, "CREATE VIEW blackhole.default.view_function_bob_security_definer SECURITY DEFINER AS SELECT my_function() AS t");
        String securityDefinerQuery = "SELECT * FROM blackhole.default.view_function_bob_security_definer";
        this.assertAccessDenied(ALICE_USER, securityDefinerQuery, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[0]);
        this.assertQuerySucceeds(BOB_USER, securityDefinerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityDefinerQuery, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    @Test
    public void testFunctionSecurityInvokerViewCreatedByBob() {
        this.assertQuerySucceeds(BOB_USER, "CREATE VIEW blackhole.default.view_function_bob_security_invoker SECURITY INVOKER AS SELECT my_function() AS t");
        String securityInvokerQuery = "SELECT * FROM blackhole.default.view_function_bob_security_invoker";
        this.assertQuerySucceeds(ALICE_USER, securityInvokerQuery);
        this.assertQuerySucceeds(BOB_USER, securityInvokerQuery);
        this.assertAccessDenied(CHARLIE_USER, securityInvokerQuery, "Cannot execute function my_function", new TestingAccessControlManager.TestingPrivilege[0]);
    }

    private static Session user(String user) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.ofUser((String)user)).setPath(SqlPath.buildPath((String)"mock.function", Optional.empty())).build();
    }
}

