/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Binder;
import com.google.inject.multibindings.OptionalBinder;
import io.trino.Session;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.security.TestingSystemSecurityMetadata;
import io.trino.spi.security.Identity;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestSystemSecurityMetadata
extends AbstractTestQueryFramework {
    private final TestingSystemSecurityMetadata securityMetadata = new TestingSystemSecurityMetadata();

    private void reset() {
        this.securityMetadata.reset();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        Session session = TestingSession.testSessionBuilder().setCatalog("blackhole").setSchema("default").build();
        return DistributedQueryRunner.builder((Session)session).setAdditionalModule(binder -> OptionalBinder.newOptionalBinder((Binder)binder, SystemSecurityMetadata.class).setBinding().toInstance((Object)this.securityMetadata)).setWorkerCount(0).build();
    }

    @Test
    public void testNoSystemRoles() {
        this.reset();
        this.assertQueryReturnsEmptyResult("SHOW ROLES");
        this.assertQueryReturnsEmptyResult("SHOW CURRENT ROLES");
        this.assertQueryReturnsEmptyResult("SHOW ROLE GRANTS");
        this.assertQueryReturnsEmptyResult("SELECT * FROM system.information_schema.applicable_roles");
    }

    @Test
    public void testRoleCreationAndDeletion() {
        this.reset();
        this.assertQueryReturnsEmptyResult("SHOW ROLES");
        this.assertQuerySucceeds("CREATE ROLE role1");
        this.assertQuery("SHOW ROLES", "VALUES 'role1'");
        this.assertQuerySucceeds("DROP ROLE role1");
        this.assertQueryReturnsEmptyResult("SHOW ROLES");
    }

    @Test
    public void testRoleGrant() {
        this.reset();
        Session alice = TestSystemSecurityMetadata.user("alice", new String[0]);
        Session aliceWithRole = TestSystemSecurityMetadata.user("alice", "role1");
        this.assertQuerySucceeds("CREATE ROLE role1");
        this.assertQueryFails(alice, "SET ROLE role1", "Access Denied: Cannot set role role1");
        this.assertQuery(alice, "SHOW ROLES", "VALUES 'role1'");
        this.assertQueryReturnsEmptyResult(alice, "SHOW CURRENT ROLES");
        this.assertQueryReturnsEmptyResult(alice, "SHOW ROLE GRANTS");
        this.assertQueryReturnsEmptyResult(alice, "SELECT * FROM system.information_schema.applicable_roles");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLES")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW CURRENT ROLES")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLE GRANTS")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SELECT * FROM system.information_schema.applicable_roles")).hasMessageContaining("Access Denied: Cannot set role role1");
        this.assertQuerySucceeds("GRANT role1 TO USER alice");
        this.assertQuerySucceeds(alice, "SET ROLE role1");
        this.assertQuery(alice, "SHOW ROLES", "VALUES 'role1'");
        this.assertQuery(alice, "SHOW CURRENT ROLES", "VALUES 'role1'");
        this.assertQuery(alice, "SHOW ROLE GRANTS", "VALUES 'role1'");
        this.assertQuery(alice, "SELECT * FROM system.information_schema.applicable_roles", "SELECT 'alice', 'USER', 'role1', 'NO'");
        this.assertQuery(aliceWithRole, "SHOW ROLES", "VALUES 'role1'");
        this.assertQuery(aliceWithRole, "SHOW CURRENT ROLES", "VALUES 'role1'");
        this.assertQuery(aliceWithRole, "SHOW ROLE GRANTS", "VALUES 'role1'");
        this.assertQuery(aliceWithRole, "SELECT * FROM system.information_schema.applicable_roles", "SELECT 'alice', 'USER', 'role1', 'NO'");
        this.assertQuerySucceeds("REVOKE role1 FROM USER alice");
        this.assertQuery(alice, "SHOW ROLES", "VALUES 'role1'");
        this.assertQueryReturnsEmptyResult(alice, "SHOW CURRENT ROLES");
        this.assertQueryReturnsEmptyResult(alice, "SHOW ROLE GRANTS");
        this.assertQueryReturnsEmptyResult(alice, "SELECT * FROM system.information_schema.applicable_roles");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLES")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW CURRENT ROLES")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLE GRANTS")).hasMessageContaining("Access Denied: Cannot set role role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SELECT * FROM system.information_schema.applicable_roles")).hasMessageContaining("Access Denied: Cannot set role role1");
        this.assertQuerySucceeds("DROP ROLE role1");
    }

    @Test
    public void testTransitiveRoleGrant() {
        this.reset();
        Session alice = TestSystemSecurityMetadata.user("alice", new String[0]);
        Session aliceWithRole = TestSystemSecurityMetadata.user("alice", "role2");
        this.assertQuerySucceeds("CREATE ROLE role1");
        this.assertQuerySucceeds("CREATE ROLE role2");
        this.assertQuerySucceeds("GRANT role1 TO USER alice");
        String roleNotApplicableErrorMessage = "Access Denied: Cannot set role role2";
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLES")).hasMessageContaining(roleNotApplicableErrorMessage);
        this.assertQuerySucceeds("GRANT role2 TO ROLE role1");
        this.assertQuery(alice, "SHOW ROLES", "VALUES 'role1', 'role2'");
        this.assertQuery(alice, "SHOW CURRENT ROLES", "VALUES 'role1', 'role2'");
        this.assertQuery(alice, "SHOW ROLE GRANTS", "VALUES 'role1'");
        this.assertQuery(aliceWithRole, "SELECT * FROM system.information_schema.applicable_roles", "VALUES ('alice', 'USER', 'role1', 'NO'),('role1', 'ROLE', 'role2', 'NO')");
        this.assertQuerySucceeds("REVOKE role2 FROM ROLE role1");
        Assertions.assertThatThrownBy(() -> this.getQueryRunner().execute(aliceWithRole, "SHOW ROLES")).hasMessageContaining(roleNotApplicableErrorMessage);
        this.assertQuerySucceeds("REVOKE role1 FROM USER alice");
        this.assertQuerySucceeds("DROP ROLE role1");
    }

    private static Session user(String alice, String ... roles) {
        return TestingSession.testSessionBuilder().setIdentity(Identity.forUser((String)alice).withEnabledRoles((Set)ImmutableSet.copyOf((Object[])roles)).build()).build();
    }
}

