/*
 * Decompiled with CFR 0.152.
 */
package io.trino.security;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.SystemSecurityMetadata;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.EntityKindAndName;
import io.trino.spi.function.CatalogSchemaFunctionName;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class TestingSystemSecurityMetadata
implements SystemSecurityMetadata {
    private final Set<String> roles = Collections.synchronizedSet(new HashSet());
    private final Set<RoleGrant> roleGrants = Collections.synchronizedSet(new HashSet());
    private final Map<CatalogSchemaTableName, Identity> viewOwners = Collections.synchronizedMap(new HashMap());
    private final Map<CatalogSchemaFunctionName, Identity> functionOwners = Collections.synchronizedMap(new HashMap());

    TestingSystemSecurityMetadata() {
    }

    public void reset() {
        this.roles.clear();
        this.roleGrants.clear();
        this.viewOwners.clear();
        this.functionOwners.clear();
    }

    public String getFunctionOwner(CatalogSchemaFunctionName functionName) {
        return this.functionOwners.get(functionName).getUser();
    }

    public boolean roleExists(Session session, String role) {
        return this.roles.contains(role);
    }

    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor) {
        Preconditions.checkArgument((boolean)grantor.isEmpty(), (Object)"Grantor is not yet supported");
        this.roles.add(role);
    }

    public void dropRole(Session session, String role) {
        this.roles.remove(role);
    }

    public Set<String> listRoles(Session session) {
        return ImmutableSet.copyOf(this.roles);
    }

    public Set<RoleGrant> listRoleGrants(Session session, TrinoPrincipal principal) {
        return this.getRoleGrants(principal);
    }

    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.roleGrants.addAll(TestingSystemSecurityMetadata.createRoleGrants(roles, grantees, adminOption, grantor));
    }

    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        this.roleGrants.removeAll(TestingSystemSecurityMetadata.createRoleGrants(roles, grantees, adminOption, grantor));
    }

    private static Set<RoleGrant> createRoleGrants(Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor) {
        Preconditions.checkArgument((boolean)grantor.isEmpty(), (Object)"Grantor is not yet supported");
        HashSet<RoleGrant> roleGrantToAdd = new HashSet<RoleGrant>();
        for (String role : roles) {
            for (TrinoPrincipal grantee : grantees) {
                roleGrantToAdd.add(new RoleGrant(grantee, role, adminOption));
            }
        }
        return roleGrantToAdd;
    }

    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal) {
        return this.getRoleGrantsRecursively(principal);
    }

    public Set<String> listEnabledRoles(Identity identity) {
        Set allUserRoles = (Set)this.getRoleGrantsRecursively(new TrinoPrincipal(PrincipalType.USER, identity.getUser())).stream().map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet());
        if (identity.getEnabledRoles().isEmpty()) {
            return allUserRoles;
        }
        Set enabledRoles = (Set)identity.getEnabledRoles().stream().filter(allUserRoles::contains).collect(ImmutableSet.toImmutableSet());
        Set transitiveRoles = (Set)enabledRoles.stream().flatMap(role -> this.getRoleGrantsRecursively(new TrinoPrincipal(PrincipalType.ROLE, role)).stream()).map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet());
        return ImmutableSet.builder().addAll((Iterable)enabledRoles).addAll((Iterable)transitiveRoles).build();
    }

    private Set<RoleGrant> getRoleGrantsRecursively(TrinoPrincipal principal) {
        ArrayDeque<RoleGrant> pending = new ArrayDeque<RoleGrant>(this.getRoleGrants(principal));
        HashSet<RoleGrant> seen = new HashSet<RoleGrant>();
        while (!pending.isEmpty()) {
            RoleGrant current = (RoleGrant)pending.remove();
            if (!seen.add(current)) continue;
            pending.addAll(this.getRoleGrants(new TrinoPrincipal(PrincipalType.ROLE, current.getRoleName())));
        }
        return ImmutableSet.copyOf(seen);
    }

    private Set<RoleGrant> getRoleGrants(TrinoPrincipal principal) {
        return (Set)this.roleGrants.stream().filter(roleGrant -> roleGrant.getGrantee().equals((Object)principal)).collect(ImmutableSet.toImmutableSet());
    }

    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        throw new UnsupportedOperationException();
    }

    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        throw new UnsupportedOperationException();
    }

    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        throw new UnsupportedOperationException();
    }

    public Set<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        throw new UnsupportedOperationException();
    }

    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schema) {
        return Optional.empty();
    }

    public Optional<Identity> getViewRunAsIdentity(Session session, CatalogSchemaTableName viewName) {
        return Optional.ofNullable(this.viewOwners.get(viewName)).map(identity -> Identity.from((Identity)identity).withEnabledRoles((Set)this.getRoleGrantsRecursively(new TrinoPrincipal(PrincipalType.USER, identity.getUser())).stream().map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet())).build());
    }

    public Optional<Identity> getFunctionRunAsIdentity(Session session, CatalogSchemaFunctionName functionName) {
        return Optional.ofNullable(this.functionOwners.get(functionName)).map(identity -> Identity.from((Identity)identity).withEnabledRoles((Set)this.getRoleGrantsRecursively(new TrinoPrincipal(PrincipalType.USER, identity.getUser())).stream().map(RoleGrant::getRoleName).collect(ImmutableSet.toImmutableSet())).build());
    }

    public void functionCreated(Session session, CatalogSchemaFunctionName function) {
        this.functionOwners.put(function, session.getIdentity());
    }

    public void functionDropped(Session session, CatalogSchemaFunctionName function) {
        this.functionOwners.remove(function);
    }

    public void schemaCreated(Session session, CatalogSchemaName schema) {
    }

    public void schemaRenamed(Session session, CatalogSchemaName sourceSchema, CatalogSchemaName targetSchema) {
    }

    public void schemaDropped(Session session, CatalogSchemaName schema) {
    }

    public void tableCreated(Session session, CatalogSchemaTableName table) {
    }

    public void tableRenamed(Session session, CatalogSchemaTableName sourceTable, CatalogSchemaTableName targetTable) {
    }

    public void tableDropped(Session session, CatalogSchemaTableName table) {
    }

    public void columnCreated(Session session, CatalogSchemaTableName table, String column) {
    }

    public void columnRenamed(Session session, CatalogSchemaTableName table, String oldName, String newName) {
    }

    public void columnDropped(Session session, CatalogSchemaTableName table, String column) {
    }

    public void columnTypeChanged(Session session, CatalogSchemaTableName table, String column, String oldType, String newType) {
    }

    public void columnNotNullConstraintDropped(Session session, CatalogSchemaTableName table, String column) {
    }

    public void setEntityOwner(Session session, EntityKindAndName entityKindAndName, TrinoPrincipal principal) {
        List name = entityKindAndName.name();
        if (!entityKindAndName.entityKind().equals("VIEW")) {
            throw new UnsupportedOperationException();
        }
        Preconditions.checkArgument((principal.getType() == PrincipalType.USER ? 1 : 0) != 0, (Object)"Only a user can be a view owner");
        this.viewOwners.put(new CatalogSchemaTableName((String)name.get(0), (String)name.get(1), (String)name.get(2)), Identity.ofUser((String)principal.getName()));
    }
}

