/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.protocol;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.client.ClientSession;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.plugin.memory.MemoryQueryRunner;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spooling.filesystem.FileSystemSpoolingPlugin;
import io.trino.testing.AbstractTestEngineOnlyQueries;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingStatementClientFactory;
import io.trino.testing.TestingTrinoClient;
import io.trino.tpch.TpchTable;
import io.trino.util.Ciphers;
import java.util.Base64;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.OkHttpClient;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.localstack.LocalStackContainer;
import org.testcontainers.utility.DockerImageName;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;

public abstract class AbstractSpooledQueryDataDistributedQueries
extends AbstractTestEngineOnlyQueries {
    private LocalStackContainer localstack;
    private final String testBucket = "segments" + String.valueOf(UUID.randomUUID());

    protected abstract String encoding();

    protected Map<String, String> spoolingFileSystemConfig() {
        return Map.of();
    }

    protected Map<String, String> spoolingConfig() {
        return Map.of();
    }

    protected QueryRunner createQueryRunner() throws Exception {
        this.localstack = (LocalStackContainer)this.closeAfterClass((AutoCloseable)new LocalStackContainer(DockerImageName.parse((String)"localstack/localstack:s3-latest")));
        this.localstack.start();
        try (S3Client client = this.createS3Client(this.localstack);){
            client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(this.testBucket).build());
        }
        DistributedQueryRunner queryRunner = ((MemoryQueryRunner.Builder)((MemoryQueryRunner.Builder)((MemoryQueryRunner.Builder)((MemoryQueryRunner.Builder)((MemoryQueryRunner.Builder)MemoryQueryRunner.builder().setInitialTables((Iterable)TpchTable.getTables()).setTestingTrinoClientFactory((trinoServer, session) -> AbstractSpooledQueryDataDistributedQueries.createClient(trinoServer, session, this.encoding()))).addExtraProperty("protocol.spooling.enabled", "true")).addExtraProperty("protocol.spooling.shared-secret-key", AbstractSpooledQueryDataDistributedQueries.randomAES256Key())).addExtraProperties(this.spoolingConfig())).setAdditionalSetup(runner -> {
            runner.installPlugin((Plugin)new FileSystemSpoolingPlugin());
            ImmutableMap spoolingConfig = ImmutableMap.builder().put((Object)"fs.s3.enabled", (Object)"true").put((Object)"fs.location", (Object)("s3://" + this.testBucket + "/")).put((Object)"fs.segment.encryption", (Object)"true").put((Object)"fs.segment.pruning.enabled", (Object)"false").put((Object)"s3.endpoint", (Object)this.localstack.getEndpointOverride(LocalStackContainer.Service.S3).toString()).put((Object)"s3.region", (Object)this.localstack.getRegion()).put((Object)"s3.aws-access-key", (Object)this.localstack.getAccessKey()).put((Object)"s3.aws-secret-key", (Object)this.localstack.getSecretKey()).putAll(this.spoolingFileSystemConfig()).buildKeepingLast();
            runner.loadSpoolingManager("filesystem", (Map)spoolingConfig);
        })).build();
        queryRunner.getCoordinator().getSessionPropertyManager().addSystemSessionProperties(TEST_SYSTEM_PROPERTIES);
        try {
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withSessionProperties((Iterable)TEST_CATALOG_PROPERTIES).build()));
            queryRunner.createCatalog("testing_catalog", "mock");
        }
        catch (RuntimeException e) {
            throw (RuntimeException)Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
        }
        return queryRunner;
    }

    @Test
    public void testSpoolingDisabledForNonSelectQueries() {
        Assertions.assertThat((Optional)this.computeActual("SELECT * FROM nation").getQueryDataEncoding()).hasValue((Object)this.encoding());
        Assertions.assertThat((Optional)this.computeActual("EXPLAIN SELECT * FROM nation").getQueryDataEncoding()).isEmpty();
        Assertions.assertThat((Optional)this.computeActual("CREATE TABLE spooling_test (col INT)").getQueryDataEncoding()).isEmpty();
        Assertions.assertThat((Optional)this.computeActual("INSERT INTO spooling_test (col) VALUES (2137)").getQueryDataEncoding()).isEmpty();
        Assertions.assertThat((Optional)this.computeActual("SHOW SESSION").getQueryDataEncoding()).isEmpty();
        Assertions.assertThat((Optional)this.computeActual("DROP TABLE spooling_test").getQueryDataEncoding()).isEmpty();
    }

    private static TestingTrinoClient createClient(TestingTrinoServer testingTrinoServer, Session session, final String encoding) {
        return new TestingTrinoClient(testingTrinoServer, new TestingStatementClientFactory(){

            public StatementClient create(OkHttpClient httpClient, Session session, ClientSession clientSession, String query) {
                ClientSession clientSessionSpooled = ClientSession.builder((ClientSession)clientSession).encoding(Optional.ofNullable(encoding)).build();
                return StatementClientFactory.newStatementClient((OkHttpClient)httpClient, (ClientSession)clientSessionSpooled, (String)query, Optional.empty());
            }
        }, session, new OkHttpClient());
    }

    private static String randomAES256Key() {
        return Base64.getEncoder().encodeToString(Ciphers.createRandomAesEncryptionKey().getEncoded());
    }

    protected S3Client createS3Client(LocalStackContainer localstack) {
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().endpointOverride(localstack.getEndpointOverride(LocalStackContainer.Service.S3))).region(Region.of((String)localstack.getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)localstack.getAccessKey(), (String)localstack.getSecretKey())))).build();
    }
}

