/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.errorprone.annotations.FormatMethod;
import io.airlift.log.Logger;
import io.trino.Session;
import io.trino.execution.querystats.PlanOptimizersStatsCollector;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Catalog;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.sql.DynamicFilters;
import io.trino.sql.ir.Expression;
import io.trino.sql.ir.Reference;
import io.trino.sql.planner.IcebergCostBasedPlanTestSetup;
import io.trino.sql.planner.LogicalPlanner;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.Plan;
import io.trino.sql.planner.SimplePlanVisitor;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.JoinType;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanVisitor;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.TableScanNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.testing.PlanTester;
import io.trino.testing.TestingSession;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class BaseCostBasedPlanTest
extends BasePlanTest {
    private static final Logger log = Logger.get(BaseCostBasedPlanTest.class);
    private static final String CATALOG_NAME = "local";
    protected static final List<String> TPCH_SQL_FILES = (List)IntStream.rangeClosed(1, 22).mapToObj(i -> String.format("q%02d", i)).map(queryId -> String.format("/sql/trino/tpch/%s.sql", queryId)).collect(ImmutableList.toImmutableList());
    protected static final List<String> TPCDS_SQL_FILES = (List)IntStream.range(1, 100).mapToObj(i -> String.format("q%02d", i)).map(queryId -> String.format("/sql/trino/tpcds/%s.sql", queryId)).collect(ImmutableList.toImmutableList());
    private final String schemaName;
    private final boolean partitioned;
    private final IcebergCostBasedPlanTestSetup planTestSetup;

    public BaseCostBasedPlanTest(String schemaName, boolean partitioned) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.partitioned = partitioned;
        this.planTestSetup = new IcebergCostBasedPlanTestSetup();
    }

    protected PlanTester createPlanTester() {
        Session.SessionBuilder sessionBuilder = TestingSession.testSessionBuilder().setCatalog(CATALOG_NAME).setSchema(this.schemaName).setSystemProperty("filter_conjunction_independence_factor", "0.750000001").setSystemProperty("task_concurrency", "1").setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.AUTOMATIC.name()).setSystemProperty("join_distribution_type", OptimizerConfig.JoinDistributionType.AUTOMATIC.name()).setSystemProperty("ignore_stats_calculator_failures", "false");
        PlanTester planTester = PlanTester.create((Session)sessionBuilder.build(), (int)8);
        planTester.createCatalog(CATALOG_NAME, this.planTestSetup.createConnectorFactory(), (Map)ImmutableMap.of());
        return planTester;
    }

    @BeforeAll
    public void prepareTables() {
        this.planTestSetup.createDatabase(this.schemaName);
        this.planTestSetup.populateTablesFromResource(this.getTableNames(), this.schemaName, this.getTableResourceDirectory(), this.getTableTargetDirectory());
    }

    @AfterAll
    public void cleanUp() throws Exception {
        this.planTestSetup.cleanUp();
    }

    protected abstract List<String> getTableNames();

    protected abstract String getTableResourceDirectory();

    protected abstract String getTableTargetDirectory();

    protected abstract List<String> getQueryResourcePaths();

    @ParameterizedTest
    @MethodSource(value={"getQueryResourcePaths"})
    public void test(String queryResourcePath) {
        Assertions.assertThat((String)this.generateQueryPlan(BaseCostBasedPlanTest.readQuery(queryResourcePath))).isEqualTo(BaseCostBasedPlanTest.read(this.getQueryPlanResourcePath(queryResourcePath)));
    }

    private String getQueryPlanResourcePath(String queryResourcePath) {
        Path queryPath = Paths.get(queryResourcePath, new String[0]);
        String connectorName = ((Catalog)this.getPlanTester().getCatalogManager().getCatalog(new CatalogName(CATALOG_NAME)).orElseThrow()).getConnectorName().toString();
        Path directory = queryPath.getParent();
        directory = directory.resolve(connectorName);
        directory = directory.resolve(this.partitioned ? "partitioned" : "unpartitioned");
        String planResourceName = queryPath.getFileName().toString().replaceAll("\\.sql$", ".plan.txt");
        return directory.resolve(planResourceName).toString();
    }

    protected void generate() {
        this.initPlanTest();
        try {
            this.prepareTables();
            ((Stream)this.getQueryResourcePaths().stream().parallel()).forEach(queryResourcePath -> {
                try {
                    Path queryPlanWritePath = Paths.get(this.getSourcePath().toString(), "src/test/resources", this.getQueryPlanResourcePath((String)queryResourcePath));
                    com.google.common.io.Files.createParentDirs((File)queryPlanWritePath.toFile());
                    com.google.common.io.Files.write((byte[])this.generateQueryPlan(BaseCostBasedPlanTest.readQuery(queryResourcePath)).getBytes(StandardCharsets.UTF_8), (File)queryPlanWritePath.toFile());
                    log.info("Generated expected plan for query: %s", new Object[]{queryResourcePath});
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.destroyPlanTest();
        }
    }

    private static String readQuery(String resource) {
        return BaseCostBasedPlanTest.read(resource).replaceAll("\\s+;\\s+$", "").replace("${database}.${schema}.", "").replace("\"${database}\".\"${schema}\".\"${prefix}", "\"").replace("${scale}", "1");
    }

    private static String read(String resource) {
        try {
            return Resources.toString((URL)Resources.getResource(BaseCostBasedPlanTest.class, (String)resource), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private String generateQueryPlan(String query) {
        try {
            return (String)this.getPlanTester().inTransaction(transactionSession -> {
                PlanTester planTester = this.getPlanTester();
                Plan plan = planTester.createPlan(transactionSession, query, planTester.getPlanOptimizers(false), LogicalPlanner.Stage.OPTIMIZED_AND_VALIDATED, WarningCollector.NOOP, PlanOptimizersStatsCollector.createPlanOptimizersStatsCollector());
                JoinOrderPrinter joinOrderPrinter = new JoinOrderPrinter((Session)transactionSession);
                plan.getRoot().accept((PlanVisitor)joinOrderPrinter, (Object)0);
                return joinOrderPrinter.result();
            });
        }
        catch (RuntimeException e) {
            throw new AssertionError("Planning failed for SQL: " + query, e);
        }
    }

    private Path getSourcePath() {
        Path workingDir = Paths.get(System.getProperty("user.dir"), new String[0]);
        Verify.verify((boolean)Files.isDirectory(workingDir, new LinkOption[0]), (String)"Working directory is not a directory", (Object[])new Object[0]);
        if (Files.isDirectory(workingDir.resolve(".git"), new LinkOption[0])) {
            return workingDir.resolve("testing/trino-tests");
        }
        if (workingDir.getFileName().toString().equals("trino-tests")) {
            return workingDir;
        }
        throw new IllegalStateException("This class must be executed from trino-tests or Trino source directory");
    }

    private static String argumentBindingToString(Partitioning.ArgumentBinding argument) {
        if (argument.isConstant()) {
            return argument.getConstant().getValue().toString();
        }
        return argument.getColumn().name();
    }

    private class JoinOrderPrinter
    extends SimplePlanVisitor<Integer> {
        private final Session session;
        private final StringBuilder result = new StringBuilder();

        public JoinOrderPrinter(Session session) {
            this.session = Objects.requireNonNull(session, "session is null");
        }

        public String result() {
            return this.result.toString();
        }

        public Void visitJoin(JoinNode node, Integer indent) {
            JoinNode.DistributionType distributionType = (JoinNode.DistributionType)node.getDistributionType().orElseThrow(() -> new VerifyException("Expected distribution type to be set"));
            if (node.isCrossJoin()) {
                Preconditions.checkState((node.getType() == JoinType.INNER && distributionType == JoinNode.DistributionType.REPLICATED ? 1 : 0) != 0, (Object)"Expected CROSS JOIN to be INNER REPLICATED");
                if (node.isMaySkipOutputDuplicates()) {
                    this.output(indent, "cross join (can skip output duplicates):", new Object[0]);
                } else {
                    this.output(indent, "cross join:", new Object[0]);
                }
            } else if (node.isMaySkipOutputDuplicates()) {
                this.output(indent, "join (%s, %s, can skip output duplicates):", node.getType(), distributionType);
            } else {
                this.output(indent, "join (%s, %s):", node.getType(), distributionType);
            }
            return this.visitPlan((PlanNode)node, indent + 1);
        }

        public Void visitExchange(ExchangeNode node, Integer indent) {
            Partitioning partitioning = node.getPartitioningScheme().getPartitioning();
            this.output(indent, "%s exchange (%s, %s, %s)", node.getScope().name().toLowerCase(Locale.ENGLISH), node.getType(), partitioning.getHandle(), partitioning.getArguments().stream().map(BaseCostBasedPlanTest::argumentBindingToString).sorted().collect(Collectors.joining(", ", "[", "]")));
            return this.visitPlan((PlanNode)node, indent + 1);
        }

        public Void visitAggregation(AggregationNode node, Integer indent) {
            this.output(indent, "%s aggregation over (%s)", node.getStep().name().toLowerCase(Locale.ENGLISH), node.getGroupingKeys().stream().map(Symbol::name).sorted().collect(Collectors.joining(", ")));
            return this.visitPlan((PlanNode)node, indent + 1);
        }

        public Void visitFilter(FilterNode node, Integer indent) {
            DynamicFilters.ExtractResult filters = DynamicFilters.extractDynamicFilters((Expression)node.getPredicate());
            String inputs = filters.getDynamicConjuncts().stream().map(descriptor -> ((Reference)descriptor.getInput()).name() + "::" + String.valueOf(descriptor.getOperator())).sorted().collect(Collectors.joining(", "));
            if (!inputs.isEmpty()) {
                this.output(indent, "dynamic filter (%s)", inputs);
                indent = indent + 1;
            }
            return this.visitPlan((PlanNode)node, indent);
        }

        public Void visitTableScan(TableScanNode node, Integer indent) {
            CatalogSchemaTableName tableName = BaseCostBasedPlanTest.this.getPlanTester().getPlannerContext().getMetadata().getTableName(this.session, node.getTable());
            this.output(indent, "scan %s", tableName.getSchemaTableName().getTableName());
            return null;
        }

        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            this.output(indent, "semijoin (%s):", node.getDistributionType().get());
            return this.visitPlan((PlanNode)node, indent + 1);
        }

        public Void visitValues(ValuesNode node, Integer indent) {
            this.output(indent, "values (%s rows)", node.getRowCount());
            return null;
        }

        @FormatMethod
        private void output(int indent, String message, Object ... args) {
            String formattedMessage = String.format(message, args);
            this.result.append(String.format("%s%s\n", "    ".repeat(indent), formattedMessage));
        }
    }
}

