/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.airlift.log.Logger;
import io.trino.metastore.Database;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.Table;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.iceberg.CatalogType;
import io.trino.plugin.iceberg.IcebergConnector;
import io.trino.plugin.iceberg.IcebergConnectorFactory;
import io.trino.plugin.iceberg.catalog.AbstractIcebergTableOperations;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorContext;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.containers.Minio;
import io.trino.testing.containers.junit.ReportLeakedContainers;
import io.trino.testing.minio.MinioClient;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class IcebergCostBasedPlanTestSetup {
    private static final Logger log = Logger.get(IcebergCostBasedPlanTestSetup.class);
    private static final String BUCKET_NAME = "starburst-benchmarks-data";
    @GuardedBy(value="sharedMinioLock")
    private static Minio sharedMinio;
    @GuardedBy(value="sharedMinioLock")
    private static boolean sharedMinioClosed;
    private static final Object sharedMinioLock;
    private Minio minio;
    private Path temporaryMetastoreDirectory;
    private HiveMetastore hiveMetastore;
    private Map<String, String> connectorConfiguration;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorFactory createConnectorFactory() {
        Object object = sharedMinioLock;
        synchronized (object) {
            if (sharedMinio == null) {
                Preconditions.checkState((!sharedMinioClosed ? 1 : 0) != 0, (Object)"sharedMinio already closed");
                Minio minio = Minio.builder().build();
                minio.start();
                minio.createBucket(BUCKET_NAME);
                sharedMinio = minio;
                Runtime.getRuntime().addShutdownHook(new Thread(IcebergCostBasedPlanTestSetup::disposeSharedResources));
                ReportLeakedContainers.ignoreContainerId((String)sharedMinio.getContainerId());
            }
            this.minio = sharedMinio;
        }
        try {
            this.temporaryMetastoreDirectory = Files.createTempDirectory("file-metastore", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.connectorConfiguration = ImmutableMap.builder().put((Object)"iceberg.catalog.type", (Object)CatalogType.TESTING_FILE_METASTORE.name()).put((Object)"hive.metastore.catalog.dir", (Object)this.temporaryMetastoreDirectory.toString()).put((Object)"fs.native-s3.enabled", (Object)"true").put((Object)"fs.hadoop.enabled", (Object)"true").put((Object)"s3.aws-access-key", (Object)"accesskey").put((Object)"s3.aws-secret-key", (Object)"secretkey").put((Object)"s3.region", (Object)"us-east-1").put((Object)"s3.endpoint", (Object)this.minio.getMinioAddress()).put((Object)"s3.path-style-access", (Object)"true").put((Object)"iceberg.extended-statistics.enabled", (Object)"true").put((Object)"bootstrap.quiet", (Object)"true").buildOrThrow();
        return new IcebergConnectorFactory(){

            public Connector create(String catalogName, Map<String, String> config, ConnectorContext context) {
                Preconditions.checkArgument((boolean)config.isEmpty(), (String)"Unexpected configuration %s", config);
                Connector connector = super.create(catalogName, IcebergCostBasedPlanTestSetup.this.connectorConfiguration, context);
                IcebergCostBasedPlanTestSetup.this.hiveMetastore = ((HiveMetastoreFactory)((IcebergConnector)connector).getInjector().getInstance(HiveMetastoreFactory.class)).createMetastore(Optional.empty());
                return connector;
            }
        };
    }

    public void createDatabase(String schema) {
        this.hiveMetastore.createDatabase(Database.builder().setDatabaseName(schema).setOwnerName(Optional.empty()).setOwnerType(Optional.empty()).build());
    }

    public void populateTablesFromResource(List<String> tableNames, String schema, String resourceDirectory, String targetDirectory) {
        for (String tableName : tableNames) {
            String metadataLocation;
            String resourcePath = resourceDirectory + tableName;
            String targetPath = targetDirectory + tableName;
            log.info("Copying resources for %s table from %s to %s in the container", new Object[]{tableName, resourcePath, targetPath});
            this.minio.copyResources(resourcePath, BUCKET_NAME, targetPath);
            String tableLocation = "s3://%s/%s".formatted(BUCKET_NAME, targetPath);
            try (MinioClient minioClient = this.minio.createMinioClient();){
                String metadataPath = (String)minioClient.listObjects(BUCKET_NAME, targetPath + "/metadata/").stream().filter(path -> path.endsWith(".metadata.json")).collect(MoreCollectors.onlyElement());
                metadataLocation = "s3://%s/%s".formatted(BUCKET_NAME, metadataPath);
            }
            log.info("Registering table %s using metadata location %s", new Object[]{tableName, metadataLocation});
            this.hiveMetastore.createTable(Table.builder().setDatabaseName(schema).setTableName(tableName).setOwner(Optional.empty()).setTableType(TableType.EXTERNAL_TABLE.name()).setDataColumns(List.of()).withStorage(storage -> storage.setLocation(tableLocation)).withStorage(storage -> storage.setStorageFormat(AbstractIcebergTableOperations.ICEBERG_METASTORE_STORAGE_FORMAT)).setParameter("EXTERNAL", "TRUE").setParameter("table_type", "iceberg".toUpperCase(Locale.ENGLISH)).setParameter("metadata_location", metadataLocation).build(), PrincipalPrivileges.NO_PRIVILEGES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUp() throws Exception {
        if (this.minio != null) {
            Object object = sharedMinioLock;
            synchronized (object) {
                Verify.verify((this.minio == sharedMinio ? 1 : 0) != 0);
            }
            this.minio = null;
        }
        if (this.temporaryMetastoreDirectory != null) {
            MoreFiles.deleteRecursively((Path)this.temporaryMetastoreDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        this.hiveMetastore = null;
        this.connectorConfiguration = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void disposeSharedResources() {
        Object object = sharedMinioLock;
        synchronized (object) {
            sharedMinioClosed = true;
            if (sharedMinio != null) {
                sharedMinio.stop();
                sharedMinio = null;
            }
        }
    }

    static {
        sharedMinioLock = new Object();
    }
}

