/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.OptimizerConfig;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestDictionaryAggregation
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() {
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(TestingSession.testSessionBuilder().setSystemProperty("dictionary_aggregation", "true").setSystemProperty("join_reordering_strategy", OptimizerConfig.JoinReorderingStrategy.NONE.toString()).build());
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        return queryRunner;
    }

    @Test
    public void testMixedDistinctWithFilter() {
        this.assertQuery("SELECT      count(DISTINCT x) FILTER (WHERE x > 0),      sum(x) FROM (VALUES 0, 1, 1, 2) t(x)", "VALUES (2, 4)");
        this.assertQuery("SELECT count(DISTINCT x) FILTER (where y = 1)FROM (VALUES (2, 1), (1, 2), (1,1)) t(x, y)", "VALUES 2");
    }

    @Test
    public void testAggregationOverJoin() {
        this.assertQuery("SELECT to_hex(checksum(DISTINCT l.comment)) FROM tpch.sf1.lineitem l JOIN tpch.\"sf0.1\".orders USING(orderkey) WHERE orderpriority = '1-URGENT'", "VALUES '2D0814DA01053A47'");
    }
}

