/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;

public class TestDistributedSpilledQueries
extends AbstractTestQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        return TestDistributedSpilledQueries.createSpillingQueryRunner();
    }

    public static QueryRunner createSpillingQueryRunner() throws Exception {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").setSystemProperty("task_concurrency", "2").setSystemProperty("spill_enabled", "true").setSystemProperty("aggregation_operator_unspill_memory_limit", "128kB").build();
        ImmutableMap extraProperties = ImmutableMap.builder().put((Object)"spiller-spill-path", (Object)Paths.get(System.getProperty("java.io.tmpdir"), "trino", "spills", UUID.randomUUID().toString()).toString()).put((Object)"spiller-max-used-space-threshold", (Object)"1.0").put((Object)"memory-revoking-threshold", (Object)"0.0").put((Object)"memory-revoking-target", (Object)"0.0").buildOrThrow();
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)defaultSession).setWorkerCount(1).setExtraProperties((Map)extraProperties).build();
        try {
            queryRunner.installPlugin((Plugin)new TpchPlugin());
            queryRunner.createCatalog("tpch", "tpch");
            return queryRunner;
        }
        catch (Exception e) {
            queryRunner.close();
            throw e;
        }
    }
}

