/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.trino.Session;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExcludeColumnsFunction
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        return queryRunner;
    }

    @Test
    public void testExcludeColumnsFunction() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT * FROM tpch.tiny.nation"))).matches("SELECT nationkey, name, regionkey, comment FROM tpch.tiny.nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(comment)))\n"))).matches("SELECT nationkey, name, regionkey FROM tpch.tiny.nation");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(regionkey, nationkey)))\n"))).matches("SELECT name, comment FROM tpch.tiny.nation");
    }

    @Test
    public void testInvalidArgument() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => CAST(null AS DESCRIPTOR)))\n"))).failure().hasMessage("COLUMNS descriptor is null");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR()))\n"))).failure().hasMessage("line 4:21: Invalid descriptor argument COLUMNS. Descriptors should be formatted as 'DESCRIPTOR(name [type], ...)'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(foo, comment, bar)))\n"))).failure().hasMessage("Excluded columns: [foo, bar] not present in the table");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(nationkey bigint, comment)))\n"))).failure().hasMessage("COLUMNS descriptor contains types");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(nationkey, name, regionkey, comment)))\n"))).failure().hasMessage("All columns are excluded");
    }

    @Test
    public void testColumnResolution() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(SELECT 1, 2, 3, 4, 5) t(a, B, \"c\", \"D\", e),\n                    columns => DESCRIPTOR(\"A\", \"b\", C, d)))\n"))).matches("SELECT 5");
    }

    @Test
    public void testReturnedColumnNames() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT a, b, c, d\nFROM TABLE(exclude_columns(\n                    input => TABLE(SELECT 1, 2, 3, 4, 5) t(a, B, \"c\", \"D\", e),\n                    columns => DESCRIPTOR(e)))\n"))).matches("SELECT 1, 2, 3, 4");
    }

    @Test
    public void testHiddenColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT row_number FROM tpch.tiny.region"))).matches("SELECT * FROM UNNEST(sequence(0, 4))");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT row_number\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(comment)))\n"))).failure().hasMessage("line 1:8: Column 'row_number' cannot be resolved");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(row_number)))\n"))).failure().hasMessage("Excluded columns: [row_number] not present in the table");
    }

    @Test
    public void testAnonymousColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(SELECT 1 a, 2, 3 c, 4),\n                    columns => DESCRIPTOR(a, c)))\n"))).matches("SELECT 2, 4");
    }

    @Test
    public void testDuplicateExcludedColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(comment, name, comment)))\n"))).matches("SELECT nationkey, regionkey FROM tpch.tiny.nation");
    }

    @Test
    public void testDuplicateInputColumn() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(SELECT 1, 2, 3, 4, 5) t(a, b, c, a, b),\n                    columns => DESCRIPTOR(a, b)))\n"))).matches("SELECT 3");
    }

    @Test
    public void testFunctionResolution() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(system.builtin.exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(comment)))\n"))).matches("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.nation),\n                    columns => DESCRIPTOR(comment)))\n");
    }

    @Test
    public void testBigInput() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT *\nFROM TABLE(exclude_columns(\n                    input => TABLE(tpch.tiny.orders),\n                    columns => DESCRIPTOR(orderstatus, orderdate, orderpriority, clerk, shippriority, comment)))\n"))).matches("SELECT orderkey, custkey, totalprice FROM tpch.tiny.orders");
    }
}

