/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.metadata.Metadata;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.security.AccessControl;
import io.trino.spi.Plugin;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import io.trino.testing.TransactionBuilder;
import io.trino.transaction.TransactionManager;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestGetTableStatisticsOperations
extends AbstractTestQueryFramework {
    private QueryRunner queryRunner;

    protected QueryRunner createQueryRunner() throws Exception {
        this.queryRunner = new StandaloneQueryRunner(TestingSession.testSession());
        this.queryRunner.installPlugin((Plugin)new TpchPlugin());
        this.queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        return this.queryRunner;
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testTwoWayJoin() {
        this.planDistributedQuery("SELECT * FROM tpch.tiny.orders o, tpch.tiny.lineitem l WHERE o.orderkey = l.orderkey");
        Assertions.assertThat((long)this.getTableStatisticsMethodInvocations()).isEqualTo(2L);
    }

    @Test
    public void testThreeWayJoin() {
        this.planDistributedQuery("SELECT * FROM tpch.tiny.customer c, tpch.tiny.orders o, tpch.tiny.lineitem l WHERE o.orderkey = l.orderkey AND c.custkey = o.custkey");
        Assertions.assertThat((long)this.getTableStatisticsMethodInvocations()).isEqualTo(3L);
    }

    private void planDistributedQuery(@Language(value="SQL") String sql) {
        TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (Metadata)this.queryRunner.getPlannerContext().getMetadata(), (AccessControl)this.queryRunner.getAccessControl()).execute(this.queryRunner.getDefaultSession(), transactionSession -> this.queryRunner.createPlan(transactionSession, sql));
    }

    private long getTableStatisticsMethodInvocations() {
        return this.queryRunner.getSpans().stream().map(SpanData::getName).filter(name -> name.equals("Metadata.getTableStatistics")).count();
    }
}

