/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MoreCollectors;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.execution.QueryState;
import io.trino.execution.SqlTaskManager;
import io.trino.memory.TestMemoryManager;
import io.trino.metadata.NodeState;
import io.trino.server.BasicQueryInfo;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.TestingSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestGracefulShutdown {
    private static final long SHUTDOWN_TIMEOUT_MILLIS = 240000L;
    private static final Session TINY_SESSION = TestingSession.testSessionBuilder().setCatalog("tpch").setSchema("tiny").build();
    private ListeningExecutorService executor;

    @BeforeAll
    public void setUp() {
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    }

    @AfterAll
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Test
    @Timeout(value=240000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdown() throws Exception {
        ImmutableMap properties = ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"shutdown.grace-period", (Object)"10s").buildOrThrow();
        try (DistributedQueryRunner queryRunner = TestMemoryManager.createQueryRunner(TINY_SESSION, (Map<String, String>)properties);){
            ArrayList<ListenableFuture> queryFutures = new ArrayList<ListenableFuture>();
            for (int i = 0; i < 5; ++i) {
                queryFutures.add(Futures.submit(() -> queryRunner.execute("SELECT COUNT(*), clerk FROM orders GROUP BY clerk"), (Executor)this.executor));
            }
            TestingTrinoServer worker = queryRunner.getServers().stream().filter(server -> !server.isCoordinator()).findFirst().orElseThrow();
            SqlTaskManager taskManager = worker.getTaskManager();
            while (taskManager.getAllTaskInfo().isEmpty()) {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            worker.getNodeStateManager().transitionState(NodeState.SHUTTING_DOWN);
            Futures.allAsList(queryFutures).get();
            List queryInfos = queryRunner.getCoordinator().getQueryManager().getQueries();
            for (BasicQueryInfo info : queryInfos) {
                Assertions.assertThat((Comparable)info.getState()).isEqualTo((Object)QueryState.FINISHED);
            }
            TestingTrinoServer.TestShutdownAction shutdownAction = (TestingTrinoServer.TestShutdownAction)worker.getShutdownAction();
            shutdownAction.waitForShutdownComplete(240000L);
            Assertions.assertThat((boolean)shutdownAction.isWorkerShutdown()).isTrue();
        }
    }

    @Test
    public void testCoordinatorShutdown() throws Exception {
        try (DistributedQueryRunner queryRunner = TestMemoryManager.createQueryRunner(TINY_SESSION, (Map<String, String>)ImmutableMap.of());){
            TestingTrinoServer coordinator = (TestingTrinoServer)queryRunner.getServers().stream().filter(TestingTrinoServer::isCoordinator).collect(MoreCollectors.onlyElement());
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> coordinator.getNodeStateManager().transitionState(NodeState.SHUTTING_DOWN)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Cannot shutdown coordinator");
        }
    }
}

