/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.execution.DynamicFilterConfig;
import io.trino.testing.AbstractTestJoinQueries;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Map;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class TestJoinQueries
extends AbstractTestJoinQueries {
    protected QueryRunner createQueryRunner() throws Exception {
        Verify.verify((boolean)new DynamicFilterConfig().isEnableDynamicFiltering(), (String)"this class assumes dynamic filtering is enabled by default", (Object[])new Object[0]);
        return TpchQueryRunner.builder().build();
    }

    @Test
    public void verifyDynamicFilteringEnabled() {
        this.assertQuery("SHOW SESSION LIKE 'enable_dynamic_filtering'", "VALUES ('enable_dynamic_filtering', 'true', 'true', 'boolean', 'Enable dynamic filtering')");
    }

    @Test
    @Timeout(value=120L)
    public void testBroadcastJoinDeadlockResolution() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"join-distribution-type", (Object)"BROADCAST", (Object)"optimizer.join-reordering-strategy", (Object)"NONE", (Object)"node-scheduler.min-pending-splits-per-task", (Object)"1", (Object)"node-scheduler.max-splits-per-node", (Object)"1", (Object)"node-scheduler.max-unacknowledged-splits-per-task", (Object)"1"))).setExtraProperties((Map)ImmutableMap.of((Object)"sink.max-broadcast-buffer-size", (Object)"1kB"))).withConnectorProperties(Map.of("tpch.splits-per-node", "10")).build();){
            String sql = "SELECT * FROM supplier s INNER JOIN lineitem l ON s.suppkey = l.suppkey";
            MaterializedResult actual = queryRunner.execute(sql);
            MaterializedResult expected = this.getQueryRunner().execute(sql);
            QueryAssertions.assertEqualsIgnoreOrder((Iterable)actual, (Iterable)expected, (String)("For query: \n " + sql));
        }
    }
}

