/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.AbstractTestEngineOnlyQueries;
import io.trino.testing.CustomFunctionBundle;
import io.trino.testing.QueryRunner;
import io.trino.tests.TestLocalQueries;
import java.util.Map;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public class TestLocalEngineOnlyQueries
extends AbstractTestEngineOnlyQueries {
    protected QueryRunner createQueryRunner() {
        QueryRunner queryRunner = TestLocalQueries.createTestQueryRunner();
        try {
            queryRunner.addFunctions(CustomFunctionBundle.CUSTOM_FUNCTIONS);
            queryRunner.getSessionPropertyManager().addSystemSessionProperties(TEST_SYSTEM_PROPERTIES);
            queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withSessionProperties((Iterable)TEST_CATALOG_PROPERTIES).build()));
            queryRunner.createCatalog("testing_catalog", "mock", (Map)ImmutableMap.of());
        }
        catch (RuntimeException e) {
            throw (RuntimeException)Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
        }
        return queryRunner;
    }

    @Test
    public void testSetSession() {
        Assumptions.abort((String)"SET SESSION is not supported by PlanTester");
    }

    @Test
    public void testResetSession() {
        Assumptions.abort((String)"RESET SESSION is not supported by PlanTester");
    }
}

