/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.plugin.memory.MemoryPlugin;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueries;
import io.trino.testing.MaterializedResult;
import io.trino.testing.QueryRunner;
import io.trino.testing.StandaloneQueryRunner;
import io.trino.testing.TestingSession;
import java.util.Map;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLocalQueries
extends AbstractTestQueries {
    protected QueryRunner createQueryRunner() {
        return TestLocalQueries.createTestQueryRunner();
    }

    public static QueryRunner createTestQueryRunner() {
        Session defaultSession = TestingSession.testSessionBuilder().setCatalog("local").setSchema("tiny").setSystemProperty("push_partial_aggregation_through_join", "true").build();
        StandaloneQueryRunner queryRunner = new StandaloneQueryRunner(defaultSession);
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog((String)defaultSession.getCatalog().get(), "tpch", (Map)ImmutableMap.of((Object)"tpch.splits-per-node", (Object)"1"));
        queryRunner.installPlugin((Plugin)new MemoryPlugin());
        queryRunner.createCatalog("memory", "memory");
        return queryRunner;
    }

    @Test
    public void testDDL() {
        this.assertQuerySucceeds("CREATE SCHEMA memory.test_schema");
        this.assertQuerySucceeds("CREATE TABLE memory.test_schema.test_table (c) AS VALUES 1");
        this.assertQuerySucceeds("SELECT count(*) FROM memory.test_schema.test_table");
        this.assertQuerySucceeds("DROP TABLE memory.test_schema.test_table");
        this.assertQuerySucceeds("DROP SCHEMA memory.test_schema");
    }

    @Test
    public void testShowColumnStats() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW STATS FOR nation"))).result().matches(MaterializedResult.resultBuilder((Session)this.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, DoubleType.DOUBLE, VarcharType.VARCHAR, VarcharType.VARCHAR}).row(new Object[]{"nationkey", null, 25.0, 0.0, null, "0", "24"}).row(new Object[]{"name", 177.0, 25.0, 0.0, null, null, null}).row(new Object[]{"regionkey", null, 5.0, 0.0, null, "0", "4"}).row(new Object[]{"comment", 1857.0, 25.0, 0.0, null, null, null}).row(new Object[]{null, null, null, null, 25.0, null, null}).build());
    }

    @Test
    public void testRejectStarQueryWithoutFromRelation() {
        this.assertQueryFails("SELECT *", "line \\S+ SELECT \\* not allowed in queries without FROM clause");
        this.assertQueryFails("SELECT 1, '2', *", "line \\S+ SELECT \\* not allowed in queries without FROM clause");
    }

    @Test
    public void testDecimal() {
        this.assertQuery("SELECT DECIMAL '1.0'", "SELECT CAST('1.0' AS DECIMAL(10, 1))");
        this.assertQuery("SELECT DECIMAL '1.'", "SELECT CAST('1.0' AS DECIMAL(10, 1))");
        this.assertQuery("SELECT DECIMAL '0.1'", "SELECT CAST('0.1' AS DECIMAL(10, 1))");
        this.assertQuery("SELECT 1.0");
        this.assertQuery("SELECT 1.");
        this.assertQuery("SELECT 0.1");
    }

    @Test
    public void testHueQueries() {
        this.assertQuerySucceeds(this.getSession(), "SELECT table_name, table_comment FROM information_schema.tables WHERE table_schema='nation'");
        this.assertQuerySucceeds(this.getSession(), "SELECT column_name, data_type, column_comment FROM information_schema.columns WHERE table_schema='local' AND TABLE_NAME='nation'");
    }

    @Test
    public void testTransformValuesInTry() {
        this.assertQuery("SELECT json_format(CAST(try(transform_values(m, (k, v) -> k / v)) AS json)) FROM (VALUES map(ARRAY[1, 2], ARRAY[0, 0]),  map(ARRAY[28], ARRAY[2]), map(ARRAY[18], ARRAY[2]), map(ARRAY[4, 5], ARRAY[1, 0]),  map(ARRAY[12], ARRAY[3])) AS t(m)", "VALUES NULL, '{\"28\":14}', '{\"18\":9}', NULL, '{\"12\":4}'");
    }
}

