/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.dispatcher.DispatchInfo;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.ExecutionFailureInfo;
import io.trino.execution.QueryState;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataManager;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.security.AccessControl;
import io.trino.server.BasicQueryInfo;
import io.trino.server.SessionContext;
import io.trino.server.protocol.Slug;
import io.trino.spi.Plugin;
import io.trino.spi.QueryId;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.BigintType;
import io.trino.testing.QueryRunner;
import io.trino.testing.TransactionBuilder;
import io.trino.tests.tpch.TpchQueryRunner;
import io.trino.tracing.TracingMetadata;
import io.trino.transaction.TransactionManager;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestMetadataManager {
    private QueryRunner queryRunner;
    private MetadataManager metadataManager;

    @BeforeAll
    public void setUp() throws Exception {
        this.queryRunner = TpchQueryRunner.builder().build();
        this.queryRunner.installPlugin(new Plugin(this){

            public Iterable<ConnectorFactory> getConnectorFactories() {
                SchemaTableName viewTableName = new SchemaTableName("UPPER_CASE_SCHEMA", "test_view");
                MockConnectorFactory connectorFactory = MockConnectorFactory.builder().withListSchemaNames(session -> ImmutableList.of((Object)"UPPER_CASE_SCHEMA")).withGetTableHandle((session, schemaTableName) -> {
                    if (schemaTableName.equals((Object)viewTableName)) {
                        return null;
                    }
                    return new MockConnectorTableHandle(schemaTableName);
                }).withListTables((session, schemaName) -> ImmutableList.of((Object)"UPPER_CASE_TABLE")).withGetViews((session, prefix) -> ImmutableMap.of((Object)viewTableName, (Object)TestMetadataManager.getConnectorViewDefinition())).build();
                return ImmutableList.of((Object)connectorFactory);
            }
        });
        this.queryRunner.createCatalog("upper_case_schema_catalog", "mock");
        this.metadataManager = (MetadataManager)((TracingMetadata)this.queryRunner.getPlannerContext().getMetadata()).getDelegate();
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
        this.metadataManager = null;
    }

    @Test
    public void testMetadataIsClearedAfterQueryFinished() {
        String sql = "SELECT * FROM nation";
        this.queryRunner.execute(sql);
        Assertions.assertThat((Collection)this.metadataManager.getActiveQueryIds()).isEmpty();
    }

    @Test
    public void testMetadataIsClearedAfterQueryFailed() {
        String sql = "SELECT nationkey/0 FROM nation";
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.queryRunner.execute(sql)).isInstanceOf(RuntimeException.class)).hasMessage("Division by zero");
        Assertions.assertThat((Collection)this.metadataManager.getActiveQueryIds()).isEmpty();
    }

    @Test
    public void testMetadataListTablesReturnsQualifiedView() {
        TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (Metadata)this.metadataManager, (AccessControl)this.queryRunner.getAccessControl()).execute(SessionTestUtils.TEST_SESSION, transactionSession -> {
            QualifiedTablePrefix viewName = new QualifiedTablePrefix("upper_case_schema_catalog", "upper_case_schema", "test_view");
            Assertions.assertThat((List)this.metadataManager.listTables(transactionSession, viewName)).containsExactly((Object[])new QualifiedObjectName[]{(QualifiedObjectName)viewName.asQualifiedObjectName().get()});
        });
    }

    @Test
    public void testMetadataIsClearedAfterQueryCanceled() throws Exception {
        DispatchManager dispatchManager = this.queryRunner.getCoordinator().getDispatchManager();
        QueryId queryId = dispatchManager.createQueryId();
        dispatchManager.createQuery(queryId, Span.getInvalid(), Slug.createNew(), SessionContext.fromSession((Session)SessionTestUtils.TEST_SESSION), "SELECT * FROM lineitem").get();
        while (true) {
            BasicQueryInfo queryInfo;
            if ((queryInfo = dispatchManager.getQueryInfo(queryId)).getState().isDone()) {
                Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
                throw ((ExecutionFailureInfo)((DispatchInfo)dispatchManager.getDispatchInfo(queryId).get()).getFailureInfo().get()).toException();
            }
            if (queryInfo.getState() == QueryState.RUNNING) break;
            Thread.sleep(100L);
        }
        dispatchManager.cancelQuery(queryId);
        Assertions.assertThat((Collection)this.metadataManager.getActiveQueryIds()).isEmpty();
    }

    @Test
    public void testUpperCaseSchemaIsChangedToLowerCase() {
        TransactionBuilder.transaction((TransactionManager)this.queryRunner.getTransactionManager(), (Metadata)this.metadataManager, (AccessControl)this.queryRunner.getAccessControl()).execute(SessionTestUtils.TEST_SESSION, transactionSession -> {
            ImmutableList expectedSchemas = ImmutableList.of((Object)"information_schema", (Object)"upper_case_schema");
            Assertions.assertThat((List)this.queryRunner.getPlannerContext().getMetadata().listSchemaNames(transactionSession, "upper_case_schema_catalog")).isEqualTo((Object)expectedSchemas);
            return null;
        });
    }

    @Test
    public void testUpperCaseListTablesFilter() {
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.tables WHERE TABLE_SCHEM = 'upper_case_schema' AND TABLE_NAME = 'upper_case_table'")).hasSize(1);
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.tables WHERE TABLE_SCHEM = 'UPPER_CASE_SCHEMA'")).isEmpty();
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.tables WHERE TABLE_NAME = 'UPPER_CASE_TABLE'")).isEmpty();
    }

    @Test
    public void testColumnsQueryWithUpperCaseFilter() {
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.columns WHERE table_schem = 'upper_case_schema' AND table_name = 'upper_case_table'")).hasSize(100);
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.columns WHERE table_schem = 'UPPER_CASE_SCHEMA'")).isEmpty();
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.columns WHERE table_name = 'UPPER_CASE_TABLE'")).isEmpty();
        Assertions.assertThat((Iterable)this.queryRunner.execute("SELECT * FROM system.jdbc.columns WHERE table_schem = 'UPPER_CASE_TABLE' AND table_name = 'UPPER_CASE_TABLE'")).isEmpty();
    }

    private static ConnectorViewDefinition getConnectorViewDefinition() {
        return new ConnectorViewDefinition("test view SQL", Optional.of("upper_case_schema_catalog"), Optional.of("upper_case_schema"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("col", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of("comment"), Optional.of("test_owner"), false, (List)ImmutableList.of());
    }
}

