/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.trino.Session;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.server.testing.TestingTrinoServer;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestMinWorkerRequirement {
    @Test
    public void testInsufficientWorkerNodes() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"query-manager.required-workers", (Object)"5").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(3)).build();){
                queryRunner.execute("SELECT COUNT(*) from lineitem");
                Fail.fail((String)"Expected exception due to insufficient active worker nodes");
            }
        }).isInstanceOf(RuntimeException.class)).hasMessage("Insufficient active worker nodes. Waited 1.00ns for at least 5 workers, but only 4 workers are active");
    }

    @Test
    public void testInsufficientWorkerNodesWithCoordinatorExcluded() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"node-scheduler.include-coordinator", (Object)"false").put((Object)"query-manager.required-workers", (Object)"4").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(3)).build();){
                queryRunner.execute("SELECT COUNT(*) from lineitem");
                Fail.fail((String)"Expected exception due to insufficient active worker nodes");
            }
        }).isInstanceOf(RuntimeException.class)).hasMessage("Insufficient active worker nodes. Waited 1.00ns for at least 4 workers, but only 3 workers are active");
    }

    @Test
    public void testInsufficientWorkerNodesInternalSystemQuery() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"query-manager.required-workers", (Object)"5").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(3)).build();){
            queryRunner.execute("SELECT 1");
            queryRunner.execute("DESCRIBE lineitem");
            queryRunner.execute("SHOW TABLES");
            queryRunner.execute("SHOW SCHEMAS");
            queryRunner.execute("SHOW CATALOGS");
            queryRunner.execute("SET SESSION required_workers_count=5");
            queryRunner.execute("SELECT * from system.runtime.nodes");
            queryRunner.execute("EXPLAIN SELECT count(*) from lineitem");
        }
    }

    @Test
    public void testInsufficientWorkerNodesAfterDrop() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"query-manager.required-workers", (Object)"4").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(3)).build();){
            queryRunner.execute("SELECT COUNT(*) from lineitem");
            Assertions.assertThat((Collection)queryRunner.getCoordinator().refreshNodes().getActiveNodes()).hasSize(4);
            ((TestingTrinoServer)queryRunner.getServers().get(0)).close();
            Assertions.assertThat((Collection)queryRunner.getCoordinator().refreshNodes().getActiveNodes()).hasSize(3);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queryRunner.execute("SELECT COUNT(*) from lineitem")).isInstanceOf(RuntimeException.class)).hasMessage("Insufficient active worker nodes. Waited 1.00ns for at least 4 workers, but only 3 workers are active");
        }
    }

    @Test
    public void testRequiredNodesMaxWaitSessionOverride() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"query-manager.required-workers", (Object)"3").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(1)).build();){
                Session session = TestingSession.testSessionBuilder().setSystemProperty("required_workers_count", "3").setSystemProperty("required_workers_max_wait_time", "99ns").setCatalog("tpch").setSchema("tiny").build();
                queryRunner.execute(session, "SELECT COUNT(*) from lineitem");
                Fail.fail((String)"Expected exception due to insufficient active worker nodes");
            }
        }).isInstanceOf(RuntimeException.class)).hasMessage("Insufficient active worker nodes. Waited 99.00ns for at least 3 workers, but only 2 workers are active");
    }

    @Test
    public void testRequiredWorkerNodesSessionOverride() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)((TpchQueryRunner.Builder)TpchQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.builder().put((Object)"query-manager.required-workers", (Object)"5").put((Object)"query-manager.required-workers-max-wait", (Object)"1ns").buildOrThrow())).setWorkerCount(3)).build();){
            Session session = TestingSession.testSessionBuilder().setSystemProperty("required_workers_count", "4").setCatalog("tpch").setSchema("tiny").build();
            queryRunner.execute(session, "SELECT COUNT(*) from lineitem");
            Session require6Workers = Session.builder((Session)session).setSystemProperty("required_workers_count", "6").build();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> queryRunner.execute(require6Workers, "SELECT COUNT(*) from lineitem")).isInstanceOf(RuntimeException.class)).hasMessage("Insufficient active worker nodes. Waited 1.00ns for at least 6 workers, but only 4 workers are active");
            queryRunner.addServers(2);
            Assertions.assertThat((Collection)queryRunner.getCoordinator().refreshNodes().getActiveNodes()).hasSize(6);
            queryRunner.execute(require6Workers, "SELECT COUNT(*) from lineitem");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleRequiredWorkerNodesSessionOverride() throws Exception {
        ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newFixedThreadPool(3));
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)TpchQueryRunner.builder().setWorkerCount(0)).build();){
            Session session1 = Session.builder((Session)queryRunner.getDefaultSession()).setSystemProperty("required_workers_count", "2").build();
            ListenableFuture queryFuture1 = service.submit(() -> queryRunner.executeWithPlan(session1, "SELECT COUNT(*) from lineitem"));
            Session session2 = Session.builder((Session)session1).setSystemProperty("required_workers_count", "3").build();
            ListenableFuture queryFuture2 = service.submit(() -> queryRunner.executeWithPlan(session2, "SELECT COUNT(*) from lineitem"));
            Session session3 = Session.builder((Session)session1).setSystemProperty("required_workers_count", "4").build();
            ListenableFuture queryFuture3 = service.submit(() -> queryRunner.executeWithPlan(session3, "SELECT COUNT(*) from lineitem"));
            TimeUnit.MILLISECONDS.sleep(1000L);
            Assertions.assertThat((boolean)queryFuture1.isDone()).isFalse();
            Assertions.assertThat((boolean)queryFuture2.isDone()).isFalse();
            Assertions.assertThat((boolean)queryFuture3.isDone()).isFalse();
            queryRunner.addServers(1);
            Assertions.assertThat((Collection)queryRunner.getCoordinator().refreshNodes().getActiveNodes()).hasSize(2);
            TimeUnit.MILLISECONDS.sleep(1000L);
            Assertions.assertThat((((QueryRunner.MaterializedResultWithPlan)queryFuture1.get()).result().getRowCount() > 0 ? 1 : 0) != 0).isTrue();
            QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
            QueryInfo completedQueryInfo = queryManager.getFullQueryInfo(((QueryRunner.MaterializedResultWithPlan)queryFuture1.get()).queryId());
            Assertions.assertThat((completedQueryInfo.getQueryStats().getResourceWaitingTime().roundTo(TimeUnit.SECONDS) >= 1L ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((boolean)queryFuture2.isDone()).isFalse();
            Assertions.assertThat((boolean)queryFuture3.isDone()).isFalse();
            queryRunner.addServers(2);
            Assertions.assertThat((Collection)queryRunner.getCoordinator().refreshNodes().getActiveNodes()).hasSize(4);
            Assertions.assertThat((((QueryRunner.MaterializedResultWithPlan)queryFuture2.get()).result().getRowCount() > 0 ? 1 : 0) != 0).isTrue();
            completedQueryInfo = queryManager.getFullQueryInfo(((QueryRunner.MaterializedResultWithPlan)queryFuture2.get()).queryId());
            Assertions.assertThat((completedQueryInfo.getQueryStats().getResourceWaitingTime().roundTo(TimeUnit.SECONDS) >= 2L ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((((QueryRunner.MaterializedResultWithPlan)queryFuture3.get()).result().getRowCount() > 0 ? 1 : 0) != 0).isTrue();
            completedQueryInfo = queryManager.getFullQueryInfo(((QueryRunner.MaterializedResultWithPlan)queryFuture3.get()).queryId());
            Assertions.assertThat((completedQueryInfo.getQueryStats().getResourceWaitingTime().roundTo(TimeUnit.SECONDS) >= 2L ? 1 : 0) != 0).isTrue();
        }
        finally {
            service.shutdown();
        }
    }
}

