/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.Session;
import io.trino.connector.MockConnectorEntities;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.connector.TestingTableFunctions;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.base.session.PropertyMetadataUtil;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.procedure.TestProcedure;
import io.trino.spi.Plugin;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableProcedureExecutionMode;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.metrics.Metrics;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMockConnector
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().build()).build();
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch");
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withListSchemaNames(connectionSession -> ImmutableList.of((Object)"default")).withGetColumns(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("default", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_SCHEMA;
            }
            return ImmutableList.of((Object)new ColumnMetadata("nationkey", (Type)BigintType.BIGINT));
        }).withGetTableHandle((session, tableName) -> {
            if (tableName.equals((Object)new SchemaTableName("default", "new_table"))) {
                return null;
            }
            return new MockConnectorTableHandle(tableName);
        }).withGetViews((session, schemaTablePrefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "test_view"), (Object)new ConnectorViewDefinition("SELECT nationkey FROM mock.default.test_table", Optional.of("mock"), Optional.of("default"), (List)ImmutableList.of((Object)new ConnectorViewDefinition.ViewColumn("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.empty(), Optional.of("alice"), false, (List)ImmutableList.of()))).withGetMaterializedViewProperties(() -> ImmutableList.of((Object)PropertyMetadataUtil.durationProperty((String)"refresh_interval", (String)"Time interval after which materialized view will be refreshed", null, (boolean)false))).withGetMaterializedViews((session, schemaTablePrefix) -> ImmutableMap.of((Object)new SchemaTableName("default", "test_materialized_view"), (Object)new ConnectorMaterializedViewDefinition("SELECT nationkey FROM mock.default.test_table", Optional.of(new CatalogSchemaTableName("mock", "default", "test_storage")), Optional.of("mock"), Optional.of("default"), (List)ImmutableList.of((Object)new ConnectorMaterializedViewDefinition.Column("nationkey", BigintType.BIGINT.getTypeId(), Optional.empty())), Optional.of(Duration.ZERO), Optional.empty(), Optional.of("alice"), (List)ImmutableList.of()))).withData(schemaTableName -> {
            if (schemaTableName.equals((Object)new SchemaTableName("default", "nation"))) {
                return MockConnectorEntities.TPCH_NATION_DATA;
            }
            throw new UnsupportedOperationException();
        }).withMetrics(schemaTableName -> new Metrics((Map)ImmutableMap.of((Object)"test_metric", (Object)new LongCount(1L)))).withProcedures((Iterable)ImmutableSet.of((Object)new TestProcedure().get())).withTableProcedures((Iterable)ImmutableSet.of((Object)new TableProcedureMetadata("TESTING_TABLE_PROCEDURE", TableProcedureExecutionMode.coordinatorOnly(), (List)ImmutableList.of()))).withTableFunctions((Iterable)ImmutableSet.of((Object)new TestingTableFunctions.SimpleTableFunction())).withSchemaProperties(() -> ImmutableList.of((Object)PropertyMetadata.booleanProperty((String)"boolean_schema_property", (String)"description", (Boolean)false, (boolean)false))).withTableProperties(() -> ImmutableList.of((Object)PropertyMetadata.integerProperty((String)"integer_table_property", (String)"description", (Integer)0, (boolean)false))).build()));
        queryRunner.createCatalog("mock", "mock");
        return queryRunner;
    }

    @Test
    public void testCreateSchema() {
        this.assertUpdate("CREATE SCHEMA mock.new_schema");
    }

    @Test
    public void testDropSchema() {
        this.assertUpdate("DROP SCHEMA mock.default");
    }

    @Test
    public void testRenameSchema() {
        this.assertUpdate("ALTER SCHEMA mock.default RENAME to renamed");
    }

    @Test
    public void testViewComment() {
        this.assertUpdate("COMMENT ON VIEW mock.default.test_view IS 'new comment'");
    }

    @Test
    public void testCreateMaterializedView() {
        this.assertUpdate("CREATE MATERIALIZED VIEW mock.default.materialized_view WITH (refresh_interval = '1h') AS SELECT * FROM tpch.tiny.nation");
    }

    @Test
    public void testRefreshMaterializedView() {
        this.assertUpdate("REFRESH MATERIALIZED VIEW mock.default.test_materialized_view", 0L);
    }

    @Test
    public void testDropMaterializedView() {
        this.assertUpdate("DROP MATERIALIZED VIEW mock.default.test_materialized_view");
    }

    @Test
    public void testDataGeneration() {
        this.assertQuery("SELECT * FROM mock.default.nation", "SELECT * FROM nation");
        this.assertQuery("SELECT nationkey FROM mock.default.nation", "SELECT nationkey FROM nation");
        this.assertQuery("SELECT nationkey, regionkey FROM mock.default.nation", "SELECT nationkey, regionkey FROM nation");
        this.assertQuery("SELECT regionkey, nationkey FROM mock.default.nation", "SELECT regionkey, nationkey FROM nation");
        this.assertQuery("SELECT regionkey FROM mock.default.nation", "SELECT regionkey FROM nation");
    }

    @Test
    public void testInsert() {
        this.assertQuery("SELECT count(*) FROM mock.default.nation", "SELECT 25");
        this.assertUpdate("INSERT INTO mock.default.nation VALUES (101, 'POLAND', 0, 'No comment')", 1L);
        this.assertQuery("SELECT count(*) FROM mock.default.nation", "SELECT 25");
    }

    @Test
    public void testDelete() {
        this.assertQuery("SELECT count(*) FROM mock.default.nation", "SELECT 25");
        this.assertUpdate("DELETE FROM mock.default.nation", 25L);
        this.assertUpdate("DELETE FROM mock.default.nation WHERE nationkey = 1", 1L);
        this.assertUpdate("DELETE FROM mock.default.nation WHERE false", 0L);
        this.assertQuery("SELECT count(*) FROM mock.default.nation", "SELECT 25");
    }

    @Test
    public void testUpdate() {
        this.assertQuery("SELECT count(*) FROM mock.default.nation WHERE name = 'ALGERIA'", "SELECT 1");
        this.assertUpdate("UPDATE mock.default.nation SET name = 'ALGERIA'", 25L);
        this.assertUpdate("UPDATE mock.default.nation SET name = 'ALGERIA' WHERE nationkey = 1", 1L);
        this.assertUpdate("UPDATE mock.default.nation SET name = 'x' WHERE false", 0L);
        this.assertQuery("SELECT count(*) FROM mock.default.nation WHERE name = 'ALGERIA'", "SELECT 1");
    }

    @Test
    public void testProcedure() {
        this.assertUpdate("CALL mock.default.test_procedure()");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CALL mock.default.non_exist_procedure()")).hasMessage("Procedure not registered: default.non_exist_procedure");
    }

    @Test
    public void testTableProcedure() {
        this.assertQuerySucceeds("ALTER TABLE mock.default.test_table EXECUTE TESTING_TABLE_PROCEDURE()");
        this.assertQueryFails("ALTER TABLE mock.default.test_table EXECUTE NON_EXISTING_TABLE_PROCEDURE()", "Table procedure not registered: NON_EXISTING_TABLE_PROCEDURE");
    }

    @Test
    public void testTableFunction() {
        Assertions.assertThatThrownBy(() -> this.assertUpdate("SELECT * FROM TABLE(mock.system.simple_table_function())")).hasMessage("missing ConnectorSplitSource for table function handle SimpleTableFunctionHandle");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("SELECT * FROM TABLE(mock.system.non_existing_table_function())")).hasMessageContaining("Table function 'mock.system.non_existing_table_function' not registered");
    }

    @Test
    public void testSchemaProperties() {
        this.assertUpdate("CREATE SCHEMA mock.test_schema WITH (boolean_schema_property = true)");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE SCHEMA mock.test_schema WITH (unknown_property = true)")).hasMessage("line 1:38: Catalog 'mock' schema property 'unknown_property' does not exist");
    }

    @Test
    public void testExecuteWithSchemaProperties() {
        String query = "CREATE SCHEMA mock.test_schema WITH (boolean_schema_property = ?)";
        Session session = Session.builder((Session)this.getSession()).addPreparedStatement("my_query", query).build();
        this.computeActual(session, "EXECUTE my_query USING true");
    }

    @Test
    public void testTableProperties() {
        this.assertUpdate("CREATE TABLE mock.default.new_table (c int) WITH (integer_table_property = 1)");
        Assertions.assertThatThrownBy(() -> this.assertUpdate("CREATE TABLE mock.default.new_table (c int) WITH (unknown_property = 1)")).hasMessage("line 1:51: Catalog 'mock' table property 'unknown_property' does not exist");
    }
}

