/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorPlugin;
import io.trino.spi.Plugin;
import io.trino.spi.connector.ConnectorFactory;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.ProcedureTester;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingProcedures;
import io.trino.testing.TestingSession;
import io.trino.tests.tpch.TpchQueryRunner;
import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.SAME_THREAD)
public class TestProcedureCall
extends AbstractTestQueryFramework {
    private static final String TESTING_CATALOG = "testing_catalog";
    private static final String PROCEDURE_SCHEMA = "procedure_schema";
    private ProcedureTester tester;
    private Session session;

    protected QueryRunner createQueryRunner() throws Exception {
        return TpchQueryRunner.builder().build();
    }

    @BeforeAll
    public void setUp() {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        this.tester = queryRunner.getCoordinator().getProcedureTester();
        this.session = TestingSession.testSessionBuilder().setCatalog(TESTING_CATALOG).setSchema(PROCEDURE_SCHEMA).build();
        queryRunner.installPlugin((Plugin)new MockConnectorPlugin((ConnectorFactory)MockConnectorFactory.builder().withProcedures((Iterable)new TestingProcedures(this.tester).getProcedures(PROCEDURE_SCHEMA)).build()));
        queryRunner.createCatalog(TESTING_CATALOG, "mock");
    }

    @AfterAll
    public void tearDown() {
        this.tester = null;
        this.session = null;
    }

    protected Session getSession() {
        return this.session;
    }

    @Test
    public void testProcedureCall() {
        this.assertCall("CALL test_simple()", "simple", new Object[0]);
        this.assertCall(String.format("CALL %s.test_simple()", PROCEDURE_SCHEMA), "simple", new Object[0]);
        this.assertCall(String.format("CALL %s.%s.test_simple()", TESTING_CATALOG, PROCEDURE_SCHEMA), "simple", new Object[0]);
        this.assertCall("CALL test_args(123, 4.5, 'hello', true)", "args", 123L, 4.5, "hello", true);
        this.assertCall("CALL test_args(-5, nan(), 'bye', false)", "args", -5L, Double.NaN, "bye", false);
        this.assertCall("CALL test_args(3, 88, 'coerce', true)", "args", 3L, 88.0, "coerce", true);
        this.assertCall("CALL test_args(x => 123, y => 4.5, z => 'hello', q => true)", "args", 123L, 4.5, "hello", true);
        this.assertCall("CALL test_args(q => true, z => 'hello', y => 4.5, x => 123)", "args", 123L, 4.5, "hello", true);
        this.assertCall("CALL test_nulls(123, null)", "nulls", 123L, null);
        this.assertCall("CALL test_nulls(null, 'apple')", "nulls", null, "apple");
        this.assertCall("CALL test_arrays(ARRAY [12, 34], ARRAY['abc', 'xyz'])", "arrays", TestProcedureCall.list(12L, 34L), TestProcedureCall.list("abc", "xyz"));
        this.assertCall("CALL test_arrays(ARRAY [], ARRAY[])", "arrays", TestProcedureCall.list(new Object[0]), TestProcedureCall.list(new Object[0]));
        this.assertCall("CALL test_nested(ARRAY [ARRAY[12, 34], ARRAY[56]])", "nested", TestProcedureCall.list(TestProcedureCall.list(12L, 34L), TestProcedureCall.list(56L)));
        this.assertCall("CALL test_nested(ARRAY [])", "nested", TestProcedureCall.list(new Object[0]));
        this.assertCall("CALL test_nested(ARRAY [ARRAY[]])", "nested", TestProcedureCall.list(TestProcedureCall.list(new Object[0])));
        this.assertCall("CALL test_session_first(123)", "session_first", 123L);
        this.assertCall("CALL test_session_last('grape')", "session_last", "grape");
        this.assertCallThrows("CALL test_exception()", "exception", "test exception from procedure");
        this.assertCallThrows("CALL test_error()", "error", "test error from procedure");
        this.assertCallFails("CALL test_args(null, 4.5, 'hello', true)", "Procedure argument cannot be null: X");
        this.assertCallFails("CALL test_args(123, null, 'hello', true)", "Procedure argument cannot be null: Y");
        this.assertCallFails("CALL test_args(123, 4.5, 'hello', null)", "Procedure argument cannot be null: Q");
        this.assertCallFails("CALL test_simple(123)", "line 1:1: Too many arguments for procedure");
        this.assertCallFails("CALL test_args(123, 4.5, 'hello')", "line 1:1: Required procedure argument 'Q' is missing");
        this.assertCallFails("CALL test_args(x => 123, y => 4.5, q => true)", "line 1:1: Required procedure argument 'Z' is missing");
        this.assertCallFails("CALL test_args(123, 4.5, 'hello', q => true)", "line 1:1: Named and positional arguments cannot be mixed");
        this.assertCallFails("CALL test_args(x => 3, x => 4)", "line 1:24: Duplicate procedure argument: X");
        this.assertCallFails("CALL test_args(t => 404)", "line 1:16: Unknown argument name: T");
        this.assertCallFails("CALL test_nulls('hello', null)", "line 1:17: Cannot cast type varchar(5) to bigint");
        this.assertCallFails("CALL test_nulls(null, 123)", "line 1:23: Cannot cast type integer to varchar");
    }

    @Test
    public void testProcedureCallWithOptionals() {
        this.assertCall("CALL test_optionals()", "optionals", "hello");
        this.assertCall("CALL test_optionals(x => 'x')", "optionals", "x");
        this.assertCall("CALL test_optionals2(x => 'ab')", "optionals2", "ab", "world");
        this.assertCall("CALL test_optionals2('ab')", "optionals2", "ab", "world");
        this.assertCall("CALL test_optionals2(x => 'ab', y => 'cd')", "optionals2", "ab", "cd");
        this.assertCall("CALL test_optionals2(y => 'cd', x => 'ab')", "optionals2", "ab", "cd");
        this.assertCall("CALL test_optionals2('ab', 'cd')", "optionals2", "ab", "cd");
        this.assertCall("CALL test_optionals3(x => 'ab', z => 'cd')", "optionals3", "ab", "is", "cd");
        this.assertCall("CALL test_optionals3('ab', 'cd', 'ef')", "optionals3", "ab", "cd", "ef");
        this.assertCall("CALL test_optionals3('ab', 'cd')", "optionals3", "ab", "cd", "default");
        this.assertCall("CALL test_optionals3('ab')", "optionals3", "ab", "is", "default");
        this.assertCall("CALL test_optionals3(y => 'ab', z => 'cd')", "optionals3", "this", "ab", "cd");
        this.assertCall("CALL test_optionals3(z => 'cd')", "optionals3", "this", "is", "cd");
        this.assertCall("CALL test_optionals4('a', 'b')", "optionals4", "a", "b", "z default", "v default");
        this.assertCall("CALL test_optionals4(x => 'x val', y => 'y val')", "optionals4", "x val", "y val", "z default", "v default");
        this.assertCall("CALL test_optionals4(z => 'z val', v => 'v val', x => 'x val', y => 'y val')", "optionals4", "x val", "y val", "z val", "v val");
        this.assertCall("CALL test_optionals4(v => 'v val', x => 'x val', y => 'y val', z => 'z val')", "optionals4", "x val", "y val", "z val", "v val");
        this.assertCallFails("CALL test_optionals2()", "line 1:1: Required procedure argument 'X' is missing");
        this.assertCallFails("CALL test_optionals4(z => 'cd')", "line 1:1: Required procedure argument 'X' is missing");
        this.assertCallFails("CALL test_optionals4(z => 'cd', v => 'value')", "line 1:1: Required procedure argument 'X' is missing");
        this.assertCallFails("CALL test_optionals4(y => 'cd', v => 'value')", "line 1:1: Required procedure argument 'X' is missing");
    }

    @Test
    public void testProcedureName() {
        this.assertCall("CALL test_lowercase_name()", "simple", new Object[0]);
        this.assertCall("CALL TEST_LOWERCASE_NAME()", "simple", new Object[0]);
        this.assertCall("CALL Test_Lowercase_NAME()", "simple", new Object[0]);
        this.assertCall("CALL \"test_lowercase_name\"()", "simple", new Object[0]);
        this.assertCall("CALL \"TEST_LOWERCASE_NAME\"()", "simple", new Object[0]);
        this.assertCall("CALL \"Test_Lowercase_Name\"()", "simple", new Object[0]);
        this.assertCall("CALL test_uppercase_name()", "simple", new Object[0]);
        this.assertCall("CALL TEST_UPPERCASE_NAME()", "simple", new Object[0]);
        this.assertCall("CALL Test_Uppercase_NAME()", "simple", new Object[0]);
        this.assertCall("CALL \"test_uppercase_name\"()", "simple", new Object[0]);
        this.assertCall("CALL \"TEST_UPPERCASE_NAME\"()", "simple", new Object[0]);
        this.assertCall("CALL \"Test_Uppercase_NAME\"()", "simple", new Object[0]);
    }

    @Test
    public void testNamedArguments() {
        this.assertCallFails("CALL test_argument_names(lower => 'a')", "line 1:26: Unknown argument name: LOWER");
        this.assertCallFails("CALL test_argument_names(LOWER => 'a')", "line 1:26: Unknown argument name: LOWER");
        this.assertCall("CALL test_argument_names(\"lower\" => 'a')", "names", "a", "b", "c", "d");
        this.assertCallFails("CALL test_argument_names(\"LOWER\" => 'a')", "line 1:26: Unknown argument name: LOWER");
        this.assertCall("CALL test_argument_names(upper => 'b')", "names", "a", "b", "c", "d");
        this.assertCall("CALL test_argument_names(UPPER => 'b')", "names", "a", "b", "c", "d");
        this.assertCallFails("CALL test_argument_names(\"upper\" => 'b')", "line 1:26: Unknown argument name: upper");
        this.assertCall("CALL test_argument_names(\"UPPER\" => 'b')", "names", "a", "b", "c", "d");
        this.assertCallFails("CALL test_argument_names(mixed => 'c')", "line 1:26: Unknown argument name: MIXED");
        this.assertCallFails("CALL test_argument_names(MixeD => 'c')", "line 1:26: Unknown argument name: MIXED");
        this.assertCallFails("CALL test_argument_names(MIXED => 'c')", "line 1:26: Unknown argument name: MIXED");
        this.assertCallFails("CALL test_argument_names(\"mixed\" => 'c')", "line 1:26: Unknown argument name: mixed");
        this.assertCall("CALL test_argument_names(\"MixeD\" => 'c')", "names", "a", "b", "c", "d");
        this.assertCallFails("CALL test_argument_names(\"MIXED\" => 'c')", "line 1:26: Unknown argument name: MIXED");
        this.assertCall("CALL test_argument_names(\"with space\" => 'd')", "names", "a", "b", "c", "d");
    }

    private void assertCall(@Language(value="SQL") String sql, String name, Object ... arguments) {
        this.tester.reset();
        this.assertUpdate(sql);
        Assertions.assertThat((String)this.tester.getCalledName()).isEqualTo(name);
        Assertions.assertThat((List)this.tester.getCalledArguments()).isEqualTo(TestProcedureCall.list(arguments));
    }

    private void assertCallThrows(@Language(value="SQL") String sql, String name, String message) {
        this.tester.reset();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertUpdate(sql)).isInstanceOfSatisfying(RuntimeException.class, e -> {
            Assertions.assertThat((String)this.tester.getCalledName()).isEqualTo(name);
            Assertions.assertThat((List)this.tester.getCalledArguments()).isEqualTo(TestProcedureCall.list(new Object[0]));
        })).hasMessage(message);
    }

    private void assertCallFails(@Language(value="SQL") String sql, String message) {
        this.tester.reset();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertUpdate(sql)).isInstanceOfSatisfying(RuntimeException.class, e -> Assertions.assertThat((boolean)this.tester.wasCalled()).isFalse())).hasMessage(message);
    }

    @SafeVarargs
    private static <T> List<T> list(T ... elements) {
        return Arrays.asList(elements);
    }
}

