/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.collect.ImmutableList;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.util.Reflection;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProcedureCreation {
    @Test
    public void shouldThrowExceptionWhenOptionalArgumentIsNotLast() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestProcedureCreation.createTestProcedure((List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("NAME", (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument("NAME2", (Type)VarcharType.VARCHAR, true, null)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Optional arguments should follow required ones");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestProcedureCreation.createTestProcedure((List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("NAME", (Type)VarcharType.VARCHAR, true, null), (Object)new Procedure.Argument("NAME2", (Type)VarcharType.VARCHAR, true, null), (Object)new Procedure.Argument("NAME3", (Type)VarcharType.VARCHAR, true, null), (Object)new Procedure.Argument("NAME4", (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument("NAME5", (Type)VarcharType.VARCHAR, true, null)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Optional arguments should follow required ones");
    }

    @Test
    public void shouldThrowExceptionWhenArgumentNameRepeates() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestProcedureCreation.createTestProcedure((List<Procedure.Argument>)ImmutableList.of((Object)new Procedure.Argument("NAME", (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument("NAME", (Type)VarcharType.VARCHAR, true, null)))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Duplicate argument name: 'NAME'");
    }

    @Test
    public void shouldThrowExceptionWhenProcedureIsNonVoid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Procedure("schema", "name", (List)ImmutableList.of(), Reflection.methodHandle(Procedures.class, (String)"funWithoutArguments", (Class[])new Class[0]))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Method must return void");
    }

    @Test
    public void shouldThrowExceptionWhenMethodHandleIsNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Procedure("schema", "name", (List)ImmutableList.of(), null)).isInstanceOf(NullPointerException.class)).hasMessage("methodHandle is null");
    }

    @Test
    public void shouldThrowExceptionWhenMethodHandleHasVarargs() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Procedure("schema", "name", (List)ImmutableList.of(), Reflection.methodHandle(Procedures.class, (String)"funWithVarargs", (Class[])new Class[]{String[].class}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Method must have fixed arity");
    }

    @Test
    public void shouldThrowExceptionWhenArgumentCountDoesntMatch() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new Procedure("schema", "name", (List)ImmutableList.of((Object)new Procedure.Argument("NAME", (Type)VarcharType.VARCHAR, true, null), (Object)new Procedure.Argument("NAME2", (Type)VarcharType.VARCHAR, true, null), (Object)new Procedure.Argument("NAME3", (Type)VarcharType.VARCHAR, true, null)), Reflection.methodHandle(Procedures.class, (String)"fun1", (Class[])new Class[]{ConnectorSession.class, Object.class}))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Method parameter count must match arguments");
    }

    private static Procedure createTestProcedure(List<Procedure.Argument> arguments) {
        int argumentsCount = arguments.size();
        String functionName = "fun" + argumentsCount;
        Class[] clazzes = new Class[argumentsCount + 1];
        clazzes[0] = ConnectorSession.class;
        for (int i = 0; i < argumentsCount; ++i) {
            clazzes[i + 1] = Object.class;
        }
        return new Procedure("schema", "name", arguments, Reflection.methodHandle(Procedures.class, (String)functionName, (Class[])clazzes));
    }

    public static class Procedures {
        public void fun0(ConnectorSession session) {
        }

        public void fun1(ConnectorSession session, Object arg1) {
        }

        public void fun2(ConnectorSession session, Object arg1, Object arg2) {
        }

        public void fun2(Object arg1, Object arg2) {
        }

        public void fun3(ConnectorSession session, Object arg1, Object arg2, Object arg3) {
        }

        public void fun4(ConnectorSession session, Object arg1, Object arg2, Object arg3, Object arg4) {
        }

        public void fun5(ConnectorSession session, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        }

        public String funWithoutArguments() {
            return "";
        }

        public void funWithVarargs(String ... arguments) {
        }
    }
}

