/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import io.airlift.testing.Closeables;
import io.trino.Session;
import io.trino.plugin.jdbc.JdbcPlugin;
import io.trino.plugin.jdbc.TestingH2JdbcModule;
import io.trino.plugin.tpch.TpchPlugin;
import io.trino.spi.Plugin;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryAssertions;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestQueryAssertions
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        DistributedQueryRunner queryRunner = DistributedQueryRunner.builder((Session)TestingSession.testSessionBuilder().setCatalog("jdbc").setSchema("public").build()).build();
        try {
            this.configureCatalog((QueryRunner)queryRunner);
        }
        catch (Throwable e) {
            Closeables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{queryRunner});
            throw e;
        }
        return queryRunner;
    }

    protected void configureCatalog(QueryRunner queryRunner) {
        queryRunner.installPlugin((Plugin)new TpchPlugin());
        queryRunner.createCatalog("tpch", "tpch", (Map)ImmutableMap.of());
        queryRunner.installPlugin((Plugin)new JdbcPlugin("base_jdbc", TestingH2JdbcModule::new));
        Map jdbcConfigurationProperties = TestingH2JdbcModule.createProperties();
        queryRunner.createCatalog("jdbc", "base_jdbc", jdbcConfigurationProperties);
        try (Connection connection = DriverManager.getConnection((String)jdbcConfigurationProperties.get("connection-url"));
             Statement statement = connection.createStatement();){
            statement.execute("CREATE SCHEMA tpch");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        QueryAssertions.copyTpchTables((QueryRunner)queryRunner, (String)"tpch", (String)"tiny", List.of(TpchTable.NATION));
        ImmutableMap jdbcWithAggregationPushdownDisabledConfigurationProperties = ImmutableMap.builder().putAll(jdbcConfigurationProperties).put((Object)"aggregation-pushdown.enabled", (Object)"false").buildOrThrow();
        queryRunner.createCatalog("jdbc_with_aggregation_pushdown_disabled", "base_jdbc", (Map)jdbcWithAggregationPushdownDisabledConfigurationProperties);
    }

    @Test
    public void testMatches() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE nationkey = 3"))).matches("VALUES CAST('CANADA' AS varchar(25))");
    }

    @Test
    public void testQueryFails() {
        this.assertQueryFails("SELECT CAST('123a' AS integer)", "Cannot cast '123a' to INT");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertQueryFails("SELECT CAST('123a' AS integer)", "Different expected message")).isInstanceOf(AssertionError.class)).hasMessageStartingWith("\nExpecting message:\n  \"Cannot cast '123a' to INT\"\nto match regex:\n  \"Different expected message\"\nbut did not.\n\nThrowable that failed the check:");
        this.assertQueryFails("SELECT CAST('123a' AS integer)", "Cannot cast '\\w+' (to)? INT");
        this.assertQueryFails("SELECT fail('Some (message|with).pattern-likes++')", Pattern.quote("Some (message|with).pattern-likes++"));
        this.assertQueryFails("SELECT CAST('123a' AS integer)", "^Cannot cast '123a' to INT$");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertQueryFails("SELECT CAST('123a' AS integer)", "Cannot cast")).isInstanceOf(AssertionError.class)).hasMessageStartingWith("\nExpecting message:\n  \"Cannot cast '123a' to INT\"\nto match regex:\n  \"Cannot cast\"\nbut did not.\n\nThrowable that failed the check:");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertQueryFails("SELECT 1", "Foo bar")).isInstanceOf(AssertionError.class)).hasMessageMatching("Expected query to fail: SELECT 1 \\[QueryId: \\w+]");
    }

    @Test
    public void testQueryFailsVerifiesEndUserVisibleMessage() {
        String sql = "SELECT CAST('abc' AS date)";
        try {
            this.computeActual(sql);
            throw new IllegalStateException("Expected query failure");
        }
        catch (Exception expected) {
            String lastMessage = ((Throwable)Throwables.getCausalChain((Throwable)expected).getLast()).getMessage();
            Assertions.assertThat((String)lastMessage).isEqualTo("Invalid format: \"abc\"");
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.assertQueryFails(sql, Pattern.quote(lastMessage))).isInstanceOf(AssertionError.class)).hasMessageStartingWith("\nExpecting message:\n  \"Value cannot be cast to date: abc\"\nto match regex:\n  \"\\QInvalid format: \"abc\"\\E\"\nbut did not.\n\nThrowable that failed the check:");
            return;
        }
    }

    @Test
    public void testWrongType() {
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT X'001234'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("VALUES '001234'")).hasMessageContaining("[Output types for query [SELECT X'001234']] \nexpected: [varchar(6)]\n but was: [varbinary]\n");
    }

    @Test
    public void testWrongTypeWithEmptyResult() {
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT X'001234' WHERE false"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT '001234' WHERE false")).hasMessageContaining("[Output types for query [SELECT X'001234' WHERE false]] \nexpected: [varchar(6)]\n but was: [varbinary]\n");
    }

    @Test
    public void testReturnsEmptyResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 'foobar' WHERE false"))).returnsEmptyResult();
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("VALUES 'foobar'"));
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)queryAssert).returnsEmptyResult()).hasMessageContaining("[Rows for query [VALUES 'foobar']] \nExpecting empty but was: (foobar)");
        queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("VALUES 'foo', 'bar'"));
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)queryAssert).returnsEmptyResult()).hasMessageContaining("[Rows for query [VALUES 'foo', 'bar']] \nExpecting empty but was: (foo), (bar)");
    }

    @Test
    public void testVarbinaryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT X'001234'"))).matches("VALUES X'001234'");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT X'001234'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("VALUES X'001299'")).hasMessageMatching("(?s).*\\QExpecting actual:\n  ([0, 18, 52])\nto contain exactly in any order:\n  [([0, 18, -103])]\nelements not found:\n  ([0, 18, -103])\nand elements not expected:\n  ([0, 18, 52])\\E.*");
    }

    @Test
    public void testNestedVarbinaryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(ROW(X'001234') AS ROW(foo varbinary))"))).matches("SELECT CAST(ROW(X'001234') AS ROW(foo varbinary))");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT CAST(ROW(X'001234') AS ROW(foo varbinary))"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT CAST(ROW(X'001299') AS ROW(foo varbinary))")).hasMessageMatching("(?s).*\\QExpecting actual:\n  ([X'00 12 34'])\nto contain exactly in any order:\n  [([X'00 12 99'])]\nelements not found:\n  ([X'00 12 99'])\nand elements not expected:\n  ([X'00 12 34'])\\E.*");
    }

    @Test
    public void testTimeQueryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123'"))).matches("SELECT TIME '01:23:45.123'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456'"))).matches("SELECT TIME '01:23:45.123456'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789'"))).matches("SELECT TIME '01:23:45.123456789'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789012'"))).matches("SELECT TIME '01:23:45.123456789012'");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789012'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIME '01:23:45.123456789013'")).hasMessageContaining("Expecting actual:\n  (01:23:45.123456789012)\nto contain exactly in any order:\n  [(01:23:45.123456789013)]");
    }

    @Test
    public void testTimeWithTimeZoneQueryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123 +05:07'"))).matches("SELECT TIME '01:23:45.123 +05:07'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456 +05:07'"))).matches("SELECT TIME '01:23:45.123456 +05:07'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789 +05:07'"))).matches("SELECT TIME '01:23:45.123456789 +05:07'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789012 +05:07'"))).matches("SELECT TIME '01:23:45.123456789012 +05:07'");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIME '01:23:45.123456789012 +05:07'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIME '01:23:45.123456789013 +05:07'")).hasMessageContaining("Expecting actual:\n  (01:23:45.123456789012+05:07)\nto contain exactly in any order:\n  [(01:23:45.123456789013+05:07)]");
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIME '01:23:45.123456789012 +05:42'")).hasMessageContaining("Expecting actual:\n  (01:23:45.123456789012+05:07)\nto contain exactly in any order:\n  [(01:23:45.123456789012+05:42)]");
    }

    @Test
    public void testTimestampQueryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012'");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789013'")).hasMessageContaining("Expecting actual:\n  (2017-01-02 09:12:34.123456789012)\nto contain exactly in any order:\n  [(2017-01-02 09:12:34.123456789013)]");
    }

    @Test
    public void testTimestampWithTimeZoneQueryResult() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123 Europe/Warsaw'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123 Europe/Warsaw'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456 Europe/Warsaw'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456 Europe/Warsaw'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789 Europe/Warsaw'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789 Europe/Warsaw'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Warsaw'"))).matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Warsaw'");
        QueryAssertions.QueryAssert queryAssert = (QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Warsaw'"));
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789013 Europe/Warsaw'")).hasMessageContaining("Expecting actual:\n  (2017-01-02 09:12:34.123456789012 Europe/Warsaw)\nto contain exactly in any order:\n  [(2017-01-02 09:12:34.123456789013 Europe/Warsaw)]");
        Assertions.assertThatThrownBy(() -> queryAssert.matches("SELECT TIMESTAMP '2017-01-02 09:12:34.123456789012 Europe/Paris'")).hasMessageContaining("Expecting actual:\n  (2017-01-02 09:12:34.123456789012 Europe/Warsaw)\nto contain exactly in any order:\n  [(2017-01-02 09:12:34.123456789012 Europe/Paris)]");
    }

    @Test
    public void testIsFullyPushedDown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation"))).isFullyPushedDown();
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE rand() = 42"))).isFullyPushedDown()).hasMessageContaining("Plan does not match, expected [\n\n- node(OutputNode)\n").hasMessageContaining("\n\n] but found [\n\nOutput[columnNames = [name]]\n");
    }

    @Test
    public void testIsFullyPushedDownWithSession() {
        Session baseSession = Session.builder((Session)this.getSession()).setCatalog("jdbc_with_aggregation_pushdown_disabled").build();
        Session sessionWithAggregationPushdown = Session.builder((Session)baseSession).setCatalogSessionProperty("jdbc_with_aggregation_pushdown_disabled", "aggregation_pushdown_enabled", "true").build();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT count(*) FROM nation"))).isFullyPushedDown();
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(baseSession, "SELECT count(*) FROM nation"))).isNotFullyPushedDown(AggregationNode.class, new Class[0]);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(sessionWithAggregationPushdown, "SELECT count(*) FROM nation"))).isFullyPushedDown();
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query(sessionWithAggregationPushdown, "SELECT count(*) FROM nation WHERE rand() = 42"))).isFullyPushedDown()).hasMessageContaining("Plan does not match, expected [\n\n- node(OutputNode)\n").hasMessageContaining("\n\n] but found [\n\nOutput[columnNames = [_col0]]\n");
    }

    @Test
    public void testIsReplacedWithEmptyValues() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 WHERE false"))).isReplacedWithEmptyValues();
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT 1 WHERE true"))).isReplacedWithEmptyValues()).hasMessageContaining("Plan does not match, expected [\n\n- node(OutputNode)\n").hasMessageContaining("\n\n] but found [\n\nOutput[columnNames = [_col0]]\n");
    }

    @Test
    public void testIsNotFullyPushedDown() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation WHERE rand() = 42"))).isNotFullyPushedDown(FilterNode.class, new Class[0]);
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SELECT name FROM nation"))).isNotFullyPushedDown(FilterNode.class, new Class[0])).hasMessageContaining("Plan does not match, expected [\n\n- anyTree\n    - node(FilterNode)\n").hasMessageContaining("\n\n] but found [\n\nOutput[columnNames = [name]]\n");
    }

    @Test
    public void testProjectedColumns() {
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().projected(new String[]{"Column"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().exceptColumns(new String[]{"Type", "Extra", "Comment"}).skippingTypesCheck().matches("VALUES 'nationkey', 'name', 'regionkey', 'comment'");
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().projected(new String[]{"Column", "Non_Existent"})).hasMessageContaining("[Non_Existent] column is not present in [Column, Type, Extra, Comment]");
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().exceptColumns(new String[]{"Type", "Extra", "Comment", "Non_Existent"})).hasMessageContaining("[Non_Existent] column is not present in [Column, Type, Extra, Comment]");
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().projected(new String[0])).hasMessageContaining("At least one column must be projected");
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().exceptColumns(new String[0])).hasMessageContaining("At least one column must be excluded");
        Assertions.assertThatThrownBy(() -> ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("SHOW COLUMNS FROM nation"))).result().exceptColumns(new String[]{"Column", "Type", "Extra", "Comment"})).hasMessageContaining("All columns cannot be excluded");
    }
}

