/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tests;

import io.opentelemetry.api.trace.Span;
import io.trino.Session;
import io.trino.SessionTestUtils;
import io.trino.dispatcher.DispatchManager;
import io.trino.execution.QueryInfo;
import io.trino.execution.QueryManager;
import io.trino.execution.QueryRunnerUtil;
import io.trino.execution.QueryState;
import io.trino.server.BasicQueryInfo;
import io.trino.server.SessionContext;
import io.trino.server.protocol.Slug;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.QueryId;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.tests.tpch.TpchQueryRunner;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestQueryManager {
    @Test
    @Timeout(value=60L)
    public void testFailQuery() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            DispatchManager dispatchManager = queryRunner.getCoordinator().getDispatchManager();
            QueryId queryId = dispatchManager.createQueryId();
            dispatchManager.createQuery(queryId, Span.getInvalid(), Slug.createNew(), SessionContext.fromSession((Session)SessionTestUtils.TEST_SESSION), "SELECT * FROM lineitem").get();
            while (true) {
                QueryState state;
                if ((state = dispatchManager.getQueryInfo(queryId).getState()).isDone()) {
                    Fail.fail((String)("unexpected query state: " + String.valueOf(state)));
                }
                if (state == QueryState.RUNNING) break;
                Thread.sleep(100L);
            }
            QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
            queryManager.failQuery(queryId, (Throwable)new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "mock exception"));
            QueryInfo queryInfo = queryManager.getFullQueryInfo(queryId);
            Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.GENERIC_INTERNAL_ERROR.toErrorCode());
            Assertions.assertThat((Object)queryInfo.getFailureInfo()).isNotNull();
            Assertions.assertThat((String)queryInfo.getFailureInfo().getMessage()).isEqualTo("mock exception");
        }
    }

    @Test
    @Timeout(value=60L)
    public void testQueryCpuLimit() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)TpchQueryRunner.builder().addExtraProperty("query.max-cpu-time", "1ms")).build();){
            QueryId queryId = QueryRunnerUtil.createQuery((QueryRunner)queryRunner, SessionTestUtils.TEST_SESSION, "SELECT COUNT(*) FROM lineitem");
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, queryId, QueryState.FAILED);
            QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
            BasicQueryInfo queryInfo = queryManager.getQueryInfo(queryId);
            Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.EXCEEDED_CPU_LIMIT.toErrorCode());
        }
    }

    @Test
    @Timeout(value=60L)
    public void testQueryScanExceeded() throws Exception {
        try (DistributedQueryRunner queryRunner = ((TpchQueryRunner.Builder)TpchQueryRunner.builder().addExtraProperty("query.max-scan-physical-bytes", "0B")).build();){
            Session session = queryRunner.getDefaultSession();
            QueryId queryId = QueryRunnerUtil.createQuery((QueryRunner)queryRunner, session, "SELECT * FROM system.runtime.nodes");
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, queryId, QueryState.FAILED);
            QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
            BasicQueryInfo queryInfo = queryManager.getQueryInfo(queryId);
            Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.EXCEEDED_SCAN_LIMIT.toErrorCode());
        }
    }

    @Test
    @Timeout(value=60L)
    public void testQueryScanExceededSession() throws Exception {
        try (DistributedQueryRunner queryRunner = TpchQueryRunner.builder().build();){
            Session session = Session.builder((Session)queryRunner.getDefaultSession()).setSystemProperty("query_max_scan_physical_bytes", "0B").build();
            QueryId queryId = QueryRunnerUtil.createQuery((QueryRunner)queryRunner, session, "SELECT * FROM system.runtime.nodes");
            QueryRunnerUtil.waitForQueryState((QueryRunner)queryRunner, queryId, QueryState.FAILED);
            QueryManager queryManager = queryRunner.getCoordinator().getQueryManager();
            BasicQueryInfo queryInfo = queryManager.getQueryInfo(queryId);
            Assertions.assertThat((Comparable)queryInfo.getState()).isEqualTo((Object)QueryState.FAILED);
            Assertions.assertThat((Object)queryInfo.getErrorCode()).isEqualTo((Object)StandardErrorCode.EXCEEDED_SCAN_LIMIT.toErrorCode());
        }
    }
}

